/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.ProtectionGroup;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.Equipment.xBusy;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xMissingEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProtectionGroupModels;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.UserValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class ProtectionGroupModel
extends Model {
    public static final int MAX_MAIN_MODULES = 5;
    public static final int MAX_MAIN_MODULES_FOR_DS3XM12 = 7;
    public static final int MAX_MAIN_MODULES_FOR_RAN_SVC = 9;
    private ProtectionGroup pgRef;
    private ModuleModel protectModuleModel;
    private boolean gotNewProtectModule;
    private Object protectModuleModelLock = new Object();
    private ModuleModel protectedModuleModel;
    private boolean gotNewProtectedModule;
    private Object protectedModuleModelLock = new Object();
    private ModuleModel[] mainModuleModels;
    private boolean gotNewMainModules;
    private Object mainModuleModelsLock = new Object();
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    private ProtectType protectType;
    private Name name;
    private AddModule addModule;
    private RemoveModule removeModule;
    private Reversion reversion;
    private Delete delete;
    private MainModules mainModules;
    private ProtectedModule protectedModule;
    private PgProtectModule pgProtectModule;
    private MainModuleValues mainModuleValues;
    private ProtectedModuleValue protectedModuleValue;
    private ProtectionType protectionType;
    private ProtectModule protectModule;
    private String whoAmI = null;

    public ProtectionGroupModel(ProtectionGroup protectionGroup, String string, eProtectionType eProtectionType2, ModuleModel moduleModel, ModuleModel[] moduleModelArray) {
        super(null);
        this.nmd = moduleModel.getNodeModelDelegate();
        this.setDebug(this.nmd.getChildDebug(ProtectionGroupModel.class));
        this.pgRef = protectionGroup;
        this.index = moduleModel.getEntityIndex();
        this.gotNewProtectedModule = false;
        this.gotNewProtectModule = false;
        this.gotNewMainModules = false;
        super.init0();
        this.initProtectionGroupModel(string, eProtectionType2, moduleModel, moduleModelArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProtectionGroupModel(String string, eProtectionType eProtectionType2, ModuleModel moduleModel, ModuleModel[] moduleModelArray) {
        int n;
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel");
        }
        int n2 = moduleModelArray == null ? 0 : moduleModelArray.length;
        int[] nArray = new int[n2];
        Object object = this.mainModuleModelsLock;
        synchronized (object) {
            this.mainModuleModels = new ModuleModel[n2];
            for (n = 0; n < n2; ++n) {
                this.mainModuleModels[n] = moduleModelArray[n];
                nArray[n] = this.mainModuleModels[n].getIndex();
            }
        }
        this.mainModules = new MainModules(this.nmd, "ProtectionGroupModel.mainModules");
        this.mainModules.setValueExternally(nArray);
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel -- main modules inited");
        }
        this.name = new Name(this.nmd, "ProtectionGroupModel.name");
        this.name.setValueExternally(string);
        this.protectType = new ProtectType(this.nmd, "ProtectionGroupModel.protectType");
        this.protectType.setValueExternally(eProtectionType2);
        this.reversion = new Reversion(this.nmd, "ProtectionGroupModel.reversion");
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel -- protect type inited");
        }
        this.protectedModule = new ProtectedModule(this.nmd, "ProtectionGroupModel.protectedModule");
        this.getProtectedModuleModel();
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel -- protected Module inited");
        }
        this.pgProtectModule = new PgProtectModule(this.nmd, "ProtectionGroupModel.pgProtectModule");
        object = this.protectModuleModelLock;
        synchronized (object) {
            this.protectModuleModel = moduleModel;
            if (this.protectModuleModel != null) {
                this.protectModuleModel.setInterfacesInited(true);
                this.pgProtectModule.setValueExternally(new Integer(this.protectModuleModel.getIndex()));
            }
        }
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel -- protect module inited");
        }
        this.addModule = new AddModule(this.nmd, "ProtectionGroupModel.addModule");
        this.removeModule = new RemoveModule(this.nmd, "ProtectionGroupModel.removeModule");
        this.delete = new Delete(this.nmd, "ProtectionGroupModel.delete");
        this.mainModuleValues = new MainModuleValues(this.nmd, "ProtectionGroupModel.mainModuleValues");
        this.protectedModuleValue = new ProtectedModuleValue(this.nmd, "ProtectionGroupModel.protectedModuleValue");
        this.protectionType = new ProtectionType(this.nmd, "ProtectionGroupModel.protectionType");
        this.protectModule = new ProtectModule(this.nmd, "ProtectionGroupModel.protectModule");
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectProtectionGroup, this.getIndex(), (Observer)this);
        }
        object = this.mainModuleModelsLock;
        synchronized (object) {
            for (n = 0; n < n2; ++n) {
                this.mainModuleModels[n].setProtectionGroupModel(this);
            }
        }
        object = this.protectModuleModelLock;
        synchronized (object) {
            if (this.protectModuleModel != null) {
                this.protectModuleModel.setProtectionGroupModel(this);
            }
        }
        if (this.db.on()) {
            this.db.println("initProtectionGroupModel -- done");
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public String getName() throws AbstractCmsIOException {
        try {
            return (String)this.name.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getName", userException);
        }
    }

    public void setName(String string) throws AbstractCmsIOException {
        try {
            this.name.set(string);
        }
        catch (UserException userException) {
            NodeModelDelegate.doUnknown(this.db, "setName", userException);
        }
    }

    public eProtectionType getProtectType() {
        try {
            return (eProtectionType)this.protectType.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getProtectType", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleModel getProtectModuleModel() {
        ModuleModel moduleModel;
        block11: {
            moduleModel = null;
            try {
                Integer n = (Integer)this.pgProtectModule.get();
                if (n != null) {
                    moduleModel = (ModuleModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
                }
                if (!this.gotNewProtectModule) break block11;
                this.gotNewProtectModule = false;
                Object object = this.protectModuleModelLock;
                synchronized (object) {
                    if (this.protectModuleModel != null) {
                        this.protectModuleModel.setProtectionGroupModel(null);
                    }
                    this.protectModuleModel = moduleModel;
                    if (this.protectModuleModel != null) {
                        this.protectModuleModel.setProtectionGroupModel(this);
                        this.protectModuleModel.setInterfacesInited(true);
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Caught NoSuchEntity in getProtectModuleModel!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getProtectModuleModel", userException);
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block11;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return moduleModel;
    }

    public void addMainModuleModel(IModuleModel iModuleModel) throws Busy, ProvisionError, MissingEquipment, ResourceInUse {
        if (this.db.on()) {
            this.db.println("addMainModuleModel(" + iModuleModel + ")");
        }
        try {
            this.addModule.set(iModuleModel);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (xMissingEquipment xMissingEquipment2) {
            throw new MissingEquipment((UserException)xMissingEquipment2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "addMainModuleModel", userException);
        }
    }

    public void removeMainModuleModel(IModuleModel iModuleModel) throws ResourceInUse, Busy, EMCProvisionError {
        if (this.db.on()) {
            this.db.println("removeMainModuleModel(" + iModuleModel + ")");
        }
        try {
            this.removeModule.set(iModuleModel);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            NodeModelDelegate.doUnknown(this.db, "removeMainModuleModel", userException);
        }
    }

    public IRevertiveBehavior getReversion() {
        try {
            return RevertiveBehaviorFactory.getIRevertiveBehavior((sRevertiveBehavior)this.reversion.get());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getReversion", userException);
        }
    }

    public void setReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy, EMCProvisionError, NotSupportedOnEquipment {
        try {
            this.reversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            NodeModelDelegate.doUnknown(this.db, "setReversion", userException);
        }
    }

    public void delete() throws Busy, EMCProvisionError, ResourceInUse {
        if (this.db.on()) {
            this.db.println("delete()");
        }
        try {
            this.delete.set();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "delete", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleModel[] getMainModuleModels() {
        IModuleModel[] iModuleModelArray = null;
        try {
            int[] nArray = (int[])this.mainModules.get();
            int n = nArray.length;
            iModuleModelArray = new ModuleModel[n];
            ModuleModel moduleModel = null;
            EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
            Object object = this.mainModuleModelsLock;
            synchronized (object) {
                int n2;
                if (this.gotNewMainModules) {
                    for (n2 = 0; n2 < this.mainModuleModels.length; ++n2) {
                        this.mainModuleModels[n2].setProtectionGroupModel(null);
                    }
                }
                for (n2 = 0; n2 < n; ++n2) {
                    moduleModel = (ModuleModel)entityTableModel.getEntityModelByIndex(nArray[n2]);
                    if (this.gotNewMainModules) {
                        moduleModel.setProtectionGroupModel(this);
                    }
                    iModuleModelArray[n2] = moduleModel;
                }
                this.mainModuleModels = iModuleModelArray;
                this.gotNewMainModules = false;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("Caught NoSuchEntity in getMainModuleModels");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getMainModuleModels", userException);
        }
        return iModuleModelArray == null ? new ModuleModel[]{} : iModuleModelArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleModel getProtectedModuleModel() {
        ModuleModel moduleModel;
        block10: {
            moduleModel = null;
            try {
                Integer n = (Integer)this.protectedModule.get();
                if (n != null) {
                    moduleModel = (ModuleModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
                }
                if (!this.gotNewProtectedModule) break block10;
                Object object = this.protectedModuleModelLock;
                synchronized (object) {
                    if (this.protectedModuleModel != null) {
                        this.protectedModuleModel.setProtectionGroupModel(null);
                    }
                    this.protectedModuleModel = moduleModel;
                    if (this.protectedModuleModel != null) {
                        this.protectedModuleModel.setProtectionGroupModel(this);
                    }
                    this.gotNewProtectedModule = false;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Caught NoSuchEntity in getProtectedModuleModel!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getProtectedModuleModel", userException);
            }
        }
        return moduleModel;
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        this.name.update();
        this.reversion.update();
        this.protectedModule.update();
        this.mainModules.update();
        this.protectType.update();
        this.pgProtectModule.update();
        this.whoAmI = null;
        this.setChanged();
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(): this=" + this.toString() + ", from=" + observable + ", arg=" + object);
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 0: {
                ProtectionGroupModels protectionGroupModels;
                if (this.db.on()) {
                    this.db.println("update(): DELETED.  Remove list");
                }
                if (this.nmd == null || (protectionGroupModels = this.nmd.getProtectionGroupModels()) == null) break;
                protectionGroupModels.remove(this.getIndex());
                break;
            }
            case 1: {
                if (this.db.on()) {
                    this.db.println("update(): CHANGED.  Local changes.");
                }
                this.updateLocal();
                break;
            }
            default: {
                this.db.println("Unexpected update message (" + n + ") on a protection group");
            }
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectProtectionGroup, this.getIndex(), (Observer)this);
        }
        this.name.dispose();
        this.reversion.dispose();
        this.pgProtectModule.dispose();
        this.protectedModule.dispose();
        this.mainModules.dispose();
        this.protectType.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        Object object = this.protectedModuleModelLock;
        synchronized (object) {
            if (this.protectedModuleModel != null) {
                this.protectedModuleModel.setProtectionGroupModel(null);
            }
        }
        object = this.protectModuleModelLock;
        synchronized (object) {
            if (this.protectModuleModel != null) {
                this.protectModuleModel.setProtectionGroupModel(null);
            }
        }
        object = this.mainModuleModelsLock;
        synchronized (object) {
            if (this.mainModuleModels != null) {
                for (int i = 0; i < this.mainModuleModels.length; ++i) {
                    this.mainModuleModels[i].setProtectionGroupModel(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.whoAmI == null) {
            try {
                this.whoAmI = Integer.toHexString(this.getIndex());
                boolean bl = true;
                Object object = this.mainModuleModelsLock;
                synchronized (object) {
                    for (int i = 0; i < this.mainModuleModels.length; ++i) {
                        String string = Integer.toHexString(this.mainModuleModels[i].getIndex());
                        if (bl) {
                            this.whoAmI = this.whoAmI + "/" + string;
                            bl = false;
                            continue;
                        }
                        this.whoAmI = this.whoAmI + "-" + string;
                    }
                }
            }
            catch (Exception exception) {
                this.whoAmI = null;
                return "Prot'nGroup[unknown]";
            }
        }
        return "Prot'nGroup[" + this.whoAmI + "]";
    }

    class AddModule
    extends NonCachedValue {
        public AddModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBusy, xProvisionError, xMissingEquipment, xInUse {
            ProtectionGroupModel.this.pgRef.addModule(((ModuleModel)object).getEntityIndex(), false);
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xBusy, xProvisionError, xInUse {
            ProtectionGroupModel.this.pgRef.delete(false);
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class MainModuleValues
    extends NonCachedValue {
        public MainModuleValues(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.getMainModuleModels();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class MainModules
    extends CachedValue {
        public MainModules(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ProtectionGroupModel.this.gotNewMainModules = true;
            return ProtectionGroupModel.this.pgRef.mainModules();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class Name
    extends CachedValue {
        public Name(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) {
            ProtectionGroupModel.this.pgRef.name((String)object);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.pgRef.name();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class PgProtectModule
    extends CachedValue {
        public PgProtectModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ProtectionGroupModel.this.gotNewProtectModule = true;
            return new Integer(ProtectionGroupModel.this.pgRef.protectModule());
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class ProtectModule
    extends UserValue {
        public ProtectModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object get() {
            if (ProtectionGroupModel.this.db.on()) {
                ProtectionGroupModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            return ProtectionGroupModel.this.getProtectModuleModel();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class ProtectType
    extends CachedValue {
        public ProtectType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.pgRef.protectType();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class ProtectedModule
    extends CachedValue {
        public ProtectedModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ProtectionGroupModel.this.gotNewProtectedModule = true;
            return new Integer(ProtectionGroupModel.this.pgRef.protectedModule());
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class ProtectedModuleValue
    extends NonCachedValue {
        public ProtectedModuleValue(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.getProtectedModuleModel();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class ProtectionType
    extends NonCachedValue {
        public ProtectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.getProtectType();
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class RemoveModule
    extends NonCachedValue {
        public RemoveModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xInUse, xBusy, xProvisionError {
            ProtectionGroupModel.this.pgRef.removeModule(((ModuleModel)object).getEntityIndex(), false);
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }

    class Reversion
    extends CachedValue {
        public Reversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBusy, xProvisionError, xNotSupportedOnEquipment {
            ProtectionGroupModel.this.pgRef.setReversion((sRevertiveBehavior)object);
        }

        protected Object getValue() {
            return ProtectionGroupModel.this.pgRef.getReversion();
        }

        protected Object cloneValue() {
            sRevertiveBehavior sRevertiveBehavior2 = (sRevertiveBehavior)this.value;
            return new sRevertiveBehavior(sRevertiveBehavior2.reversionMode, sRevertiveBehavior2.reversionTime);
        }

        public Object outer() {
            return ProtectionGroupModel.this;
        }
    }
}

