/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.OSI.RouterManager;
import cerent.cms.idl.OSI.sEsiEntry;
import cerent.cms.idl.OSI.sGriEntry;
import cerent.cms.idl.OSI.sRouter;
import cerent.cms.idl.OSI.xCannotRemovePaa;
import cerent.cms.idl.OSI.xDuplicateAreaAddress;
import cerent.cms.idl.OSI.xMaxMaa;
import cerent.cms.idl.OSI.xNoSuchAreaAddress;
import cerent.cms.idl.OSI.xNoSuchRouter;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CannotRemovePAA;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DuplicateAreaAddress;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.MaxMAA;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchAreaAddress;
import cerent.cms.model.NoSuchRouter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class RouterModel
extends Model {
    private NodeModelDelegate nodeModel;
    private Enabled enabled;
    private RemoveMAA removeMAA;
    private AddMAA addMAA;
    private HasMaa hasMaa;
    private ChangePAA changePAA;
    private RouterList routerList;
    private GriTable griTable;
    private EsiTable esiTable;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<RouterModel> sfactory = new NodeSingletonFactory<RouterModel>(RouterModel.class);

    public static RouterModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private RouterModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RouterModel.class));
        this.nodeModel = nodeModelDelegate;
        this.enabled = new Enabled(nodeModelDelegate, "RouterModel::enabled");
        this.addMAA = new AddMAA(nodeModelDelegate, "RouterModel::addMAA");
        this.hasMaa = new HasMaa(nodeModelDelegate, "RouterModel::hasMaa");
        this.removeMAA = new RemoveMAA(nodeModelDelegate, "RouterModel::removeMAA");
        this.changePAA = new ChangePAA(nodeModelDelegate, "RouterModel::changePAA");
        this.routerList = new RouterList(nodeModelDelegate, "RouterMode::routerList");
        this.griTable = new GriTable(nodeModelDelegate, "RouterModel::griTable");
        this.esiTable = new EsiTable(nodeModelDelegate, "RouterModel::esiTable");
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private RouterManager getOSIRouterRef() {
        return this.nodeModel.getIorRepository().getOSIRouterRef();
    }

    public String[] getOsiRouters() {
        sRouter[] sRouterArray = this.getRouterList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sRouterArray.length; ++i) {
            arrayList.add(Integer.toString(sRouterArray[i].routerNumber));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public sRouter getRouter(int n) {
        sRouter sRouter2 = null;
        sRouter[] sRouterArray = this.getRouterList();
        for (int i = 0; i < sRouterArray.length; ++i) {
            if (sRouterArray[i].routerNumber != n) continue;
            sRouter2 = sRouterArray[i];
            break;
        }
        return sRouter2;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOsiRouterList, 1, (Observer)this);
        }
        this.routerList.init();
    }

    public boolean getEnabled(int n) {
        try {
            return (Boolean)this.enabled.get(new Short((short)n));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setEnabled(int n, boolean bl) throws ConfigError {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), bl ? Boolean.TRUE : Boolean.FALSE};
            this.enabled.set(objectArray);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean hasMaa(short s, byte[] byArray) throws NoSuchRouter {
        try {
            Object[] objectArray = new Object[]{new Short(s), byArray};
            return (Boolean)this.hasMaa.get(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void addMAA(short s, byte[] byArray) throws NoSuchRouter, MaxMAA, DuplicateAreaAddress {
        try {
            Object[] objectArray = new Object[]{new Short(s), byArray};
            this.addMAA.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xMaxMaa xMaxMaa2) {
            throw new MaxMAA((UserException)xMaxMaa2);
        }
        catch (xDuplicateAreaAddress xDuplicateAreaAddress2) {
            throw new DuplicateAreaAddress((UserException)xDuplicateAreaAddress2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void removeMAA(short s, byte[] byArray) throws NoSuchRouter, CannotRemovePAA, NoSuchAreaAddress {
        try {
            Object[] objectArray = new Object[]{new Short(s), byArray};
            this.removeMAA.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xCannotRemovePaa xCannotRemovePaa2) {
            throw new CannotRemovePAA((UserException)xCannotRemovePaa2);
        }
        catch (xNoSuchAreaAddress xNoSuchAreaAddress2) {
            throw new NoSuchAreaAddress((UserException)xNoSuchAreaAddress2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void changePAA(int n, byte[] byArray) throws NoSuchRouter, DuplicateAreaAddress {
        try {
            Object[] objectArray = new Object[]{new Short((short)n), byArray};
            this.changePAA.set(objectArray);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xDuplicateAreaAddress xDuplicateAreaAddress2) {
            throw new DuplicateAreaAddress((UserException)xDuplicateAreaAddress2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sRouter[] getRouterList() {
        try {
            return (sRouter[])this.routerList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public boolean routersHaveSameAreaAddress(int n, int n2) throws NoSuchRouter {
        sRouter[] sRouterArray = this.getRouterList();
        if (n - 1 >= sRouterArray.length) {
            throw new NoSuchRouter("Router #" + n + " does not exist.");
        }
        if (n2 - 1 >= sRouterArray.length) {
            throw new NoSuchRouter("Router #" + n2 + " does not exist.");
        }
        byte[][] byArray = sRouterArray[n - 1].addrList;
        byte[][] byArray2 = sRouterArray[n2 - 1].addrList;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            if (Arrays.equals(byArray3, byArray4)) continue;
            return false;
        }
        return true;
    }

    public sGriEntry[] getGriTable(int n) throws NoSuchRouter, InternalCommError {
        Short s = new Short((short)n);
        try {
            return (sGriEntry[])this.griTable.get(s);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sEsiEntry[] getEsiTable(int n) throws NoSuchRouter, InternalCommError {
        Short s = new Short((short)n);
        try {
            return (sEsiEntry[])this.esiTable.get(s);
        }
        catch (xNoSuchRouter xNoSuchRouter2) {
            throw new NoSuchRouter((UserException)xNoSuchRouter2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOsiRouterList, 1, (Observer)this);
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            switch (((ObjectMessageInfo)object).getUpdateType()) {
                case 1: {
                    this.routerList.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    class AddMAA
    extends NonCachedValue {
        public AddMAA(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            RouterModel.this.getOSIRouterRef().addMaa((Short)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class ChangePAA
    extends NonCachedValue {
        public ChangePAA(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            RouterModel.this.getOSIRouterRef().changePaa((Short)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class Enabled
    extends NonCachedValue {
        public Enabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return RouterModel.this.getOSIRouterRef().isEnabled((Short)object) ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            RouterModel.this.getOSIRouterRef().setEnabled((Short)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class EsiTable
    extends NonCachedValue {
        public EsiTable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return RouterModel.this.getOSIRouterRef().getEsiTable((Short)object);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class GriTable
    extends NonCachedValue {
        public GriTable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return RouterModel.this.getOSIRouterRef().getGriTable((Short)object);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class HasMaa
    extends NonCachedValue {
        public HasMaa(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return RouterModel.this.getOSIRouterRef().hasMaa((Short)objectArray[0], (byte[])objectArray[1]) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class RemoveMAA
    extends NonCachedValue {
        public RemoveMAA(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            RouterModel.this.getOSIRouterRef().removeMaa((Short)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return RouterModel.this;
        }
    }

    class RouterList
    extends CachedValue {
        public RouterList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return RouterModel.this.getOSIRouterRef().getRouters();
        }

        public Object outer() {
            return RouterModel.this;
        }
    }
}

