/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.MSIsc100T.MSIsc100TCardView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.shelf.ADM10GCardView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.MuxDmuxCardView;
import cerent.cms.ui.shelf.OpticsCardView;
import cerent.cms.ui.shelf.OscCardView;
import cerent.cms.ui.shelf.WssCardView;
import cerent.cms.ui.shelf.WxcCardView;
import cerent.cms.ui.shelf.XP40GCardView;
import cerent.cms.ui.xpl2.XPL2CardView;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractCardViewPanel
extends GridBagPanel
implements ActionListener {
    public static final Dimension GRAPHIC_VIEW_DIM = new Dimension(600, 248);
    protected ModuleModel model;
    protected CardView cardView;
    protected String cardName = "";
    private CardViewController cvc;
    private CardBehavior cardBehavior;
    private IPlatform pci;
    protected JLabel cardNameLabel;
    private static final String CMD_UP = "Go To Parent View";
    protected static final SDebug db = new SDebug("CardViewPanel");

    public AbstractCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        if (db.on()) {
            db.println("<init>");
        }
        this.model = moduleModel;
        this.cvc = cardViewController;
        this.pci = this.model.getNodeModelDelegate().getPlatform();
        this.cardBehavior = this.pci.getCardBehavior(this.model.getNodeModelDelegate(), db);
        this.initPanel();
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    protected void initPanel() {
        this.cardName = this.model.getEqLabel();
        this.cardNameLabel = AbstractShelfLayout.formatLabel(new JLabel(this.cardName));
        this.add(this.cardNameLabel, 0, 1, 2, 1);
        this.setupCardView();
        this.add(this.cardView, 1, 2, 1, 0);
    }

    protected void setupCardView() {
        if (this.model instanceof XPL2ModuleModel) {
            this.cardView = new XPL2CardView(this.model, this);
        } else if (this.model instanceof DwdmModuleModel) {
            this.cardView = this.model.getEqType() == 273 ? new ADM10GCardView((EntityModel)this.model, this) : (this.model.getEqType() == 300 || this.model.getEqType() == 301 ? new XP40GCardView(this.model, this) : new DwdmCardView((EntityModel)this.model, this));
        } else {
            switch (this.model.getEqType()) {
                case 238: {
                    if (!(this.model instanceof L2scModuleModel)) break;
                    L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                    this.cardView = new MSIsc100TCardView((ModuleModel)l2scModuleModel, l2scModuleModel.getL2scEtherPorts());
                    break;
                }
                case 129: 
                case 130: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 196: 
                case 239: 
                case 240: 
                case 249: 
                case 277: 
                case 278: 
                case 281: 
                case 286: 
                case 287: 
                case 294: 
                case 295: 
                case 296: 
                case 298: 
                case 299: 
                case 321: {
                    this.cardView = new OpticsCardView(this.model, this);
                    break;
                }
                case 131: 
                case 132: 
                case 192: 
                case 241: 
                case 264: 
                case 265: 
                case 268: 
                case 269: {
                    this.cardView = new MuxDmuxCardView(this.model, this);
                    break;
                }
                case 266: 
                case 270: 
                case 297: {
                    this.cardView = new WxcCardView(this.model, this);
                    break;
                }
                case 191: 
                case 242: 
                case 263: 
                case 267: {
                    this.cardView = new WssCardView(this.model, this);
                    break;
                }
                case 127: 
                case 128: {
                    this.cardView = new OscCardView(this.model, this);
                    break;
                }
                default: {
                    this.cardView = new CardView(this.model);
                }
            }
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }

    public void dispose() {
        this.cardView.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_UP) {
            this.cvc.tryJumpView(this.cvc.getParentVC().getViewName());
        } else if (string == "Open IOS Connection...") {
            this.cardBehavior.openIOS(this.model);
        } else if (string == "Reset Card") {
            this.cardBehavior.resetCard(this, this.model);
        } else if (string == "Hard-reset Card") {
            this.cardBehavior.hardResetCard(this, this.model);
        } else if (string == "Soft-reset Card") {
            this.cardBehavior.softResetCard(this, this.model);
        } else if (string == "IOS Startup Config...") {
            this.cardBehavior.openIOSConfig(this, this.model);
        } else if (string == "Functional View") {
            this.cvc.execFv();
        }
    }

    protected JMenuItem makeMenuAction(String string, boolean bl, int n) {
        JMenuItem jMenuItem = new JMenuItem(string, n);
        if (bl) {
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public void setCardNameLabel(String string) {
        this.cardNameLabel.setText(string);
        this.cardNameLabel.repaint();
    }

    public void tryJumpView(ViewName viewName) {
        this.cvc.tryJumpView(viewName);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            boolean bl = AbstractPane.isUserAuthorized(AbstractCardViewPanel.this.model, SecurityLevel.MAINTENANCE);
            boolean bl2 = AbstractPane.isUserAuthorized(AbstractCardViewPanel.this.model, SecurityLevel.PROVISIONING);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction(AbstractCardViewPanel.CMD_UP, true, 71));
            jPopupMenu.addSeparator();
            if (CardBehavior.supportsGenericResetCard(AbstractCardViewPanel.this.pci, AbstractCardViewPanel.this.model.getEqType())) {
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Reset Card", bl && AbstractCardViewPanel.this.model.isResettable(), 82));
            } else {
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Hard-reset Card", bl && AbstractCardViewPanel.this.model.isHardResettable(), 72));
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Soft-reset Card", bl && AbstractCardViewPanel.this.model.isSoftResettable(), 83));
            }
            if (AbstractCardViewPanel.this.model instanceof IosModuleModel && ((IosModuleModel)AbstractCardViewPanel.this.model).supportsIOS()) {
                jPopupMenu.addSeparator();
                eEqState eEqState2 = AbstractCardViewPanel.this.model.getState();
                boolean bl3 = eEqState2 == eEqState.ACTIVE || eEqState2 == eEqState.STANDBY;
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Open IOS Connection...", bl3 && bl2, 79));
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("IOS Startup Config...", bl2, 73));
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

