/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.BERTModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class BertModeTableModel
extends AbstractTableModel {
    protected Ds123LineModel[] model;
    protected boolean[][] isDirty;
    protected INodeModel node;
    protected int numLines;
    public static final int LINENUMBER_INDEX = 0;
    public static final int TPGM_INDEX = 1;
    public static final String[] columnNames = new String[]{"Synchronization Status", "Error Count", "Error Rate"};
    protected Long[] errorCount;
    protected Boolean[] syncStatus;
    protected int[] errorRate;
    private BERTModel bm = null;
    protected static final SDebug db = new SDebug("BertModeTableModel");

    public BertModeTableModel(INodeModel iNodeModel, BERTModel bERTModel) {
        this.node = iNodeModel;
        this.bm = bERTModel;
        this.init();
    }

    protected void init() {
        this.errorCount = new Long[1];
        this.syncStatus = new Boolean[1];
        this.errorRate = new int[1];
        this.numLines = 1;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = String.class;
                break;
            }
            case 2: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            Ds123LineModel ds123LineModel = this.bm.getBERTPortModel();
            switch (n2) {
                case 1: {
                    long l = ds123LineModel.getErrorCount();
                    return l;
                }
                case 0: {
                    boolean bl = ds123LineModel.getSyncStatus();
                    return bl;
                }
                case 2: {
                    int n3 = ds123LineModel.getErrorRate();
                    String string = null;
                    switch (n3) {
                        case 2: {
                            string = "1E-3";
                            break;
                        }
                        case 3: {
                            string = "1E-4";
                            break;
                        }
                        case 4: {
                            string = "1E-5";
                            break;
                        }
                        case 5: {
                            string = "1E-6";
                            break;
                        }
                        default: {
                            string = "None";
                        }
                    }
                    return string;
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt in Ds123LineTableModel " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.errorCount[i] = null;
            this.syncStatus[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    void clearMethod() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError, InternalCommError {
        Ds123LineModel ds123LineModel = this.bm.getBERTPortModel();
        if (ds123LineModel != null) {
            ds123LineModel.clearErrorCount();
        }
    }

    public void refreshLineFromModel(int n) {
        for (int i = 0; i < this.numLines; ++i) {
            this.errorCount[i] = null;
            this.syncStatus[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[n][j] = false;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }
}

