/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwdmSide {
    public static final int UNKNOWN_SIDE_ID = 0;
    public static final String UNKNOWN_SIDE_LABEL = "Unknown";
    private static final String ERROR_ON_SIDE_ID = "N/A";
    private static final int SIDE_LABEL_MASK = 255;
    private static final int SIDE_ROLE_MASK = 65280;
    private static final int SIDE_ROLE_SHIFT = 14;
    private static final int SIDE_WORKING_VALUE = 16384;
    private static final int SIDE_PROTECT_VALUE = 32768;
    public static final int WORKING_SIDE_ROLE = 1;
    public static final int PROTECTED_SIDE_ROLE = 2;
    public static final int NO_SIDE_ROLE = 0;
    public static final String SIDE_WORKING_STR = "(w)";
    public static final String SIDE_PROTECT_STR = "(p)";
    private static final String[] sideStr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
    private static final List<SideEnum> sideEnumList = new ArrayList<SideEnum>();
    public static final int LEGACY = 2;
    public static final int WXCNE = 8;
    public static final int MAXSIDE = 8;

    private DwdmSide() {
    }

    public static String[] getAllSides() {
        return sideStr;
    }

    public static String getSideFromOffset(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        if (n2 > 0 && n2 <= sideStr.length) {
            return sideStr[n2 - 1] + DwdmSide.getSideRoleString(n);
        }
        if (n2 == 0) {
            return UNKNOWN_SIDE_LABEL;
        }
        return ERROR_ON_SIDE_ID;
    }

    public static String getSideLabelFromOffset(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        if (n2 > 0 && n2 <= sideStr.length) {
            return sideStr[n2 - 1];
        }
        if (n2 == 0) {
            return UNKNOWN_SIDE_LABEL;
        }
        return ERROR_ON_SIDE_ID;
    }

    private static String getSideRoleString(int n) {
        switch (n & 0xFF00) {
            case 16384: {
                return SIDE_WORKING_STR;
            }
            case 32768: {
                return SIDE_PROTECT_STR;
            }
        }
        return "";
    }

    public static int getSideRole(int n) {
        return (n & 0xFF00) >> 14;
    }

    public static int getSideLabelFromId(int n) {
        return n & 0xFF;
    }

    public static int getSideId(int n, int n2) {
        return (n2 << 14) + n;
    }

    public static int getSideWorkingFromLabel(int n) {
        n = DwdmSide.getSideLabelFromId(n);
        return n | 0x4000;
    }

    public static int getSideProtectFromLabel(int n) {
        n = DwdmSide.getSideLabelFromId(n);
        return n | 0x8000;
    }

    public static int getIndexOf(String string) {
        if (string.equals(UNKNOWN_SIDE_LABEL)) {
            return 0;
        }
        for (int i = 0; i < sideStr.length; ++i) {
            if (!string.startsWith(sideStr[i])) continue;
            int n = i + 1;
            String string2 = string.substring(sideStr[i].length());
            if (string2 != null) {
                if (string2.equals(SIDE_WORKING_STR)) {
                    n += 16384;
                } else if (string2.equals(SIDE_PROTECT_STR)) {
                    n += 32768;
                }
            }
            return n;
        }
        return -1;
    }

    public static String getLabelOf(String string) {
        for (int i = 0; i < sideStr.length; ++i) {
            if (!string.startsWith(sideStr[i])) continue;
            return sideStr[i];
        }
        return UNKNOWN_SIDE_LABEL;
    }

    public static boolean isRolePresent(String string) {
        return string.length() > 1;
    }

    public static int getMaxNumberSide() {
        return sideStr.length;
    }

    public static List<SideEnum> getSideEnumList() {
        return sideEnumList;
    }

    public static SideEnum getValue(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        for (int i = 0; i < sideEnumList.size(); ++i) {
            SideEnum sideEnum = sideEnumList.get(i);
            if (n2 != sideEnum.ord) continue;
            return new SideEnum(sideEnum.name, sideEnum.ord);
        }
        return null;
    }

    public static SideEnum getValue(String string) {
        for (int i = 0; i < sideEnumList.size(); ++i) {
            SideEnum sideEnum = sideEnumList.get(i);
            if (!sideEnum.name.equalsIgnoreCase(string)) continue;
            return new SideEnum(sideEnum.name, sideEnum.ord);
        }
        return null;
    }

    static {
        for (int i = 0; i < sideStr.length; ++i) {
            sideEnumList.add(new SideEnum(sideStr[i], DwdmSide.getIndexOf(sideStr[i])));
        }
    }

    public static class SideEnum {
        private String name = "";
        private int ord = 0;

        private SideEnum(String string, int n) {
            this.name = string;
            this.ord = n;
        }

        public String toString() {
            return this.name;
        }

        public int toInt() {
            return this.ord;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            SideEnum sideEnum = (SideEnum)object;
            if (object == null) {
                return bl;
            }
            if (sideEnum.name.equals(this.name) && sideEnum.ord == this.ord) {
                bl = true;
            }
            return bl;
        }
    }
}

