/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class EqTypeListCellRenderer
extends JLabel
implements ListCellRenderer {
    private INodeModel nm;
    public static final int EQPTYPE_CARDTYPE = 1;
    public static final int EQPTYPE_DATARATE = 0;
    public static final String INVALID_DATARATE = "Not provisionable";

    public EqTypeListCellRenderer(INodeModel iNodeModel) {
        this.nm = iNodeModel;
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof eEqType) {
            this.setText(((eEqType)object).equals(eEqType.INVALID) ? INVALID_DATARATE : PortHelper.getTDMPortTypeString((INodeModel)this.nm, (int)((eEqType)object).value()));
        } else {
            eEqType[] eEqTypeArray = (eEqType[])object;
            if (eEqTypeArray != null) {
                this.setText(eEqTypeArray[0].equals(eEqType.INVALID) ? INVALID_DATARATE : this.getDataRateString(eEqTypeArray[1].value(), eEqTypeArray[0].value()));
            } else {
                this.setText(INVALID_DATARATE);
            }
        }
        this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
        this.setForeground(bl ? Color.white : Color.black);
        return this;
    }

    public String getDataRateString(int n, int n2) {
        String string = "";
        Attribute attribute = null;
        String string2 = ElementDefaults.getDataRatePortMapKey(n);
        if (EntityCellRenderer.db.isFineEnabled()) {
            EntityCellRenderer.db.fine("Data rate port key is " + string2 + " for " + n + " " + n2);
        }
        if ((attribute = ElementDefaults.getAttributeMap((IModel)this.nm).getAttributeForVal(string2, n2)) == null) {
            EntityCellRenderer.db.fine("Data rate port attribute not found");
            string = PortHelper.getTDMPortTypeString((INodeModel)this.nm, (int)n2);
        } else {
            string = attribute.getKey();
            EntityCellRenderer.db.fine("Data rate port attribute found: " + string);
        }
        return string;
    }
}

