/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtectPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Observable;

public class ProtCardDualPane
extends AbstractPane {
    private static final SDebug db = new SDebug("ProtCardDualPane");
    private Pane mainPane;
    private Pane protectPane;
    private CardLayout layout;
    private ModuleModel module;
    private boolean protectState;

    public ProtCardDualPane(TabbedView tabbedView, ModuleModel moduleModel, Pane pane) {
        super(pane.getName(), moduleModel, tabbedView);
        this.mainPane = pane;
        this.protectState = moduleModel.getProtectionGroupModel() != null;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.module = moduleModel;
        this.initPane();
        this.registerWithModel();
    }

    public void initPane() {
        this.protectPane = new ProtectPane("ProtectPane", this.getParentView());
        this.add(this.mainPane.getName(), (Component)this.mainPane);
        this.add(this.protectPane.getName(), (Component)this.protectPane);
        if (this.module.isProtectModule()) {
            this.protectState = true;
            this.showOnTop(this.protectPane);
        } else {
            this.protectState = false;
            this.showOnTop(this.mainPane);
        }
    }

    private void determineTopPane() {
        boolean bl;
        boolean bl2 = bl = this.module.getProtectionGroupModel() != null;
        if (bl == this.protectState && !this.module.isHdElectricalCard()) {
            return;
        }
        if (this.module.isProtectModule()) {
            this.protectState = true;
            this.showOnTop(this.protectPane);
            if (db.on()) {
                db.println("Top Pane is " + this.mainPane.getName());
            }
        } else {
            this.protectState = false;
            this.showOnTop(this.mainPane);
        }
    }

    public void showOnTop(Pane pane) {
        try {
            this.layout.show((Container)((Object)this), pane.getName());
            this.table = pane.getTable();
            this.subTabs = pane.getSubTabs();
            if (db.on()) {
                db.println("Top Pane is " + this.getName());
                db.println("table is " + this.getTable());
                db.println("subTabs is " + this.getSubTabs());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void refresh() throws Exception {
        if (!this.module.isProtectModule()) {
            this.mainPane.refresh();
        }
    }

    public void dispose() {
        if (this.protectPane != null) {
            this.protectPane.destroy();
        }
        if (this.mainPane != null) {
            this.mainPane.destroy();
        }
        this.layout = null;
        super.dispose();
    }

    public void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("In changeMessage, Received " + object);
        }
        if (this.layout != null) {
            this.determineTopPane();
            this.requestRefresh((Object)this, null);
        }
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage; mainPane is " + this.mainPane.getName());
        }
        this.mainPane.enteringPage();
        this.requestRefresh((Object)this, null);
    }

    public void leavingPage() throws Exception {
        this.mainPane.leavingPage();
    }

    public void setShowing(boolean bl) throws Exception {
        this.mainPane.setShowing(bl);
    }
}

