/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Busy;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Ds123LineMaintenancePane
extends NodeProvPane
implements TableModelListener {
    protected Ds123LineMaintTableModel dataModel = null;
    protected Ds123LineModel[] lineModels = null;
    protected Ds123ModuleModel eqpmtModel = null;
    protected Runnable updateThread = null;
    protected int numLines = 0;
    protected INodeModel node;
    private static final String cantSetLpbk = "\nCannot apply requested loopback.";
    private static final SDebug db = new SDebug("Ds123LineMaintenancePane");

    public Ds123LineMaintenancePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TableColumn tableColumn = null;
        this.lineModels = ds123LineModelArray;
        Attribute[] attributeArray = null;
        if (ds123LineModelArray == null) {
            db.severe("<constructor> Ds123 Lines are null");
            this.numLines = 0;
        } else {
            this.numLines = ds123LineModelArray.length;
        }
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.createTable();
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.node.getTdmProtocolType()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        try {
            attributeArray = this.getSelectableLoopbackAttributes();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        this.setSendCodeColumnEditor();
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
        tableColumn.setMinWidth(125);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        tableColumn.setMinWidth(125);
        this.maybeRemoveLoopbackAisColumn();
        this.registerWithModel();
        this.add((Component)uScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void createTable() {
        this.table = new UTable((TableModel)this.dataModel);
    }

    protected void setSendCodeColumnEditor() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        try {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray(eSendCode.class))));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.table.removeColumn(tableColumn);
        }
    }

    protected void maybeRemoveLoopbackAisColumn() {
        if (!((ModuleModel)this.getUiModel()).supportsLoopbackAis()) {
            TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
            this.table.removeColumn(tableColumn);
        }
    }

    protected Ds123LineMaintTableModel getDataModel() {
        if (this.lineModels == null) {
            db.severe("getDataModel(): Ds123 Lines are null");
        }
        return new Ds123LineMaintTableModel(this.node, this.lineModels);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
        super.registerWithModel();
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    public void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                Ds123LineMaintenancePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            db.info("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.info("In Ds123LineMaintenancePane changeMessage cannot find Model " + observable);
        }
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeArray("DS123." + clazz.getName());
    }

    protected Attribute[] getSelectableLoopbackAttributes() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute[] attributeArray = this.getAttributeArray(eLoopback.class);
        Integer n = new Integer(5);
        Integer n2 = new Integer(6);
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            if (attribute.equals(n) || attribute.equals(n2)) continue;
            arrayList.add(attribute);
        }
        return arrayList.toArray(new Attribute[0]);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray(string);
    }

    protected String[] getLoopbackStrings() {
        return EnumStrings.getStrings(eLoopback.class);
    }

    protected boolean verifyApplyChangesToModel() throws NoSuchInterface, WrongInterfaceType, Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(i), this.lineModels[i].getAdminStateEnum())) {
                bl = true;
                if (bl2 && bl3) break;
            }
            if (!bl2 && this.dataModel.getLoopbackValFor(i) != eLoopback.NO_LOOPBACK && this.lineModels[i].getLoopback().equals(eLoopback.NO_LOOPBACK)) {
                bl2 = true;
                if (bl && bl3) break;
            }
            if (bl3 || !AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) continue;
            bl3 = true;
            if (bl && bl2) break;
        }
        if (bl || bl2 || bl3) {
            if (bl) {
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            }
            if (bl2) {
                stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
            }
            if (bl3) {
                stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            }
            if (bl) {
                stringBuffer.append(this.getSeverityWarningMsg(bl2));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            bl4 = CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return bl4;
    }

    protected String getSeverityWarningMsg(boolean bl) {
        String string;
        try {
            String string2 = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
            string = string2 + "\n\n" + this.getApplyString(false);
        }
        catch (Exception exception) {
            string = "\n" + this.getApplyString();
        }
        return string;
    }

    protected void applyInterdependentChangesToModel(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, SyncProvError, InvalidState, Busy, LoopbackActive, ProvisionError {
        db.info("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackValFor(n).value());
        eAdminState eAdminState2 = this.dataModel.getAdminStateFor(n);
        if (AdminState.admitsLoopback(eAdminState2)) {
            db.fine("Apply adminState first");
            this.lineModels[n].setAdminState(eAdminState2);
            this.applyLoopbackAisChanges(n);
        } else if (AdminState.admitsLoopback(this.lineModels[n].getAdminStateEnum())) {
            db.fine("Apply adminState second");
            this.applyLoopbackAisChanges(n);
            this.lineModels[n].setAdminState(eAdminState2);
        } else {
            db.fine("Apply adminState only");
            this.lineModels[n].setAdminState(eAdminState2);
            this.applyAisChanges(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void applyLoopbackAisChanges(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, LoopbackActive {
        eLoopback eLoopback2 = this.dataModel.getLoopbackValFor(n);
        if (!this.dataModel.isDirty(n, 5)) {
            if (!this.dataModel.isDirty(n, 6)) {
                this.doSetLoopback(n, eLoopback2);
                return;
            }
        }
        if (eLoopback2 == eLoopback.NO_LOOPBACK) {
            this.doSetLoopback(n, eLoopback2);
            this.applyAisChanges(n);
            return;
        }
        this.applyAisChanges(n);
        this.doSetLoopback(n, eLoopback2);
    }

    protected void applyAisChanges(int n) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, WrongInterfaceType {
        if (this.dataModel.isDirty(n, 5)) {
            this.lineModels[n].setFacLoopbackAis(this.dataModel.getFacLoopbackAis(n));
        }
        if (this.dataModel.isDirty(n, 6)) {
            this.lineModels[n].setTermLoopbackAis(this.dataModel.getTermLoopbackAis(n));
        }
    }

    protected void applyDerivativeChangesToModel(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, InvalidState, Busy, EMCProvisionError {
        if (this.dataModel.isDirty(n, 4)) {
            this.lineModels[n].setSendCode(this.dataModel.getSendCodeValFor(n));
        }
    }

    public void applyChangesToModel() throws AnnotatedException {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.numLines; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
                this.applyDerivativeChangesToModel(n);
            }
            this.dataModel.resetDirtyBits();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            db.severe("getDataModel(): Ds123 Lines are null");
            return;
        }
        int n = 0;
        int n2 = this.numLines - 1;
        if (n != -1) {
            n = tableModelEvent.getFirstRow() < 0 ? 0 : tableModelEvent.getFirstRow();
            n2 = tableModelEvent.getLastRow() > this.numLines ? this.numLines - 1 : tableModelEvent.getLastRow();
        }
        db.info("tableChanged: first/last row are " + n + "/" + n2);
        for (int i = n; i <= n2; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            db.info(" rows are dirty");
            this.setDirty();
            return;
        }
        db.info("No rows are dirty");
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void refreshFromModel() throws Exception {
        if (db.isInfoEnabled()) {
            db.info("refreshing " + this.getClass().getName());
        }
        if (this.lineModels == null) {
            db.severe("getDataModel(): Ds123 Lines are null");
            return;
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected void doSetLoopback(int n, eLoopback eLoopback2) {
        try {
            this.lineModels[n].setLoopback(eLoopback2);
        }
        catch (NoSuchInterface noSuchInterface) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)cantSetLpbk);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)cantSetLpbk);
        }
        catch (InvalidState invalidState) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_STATE_PARAM_1, (Object)cantSetLpbk);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, (Object)cantSetLpbk);
        }
        catch (Busy busy) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DSN_BUSY_NO_LPBK);
        }
    }
}

