/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3e;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;

public class Ds3eMaintenanceTableModel
extends Ds123LineMaintTableModel {
    protected static final int INHIBITLBK_INDEX = 7;
    protected Boolean[] inhibitLoopback = null;
    private static final SDebug db = new SDebug("Ds3eMaintenanceTableModel");

    public Ds3eMaintenanceTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        if (ds123LineModelArray == null || ds123LineModelArray.length == 0) {
            if (db.on()) {
                db.println("Model is null");
            }
            this.numLines = 0;
        } else {
            this.numLines = ds123LineModelArray.length;
        }
        this.inhibitLoopback = new Boolean[this.numLines];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 7: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    protected void setColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.columnNames.length; ++i) {
            arrayList.add(this.columnNames[i]);
        }
        arrayList.add("Inhibit FE Lbk");
        this.columnNames = arrayList.toArray(new String[0]);
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal("DS3E_LINE_CARD." + string, n);
    }

    protected String getLineNumber(int n) throws AbstractCmsNoSuchEntityException {
        return super.getLineNumber(n);
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 7) {
            try {
                return this.getInhibitLoopback(n);
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return super.getValueAt(n, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return super.isCellEditable(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 7: {
                this.inhibitLoopback[n] = (Boolean)object;
                break;
            }
            default: {
                super.setValueAt(object, n, n2);
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public Boolean getInhibitLoopback(int n) {
        if (this.inhibitLoopback[n] == null) {
            this.inhibitLoopback[n] = new Boolean(this.model[n].getInhibitLoopback());
        }
        return this.inhibitLoopback[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.inhibitLoopback[i] = null;
        }
        super.refreshFromModel();
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    protected void init() {
        super.init();
        this.inhibitLoopback = new Boolean[this.numLines];
    }

    public void refreshLineFromModel(int n) {
        this.inhibitLoopback[n] = null;
        super.refreshLineFromModel(n);
    }
}

