/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3ec1;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;

public class ChangeBbePortTypeDialog
extends UDialog
implements ActionListener,
Observer {
    public static final String TITLE = "Edit Port Type";
    public static final String CONFIRM_TITLE = "Confirm Port Type Change";
    private JButton okButton;
    private JButton cancelButton;
    protected JComboBox portTypeCB;
    ArrayList portTypeList;
    protected PortModel portModel;
    protected IModuleModel module;
    private static final SDebug db = new SDebug("ChangeBbePortTypeDialog");

    public static ChangeBbePortTypeDialog instance(Component component, Object object) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        ChangeBbePortTypeDialog changeBbePortTypeDialog = (ChangeBbePortTypeDialog)ChangeBbePortTypeDialog.getRecycledDialog((Frame)frame, (String)TITLE, ChangeBbePortTypeDialog.class, (Object)object);
        if (changeBbePortTypeDialog == null) {
            changeBbePortTypeDialog = new ChangeBbePortTypeDialog(frame, object);
        }
        return changeBbePortTypeDialog;
    }

    private ChangeBbePortTypeDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        IEntityModel[] iEntityModelArray = (IEntityModel[])object;
        this.module = (IModuleModel)iEntityModelArray[0];
        this.portModel = (PortModel)iEntityModelArray[1];
        this.portTypeList = new ArrayList();
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.registerWithModel();
        this.enableUI();
    }

    public void dispose() {
        this.unRegisterWithModel();
        this.module = null;
        this.portModel = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.dispose();
                }
            }
            catch (Exception exception) {
                db.fine("unexpected exception changing port type");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected boolean apply() throws Exception {
        boolean bl = false;
        try {
            bl = this.confirmPortTypeChange();
            if (bl) {
                this.applyChangesToModel();
            }
        }
        catch (Exception exception) {
            if (exception instanceof AbstractCmsObjectNotExistException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CHANGE_PORT_TYPE_FAILED);
            }
            throw exception;
        }
        return bl;
    }

    private boolean confirmPortTypeChange() throws Exception {
        boolean bl = false;
        Object object = this.portTypeCB.getSelectedItem();
        if (object instanceof eEqType) {
            String string = null;
            String string2 = null;
            eEqType eEqType2 = (eEqType)object;
            String string3 = PortHelper.getPortTypeString((INodeModel)this.module.getNodeModel(), (int)eEqType2.value());
            string = PortHelper.getPortNumString((IPortModel)this.portModel);
            string2 = PortHelper.getPortTypeString((IEntityModel)this.portModel);
            String string4 = "All provisioning on Port " + string + " must be removed for the\nport type change to" + " succeed.\n \n";
            String string5 = "Do you want to change the rate of Port " + string + " from " + string2 + " to " + string3 + "?";
            bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)(string4 + string5), (String)CONFIRM_TITLE);
        }
        return bl;
    }

    private void enableUI() {
        boolean bl = this.portTypeCB.getModel().getSize() > 0;
        this.portTypeCB.setEnabled(bl);
        this.okButton.setEnabled(bl);
    }

    private JPanel getCreatePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = PortHelper.getPortNumString((IPortModel)this.portModel);
        String string2 = PortHelper.getPortTypeString((IEntityModel)this.portModel);
        String string3 = "\nYou are about to change the provisioning of Port " + string + ".\nThe port type is currently provisioned for " + string2 + ".\n \nTo continue, select a new port type below:";
        JLabel jLabel = new JLabel(string3);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.portTypeCB = new JComboBox();
        if (this.module != null) {
            this.portTypeCB.setModel(new DefaultComboBoxModel<eEqType>(this.getBbePortTypes()));
            this.portTypeCB.setRenderer(new PortTypeListCellRenderer());
            UComboBox.setPreferredWidth((JComboBox)this.portTypeCB, (int)(this.portTypeCB.getPreferredSize().width + 10));
        }
        jPanel2.add(new JLabel("Change to: "));
        jPanel2.add(this.portTypeCB);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected eEqType[] getBbePortTypes() {
        eEqType[] eEqTypeArray = ((NodeModelDelegate)this.module.getNodeModel()).getPlatform().is310maSDH() ? new eEqType[]{eEqType.E3_PORT, eEqType.DS3} : new eEqType[]{eEqType.DS3, eEqType.EC1_PORT};
        ArrayList<eEqType> arrayList = new ArrayList<eEqType>(Arrays.asList(eEqTypeArray));
        arrayList.remove(this.portModel.getEqTypeEnum());
        eEqTypeArray = arrayList.toArray(new eEqType[0]);
        return eEqTypeArray;
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        if (this.module != null && (object = this.portTypeCB.getSelectedItem()) instanceof eEqType) {
            String string = "The port type cannot be changed if:\n It has circuits.";
            try {
                Ds123ModuleModel ds123ModuleModel = (Ds123ModuleModel)this.module;
                ds123ModuleModel.changeBbePortType(this.portModel, (eEqType)object);
            }
            catch (ProvisionError provisionError) {
                EID eID = provisionError.getEID();
                if (eID != null) {
                    if (eID == EMC.EID_CANNOT_DELETE_PARAM) {
                        eID = EMC.EID_CANNOT_EDIT_PARAM;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)eID, (Object[])provisionError.getEIDParams());
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, provisionError.getPrettyMessage() + string);
                }
            }
            catch (Exception exception) {
                throw exception;
            }
        }
    }

    protected void registerWithModel() {
        this.module.addObserver((Observer)this);
    }

    protected void unRegisterWithModel() {
        this.module.deleteObserver((Observer)this);
    }

    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (observable instanceof Ds123ModuleModel && n.equals(ModelUpdateType.DELETED)) {
            this.dispose();
        }
    }

    class PortTypeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PortTypeListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof eEqType) {
                StringBuffer stringBuffer = new StringBuffer();
                eEqType eEqType2 = (eEqType)object;
                String string = PortHelper.getPortTypeString((INodeModel)ChangeBbePortTypeDialog.this.module.getNodeModel(), (int)eEqType2.value());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                this.setText(stringBuffer.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

