/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmTdmThresholdProvPane;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.rmon.RmonThresholdPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;

public class DwdmLineThresholdPane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH;
    private boolean isCombo;
    private boolean isNotApplicable;
    private AbstractPane rmonTab;
    private AbstractPane tdmTab;
    private AbstractPane unframedTab;
    private AbstractPane unframedTabF;
    private TdmLineModel[] _tdmModels;
    private IRmonModel[] _rmonModels;
    private DwdmTrkLineModel[] _trkModels;

    public DwdmLineThresholdPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.setLayout(new BorderLayout());
        this._tdmModels = dwdmModuleModel.getSonetLines();
        this._trkModels = dwdmModuleModel.getDwdmTrkLineModels();
        this._rmonModels = dwdmModuleModel.getRmonModels();
        this.registerWithModel();
        this.isSDH = dwdmModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        int n = dwdmModuleModel.getEqType();
        this.isCombo = n == 183 || n == 184 || n == 243 || n == 282 || n == 293 || n == 273 || n == 300 || n == 301;
        this.isNotApplicable = n == 182 || n == 276 || n == 300 || n == 301 || n == 181 || n == 274;
    }

    public void destroy() {
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.tdmTab, this.rmonTab, this.unframedTab, this.unframedTabF};
        this.subTabs.removeAll();
        for (int i = 0; i < abstractPaneArray.length; ++i) {
            if (abstractPaneArray[i] == null) continue;
            abstractPaneArray[i].destroy();
        }
        super.destroy();
    }

    protected void createSubTabs() {
        this.rmonTab = this.createDwdmRmonPane();
        this.tdmTab = this.createDwdmTdmPane(this._tdmModels);
        this.unframedTab = this.createDwdmUnframedPane(true);
        this.unframedTabF = this.createDwdmUnframedPane(false);
        this.setupTabs();
    }

    private AbstractPane createDwdmTdmPane(TdmLineModel[] tdmLineModelArray) {
        return new DwdmTdmThresholdProvPane(this.isSDH ? "SDH Thresholds" : "SONET Thresholds", this.getParentView(), tdmLineModelArray);
    }

    private AbstractPane createDwdmRmonPane() {
        return new RmonThresholdPane("RMON Thresholds", this.getParentView(), this._rmonModels);
    }

    private AbstractPane createDwdmUnframedPane(boolean bl) {
        return NAProtectPane.createPane(this.getParentView(), bl);
    }

    protected void refreshMyLines(Object object) {
        block10: {
            if (object instanceof RmonLineUpdate) {
                this._rmonModels = ((RmonLineUpdate)object).getRmonModels();
                if (!this.isCombo) {
                    this._tdmModels = new TdmLineModel[0];
                }
            } else if (object instanceof DwdmLineUpdate) {
                this._tdmModels = ((DwdmModuleModel)this.getUiModel()).getSonetLines();
                if (!this.isCombo) {
                    this._rmonModels = new IRmonModel[0];
                }
            } else {
                return;
            }
            if (!this._inited) {
                return;
            }
            AbstractPane abstractPane = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
            this.setupTabs();
            if (abstractPane != null) {
                try {
                    this.subTabs.setSelectedComponent((Component)((Object)abstractPane));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.subTabs.getComponentCount() == 0) break block10;
                    this.subTabs.setSelectedIndex(0);
                }
            }
        }
    }

    private void setupTabs() {
        this.subTabs.removeAll();
        if (this._rmonModels != null && this._rmonModels.length > 0) {
            this.subTabs.add("RMON Thresholds", (Component)((Object)this.rmonTab));
        }
        if (this._tdmModels != null && this._tdmModels.length > 0) {
            this.subTabs.add(this.isSDH ? "SDH Thresholds" : "SONET Thresholds", (Component)((Object)this.tdmTab));
        }
        if (this.subTabs.getComponentCount() == 0) {
            try {
                if (this._trkModels.length == 0 || ((DwdmModuleModel)this.getUiModel()).getEqType() == 293) {
                    ((NAProtectPane)this.unframedTab).setText("Therefore, thresholds provisioning and performance monitoring is not applicable.", "");
                    this.subTabs.add((Component)((Object)this.unframedTab));
                } else if (this._trkModels[0].getFramingType() == 5) {
                    this.subTabs.add((Component)((Object)this.unframedTabF));
                } else {
                    int n = this._trkModels[0].getDataRate();
                    if (n == 11 || n == 17 || n == 19 || n == 27 || !((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty()) {
                        this.subTabs.add((Component)((Object)this.unframedTab));
                    } else if (this.isNotApplicable) {
                        ((NAProtectPane)this.unframedTab).setText("Therefore, thresholds provisioning and performance monitoring is not applicable.", "");
                        this.subTabs.add((Component)((Object)this.unframedTab));
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }
}

