/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.E3LineUpdate;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.e13.E13LineTableModel;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class E13LineProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected INodeModel node;
    protected E13LineTableModel dataModel = null;
    protected Ds123LineModel[] lineModels = null;
    UScrollPane scrollPane = null;
    Ds123ModuleModel eqpmtModel = null;
    private ObservableManager _obsMgr;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("E13LineProv");

    public E13LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        this.lineModels = ds123LineModelArray;
        if (this.lineModels != null) {
            this.numLines = this.lineModels.length;
        }
        this.dataModel = this.getDataModel(this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[6]);
        try {
            attributeArray = this.getAttributeArray(eClockSource.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        this.setLineTypeColumn();
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[5]);
        try {
            attributeArray = this.getBerLevelAttributeArray(5);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[4]);
        try {
            attributeArray = this.getBerLevelAttributeArray(4);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[8]);
        try {
            attributeArray = this.getDetectedAttributeArray(eLineType.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[9]);
        try {
            attributeArray = this.getAttributeArray(eLineCoding.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[10]);
        try {
            attributeArray = this.getAttributeArray(eSignalMode.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[11]);
        try {
            attributeArray = this.getAttributeArray("Line Length");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[2]);
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.node.getTdmProtocolType()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(E13LineTableModel.columnNames[12]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.add((Component)this.scrollPane);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    Attribute[] getBerLevelAttributeArray(int n) {
        if (n == 5) {
            return this.getAttributeMap().getAttributeArray("declareSdBerLevel");
        }
        if (n == 4) {
            return this.getAttributeMap().getAttributeArray("declareSfBerLevel");
        }
        return null;
    }

    protected void setLineTypeColumn() {
        Attribute[] attributeArray = null;
        Attribute[] attributeArray2 = null;
        TableColumn tableColumn = this.table.getColumn(E13LineTableModel.columnNames[7]);
        try {
            if (this.needToRemoveAutoProvision()) {
                attributeArray2 = this.getAttributeArray(eLineType.class);
                attributeArray = new Attribute[attributeArray2.length - 1];
                int n = 0;
                for (int i = 0; i < attributeArray2.length; ++i) {
                    if (attributeArray2[i].getKey().compareTo("AUTO PROVISION FMT") == 0) continue;
                    attributeArray[n++] = attributeArray2[i];
                }
            } else {
                attributeArray = this.getAttributeArray(eLineType.class);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
    }

    protected E13LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new E13LineTableModel(this.node, ds123LineModelArray);
    }

    public void dispose() {
        if (db.on()) {
            db.println("Called dispose");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                this.requestRefresh(observable, this.getRefreshThread(observable));
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        } else if (object instanceof E3LineUpdate) {
            super.update(observable, object);
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                E13LineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In E13LineProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS123." + clazz.getName());
    }

    protected Attribute[] getDetectedAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS123." + clazz.getName() + ".detected");
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS123." + string);
    }

    protected Attribute[] getDetectedAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS123." + string + ".detected");
    }

    protected boolean needToRemoveAutoProvision() {
        return false;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (this.dataModel.isRowDirty(n)) {
                    this.applyToLine(n);
                    continue;
                }
                db.fine("Row " + n + " is not dirty: adminState is " + this.dataModel.getAdminState(n).toString());
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    protected void applyToLine(int n) throws Exception {
        if (db.on()) {
            this.printConfig(this.dataModel.getConfig(n));
        }
        this.lineModels[n].setConfig(this.dataModel.getConfig(n));
        this.lineModels[n].setAlias(this.dataModel.getPortName(n));
        Attribute attribute = this.dataModel.getSdBerLevelIndex(n);
        Attribute attribute2 = this.dataModel.getSfBerLevelIndex(n);
        if (attribute != null && attribute2 != null) {
            this.lineModels[n].setSdBerLevel((short)attribute.getValue().intValue());
            this.lineModels[n].setSfBerLevel((short)attribute2.getValue().intValue());
        }
        this.lineModels[n].setSoakTime(this.dataModel.getSoakTime(n));
        this.lineModels[n].setAdminStateNoLpbk(this.dataModel.getAdminStateFor(n));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void printConfig(sConfig sConfig2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("Clock Source " + sConfig2.clockSource.value());
        }
        if (db.on()) {
            db.println("Line Type " + sConfig2.lineType.value());
        }
        if (db.on()) {
            db.println("Line Coding " + sConfig2.lineCoding.value());
        }
        if (db.on()) {
            db.println("Signal Mode " + sConfig2.signalMode.value());
        }
        if (db.on()) {
            db.println("Signal Mode " + sConfig2.lineLength);
        }
        if (db.on()) {
            db.println("Signal Mode " + sConfig2.fdlModeMask);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }
}

