/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.RmonModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ether.DualEtherVlanProvPane;
import cerent.cms.ui.ether.EtherCardProvPane;
import cerent.cms.ui.ether.EtherPortProvPane;
import cerent.cms.ui.ether.EtherVlanProvPane;
import cerent.cms.ui.rmon.RmonThresholdPane;
import java.awt.Component;

public class EtherProvPane
extends NodeProvPane
implements ITabName {
    EtherLineModel[] lineModels = null;
    EtherPortModel[] portModels = null;

    public EtherProvPane(String string, TabbedView tabbedView, EtherLineModel[] etherLineModelArray, EtherPortModel[] etherPortModelArray) {
        super(string, tabbedView);
        if (etherPortModelArray == null || etherLineModelArray == null) {
            return;
        }
        this.lineModels = etherLineModelArray;
        this.portModels = etherPortModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Port", (Component)this.getPortTab());
        this.subTabs.addTab("VLAN", (Component)this.getVlanTab());
        ModuleModel moduleModel = (ModuleModel)this.uiModel;
        this.subTabs.addTab("RMON Thresholds", (Component)((Object)new RmonThresholdPane("RMON Thresholds", this.getParentView(), RmonModel.getRmonModels(etherLineModelArray))));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.addTab("Card", (Component)this.getCardTab());
        this.add((Component)this.subTabs);
    }

    private Pane getPortTab() {
        return new EtherPortProvPane("Port", this.getParentView(), this.lineModels, this.portModels);
    }

    private Pane getVlanTab() {
        return new DualEtherVlanProvPane(this.subTabs, (EtherModuleModel)this.getUiModel(), new EtherVlanProvPane("VLAN", this.getParentView(), this.portModels));
    }

    private Pane getCardTab() {
        return new EtherCardProvPane("Card", this.getParentView());
    }

    public boolean hasSubTabs() {
        return true;
    }
}

