/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.rmon.RmonPmHistPane;
import cerent.cms.ui.rmon.RmonPmStatPane;
import cerent.cms.ui.rmon.RmonPmUtilPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JTable;

public class FcmrPmPane
extends AbstractPane
implements ITabName {
    private FcmrLineModel[] lineModels;
    private static final SDebug db = new SDebug("FcmrPmPane");

    public FcmrPmPane(String string, TabbedView tabbedView, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        this.lineModels = fcmrLineModelArray;
        if (FcmrPmPane.db.on) {
            db.println("parentView is: " + this.getParentView() + "\n" + "uiModel is: " + this.getParentView().getUiModel());
        }
        if (this.getParentView().getUiModel() instanceof ModuleModel) {
            ModuleModel moduleModel = (ModuleModel)this.getParentView().getUiModel();
            if (moduleModel.getEqType() != 143) {
                this.add(new JLabel("This is not an FC-MR card."));
            } else {
                this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
                this.subTabs.setTabPlacement(2);
                this.getSubTabs((SubTabbedView)this.subTabs);
                this.setLayout(new GridLayout(1, 1));
                this.add((Component)this.subTabs);
            }
        }
    }

    public void getSubTabs(SubTabbedView subTabbedView) {
        ModuleModel moduleModel = (ModuleModel)this.getParentView().getUiModel();
        IRmonModel[] iRmonModelArray = new IRmonModel[this.lineModels.length];
        for (int i = 0; i < this.lineModels.length; ++i) {
            iRmonModelArray[i] = this.lineModels[i].getRmonModel();
        }
        subTabbedView.add((Component)((Object)new RmonPmStatPane("Statistics", subTabbedView, iRmonModelArray)));
        subTabbedView.add((Component)((Object)new RmonPmUtilPane("Utilization", subTabbedView, moduleModel, iRmonModelArray)));
        subTabbedView.add((Component)((Object)new RmonPmHistPane("History", subTabbedView, moduleModel, iRmonModelArray)));
    }

    public JTable getTable() {
        return this.subTabs.getCurrentPane().getTable();
    }

    public void refresh() throws Exception {
        this.subTabs.getCurrentPane().refresh();
    }

    public void enteringPage() throws Exception {
    }

    public void leavingPage() throws Exception {
    }
}

