/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvAlarmStore;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.functional.FunctMpoOpg;
import cerent.cms.ui.functional.FunctPassivePortGraphic;
import cerent.cms.ui.functional.FunctPortGraphic;
import cerent.util.view.fv.IViewOPG;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.SvgParamsHelper;
import cerent.util.view.fv.helper.ViewModelUpdateType;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;

public class FunctOPG
implements IViewOPG,
Observer,
Runnable {
    private static final int HATCH_PORT_MASK = 4;
    public static final int PORT_SIZE_NORMAL = 0;
    protected static final int PORT_SIZE_SMALL = 1;
    private int portNo;
    private int slotNo;
    private ViewPortGraphic portGraphic;
    private IFvAlarmStore alarmStore;
    private IFvInterfaceModel ifModel = null;
    protected IFvPortModel portModel;
    private String statusString = "";
    private Color currentColor = Color.gray;
    private int currentSeverity = 0;
    private int currentAdminStatus = -1;
    private int currentPortState = 0;
    private int currentServiceStateType = -1;
    private Thread thrd;
    private FunctMpoOpg parentMpoOpg = null;

    public FunctOPG(ViewPortGraphic viewPortGraphic, IFvPortModel iFvPortModel) {
        this.portGraphic = viewPortGraphic;
        this.portModel = iFvPortModel;
        if (this.portModel == null && ViewPortGraphic.db.on()) {
            ViewPortGraphic.db.println("null");
        }
        this.slotNo = this.portModel.getSlot();
        this.portNo = this.portModel.getPort();
        if (!(this.portGraphic instanceof FunctPassivePortGraphic) && !this.portModel.getCardModel().isPassiveModule()) {
            if (iFvPortModel.getIFvNodeModel().getIFvAlarmStore() != null) {
                this.alarmStore = iFvPortModel.getIFvNodeModel().getIFvAlarmStore().getIFvCardAlarmStore(iFvPortModel.getShelfId(), this.slotNo);
                this.alarmStore.addAlarmStatusObserver((Observer)this);
            }
            IFvInterfaceModel iFvInterfaceModel = this.portModel.getIFvInterfaceModel();
            this.setIfModel(iFvInterfaceModel);
            this.thrd = new Thread((Runnable)this, "FunctOpticalPort Init:" + this.slotNo + ":" + this.portNo);
        }
    }

    public FunctOPG(ViewPortGraphic viewPortGraphic, IFvPortModel iFvPortModel, FunctMpoOpg functMpoOpg) {
        this(viewPortGraphic, iFvPortModel);
        this.parentMpoOpg = functMpoOpg;
    }

    private void setIfModel(IFvInterfaceModel iFvInterfaceModel) {
        this.ifModel = iFvInterfaceModel;
    }

    protected IFvInterfaceModel getIfModel() {
        return this.ifModel;
    }

    public IFvPortModel getPortModel() {
        return this.portModel;
    }

    private void repaint(ViewPortGraphic viewPortGraphic) {
        if (viewPortGraphic != null) {
            viewPortGraphic.repaint();
        }
    }

    public void update(Observable observable, Object object) {
        block9: {
            try {
                if (observable instanceof IFvModel) {
                    if (((Integer)object).intValue() == ViewModelUpdateType.CHANGED.intValue()) {
                        this.updateCurrentState((IFvInterfaceModel)observable);
                        return;
                    }
                    if (((Integer)object).intValue() == ViewModelUpdateType.DELETED.intValue()) {
                        observable.deleteObserver(this);
                        return;
                    }
                } else if (object instanceof IFvAlarmStatus) {
                    this.currentAdminStatus = -1;
                    this.handleAlarm();
                }
            }
            catch (ClassCastException classCastException) {
                if (this.portModel != null) {
                    if (ViewPortGraphic.db.on()) {
                        ViewPortGraphic.db.println("ClassCastException: " + this.portModel.getEqLabel() + " = " + this.portModel.getIndex());
                        ViewPortGraphic.db.println("The received object is" + observable);
                        ViewPortGraphic.db.println(" and not IFvInterfaceModel");
                    }
                }
                if (!ViewPortGraphic.db.on()) break block9;
                ViewPortGraphic.db.println("ClassCastException with NULL PortModel");
            }
        }
    }

    private String getPortDescription() {
        StringBuffer stringBuffer = new StringBuffer("Port ");
        IFvInterfaceModel iFvInterfaceModel = this.getIfModel();
        if (iFvInterfaceModel != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.portModel.getPortString());
            stringBuffer.append("]: ");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.portNo);
            stringBuffer.append("]: ");
        }
        return stringBuffer.toString();
    }

    private String getProtectionDescription() {
        if (this.ifModel == null) {
            return "N/A";
        }
        return this.portModel.getProtectionDescription(this.ifModel);
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPortDescription());
        if (!(this.portGraphic instanceof FunctPassivePortGraphic)) {
            try {
                stringBuffer.append(this.statusString);
                stringBuffer.append(this.getAlarmStatusString());
                stringBuffer.append(this.getProtectionDescription());
            }
            catch (Exception exception) {
                stringBuffer.setLength(0);
            }
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        IFvInterfaceModel iFvInterfaceModel = this.getIfModel();
        if (iFvInterfaceModel != null) {
            iFvInterfaceModel.deleteObserver((Observer)this);
            try {
                if (this.portModel != null) {
                    this.portModel.deleteObserver((Observer)this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setIfModel(null);
        this.portGraphic = null;
        this.portModel = null;
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver((Observer)this);
        }
    }

    private void setAlarmState(int n) {
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            this.updateCurrentState(this.getIfModel());
            this.currentColor = SvgParamsHelper.getPortColorByAdminStateAndSeverity((int)this.currentAdminStatus, (int)n);
            this.repaint(this.portGraphic);
        }
    }

    private void updateCurrentState(IFvInterfaceModel iFvInterfaceModel) {
        int n;
        if (iFvInterfaceModel == null || this.portModel == null) {
            return;
        }
        int n2 = 0;
        IFvServiceState iFvServiceState = null;
        boolean bl = false;
        try {
            n2 = iFvInterfaceModel.getAdminState();
            iFvServiceState = iFvInterfaceModel.getIFvServiceState();
        }
        catch (NoSuchInterface noSuchInterface) {
            FunctDebug.printStackTrace((Throwable)noSuchInterface);
        }
        bl = n2 != this.currentAdminStatus || this.currentPortState != this.getPortState();
        int n3 = n = iFvServiceState == null ? -1 : iFvServiceState.getType();
        if (this.currentServiceStateType != n) {
            this.currentServiceStateType = n;
            this.statusString = this.portModel.getServiceStateDescription(this.currentServiceStateType);
        }
        if (n2 != this.currentAdminStatus) {
            this.currentAdminStatus = n2;
            this.currentColor = SvgParamsHelper.getPortColorByAdminStateAndSeverity((int)this.currentAdminStatus, (int)this.currentSeverity);
        }
        if (bl) {
            this.repaint(this.portGraphic);
        }
    }

    private int getPortState() {
        int n = 0;
        if (this.portModel.shouldCrossHatchPort()) {
            n |= 4;
        }
        return n;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    protected void registerWithModel() {
        if (this.ifModel != null) {
            this.ifModel.addObserver((Observer)this);
            try {
                this.portModel.addObserver((Observer)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getAlarmStatusString() {
        String string = "";
        if (this.alarmStore == null) {
            return string;
        }
        IFvAlarmStatus iFvAlarmStatus = this.alarmStore.getIFvEntityAlarmStatus(this.portModel);
        if (iFvAlarmStatus != null) {
            if (iFvAlarmStatus.critical() > 0) {
                string = "Critical";
            } else if (iFvAlarmStatus.major() > 0) {
                string = "Major";
            } else if (iFvAlarmStatus.minor() > 0) {
                string = "Minor";
            }
            string = string.length() > 0 ? ", " + string + " Alarm" : string;
        }
        return string;
    }

    public void run() {
        if (this.portModel != null) {
            if (ViewPortGraphic.db.on()) {
                ViewPortGraphic.db.println("Init: " + this.portModel.getEqLabel() + " = " + this.portModel.getIndex());
            }
            this.registerWithModel();
        }
        this.handleAlarm();
        if (this.parentMpoOpg != null) {
            this.parentMpoOpg.onePortInitialized(this);
        }
    }

    private void handleAlarm() {
        IFvAlarmStatus iFvAlarmStatus = null;
        if (this.alarmStore != null) {
            iFvAlarmStatus = this.alarmStore.getIFvEntityAlarmStatus(this.portModel);
        }
        if (iFvAlarmStatus != null) {
            this.setAlarmState(iFvAlarmStatus.getHighestSeverity());
        }
        if (this.ifModel != null) {
            this.updateCurrentState(this.ifModel);
        }
        if (this.portGraphic instanceof FunctPortGraphic) {
            ((FunctPortGraphic)this.portGraphic).setToolTipText(this.getTooltipText());
        }
    }

    public int getCurrentAdminStatus() {
        return this.currentAdminStatus;
    }

    public int getCurrentSeverity() {
        return this.currentSeverity;
    }

    public void init() {
        block5: {
            try {
                if (this.thrd != null) {
                    this.thrd.start();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (this.portModel != null) {
                    if (ViewPortGraphic.db.on()) {
                        ViewPortGraphic.db.println("IllegalThreadStateException: " + this.portModel.getEqLabel() + " = " + this.portModel.getIndex());
                    }
                }
                if (!ViewPortGraphic.db.on()) break block5;
                ViewPortGraphic.db.println("IllegalThreadStateExceptionwith NULL PortModel");
            }
        }
    }
}

