/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.ViewBandDomainGrapher;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import ilog.views.IlvGraphic;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctTxpCreator {
    protected ArrayList<ViewInternalLink> txpPatch;
    protected ArrayList<ViewInternalLink> links;
    protected Map<Integer, IFvCardModel> protectionCard;

    protected FunctTxpCreator(ArrayList<ViewInternalLink> arrayList, ArrayList<ViewInternalLink> arrayList2, Map<Integer, IFvCardModel> map) {
        this.txpPatch = arrayList;
        this.links = arrayList2;
        this.protectionCard = map;
    }

    abstract void createAndLinkTxp(IViewGraph var1) throws FunctException;

    public static void addTxpCards(IViewGraph iViewGraph, ArrayList<ViewInternalLink> arrayList, boolean bl) {
        if (!(iViewGraph instanceof ViewGrapher)) {
            return;
        }
        for (ViewInternalLink viewInternalLink : arrayList) {
            Attribute attribute;
            IFvPortModel iFvPortModel = viewInternalLink.getDwdmPort();
            IFvCardModel iFvCardModel = null;
            int n = 174;
            String string = null;
            try {
                iFvCardModel = iFvPortModel.getCardModel();
                if (iFvCardModel.isTxp()) {
                    n = ((IFvDwdmTrkLineModel)iFvPortModel.getIFvInterfaceModel()).getExpectedWaveLength();
                } else if (iFvPortModel instanceof IFvOpticsPortModel && (attribute = (IFvOpticsPortModel)iFvPortModel).isWavelengthSupported()) {
                    try {
                        n = ((IFvOpticsPortModel)iFvPortModel).getWaveLength();
                    }
                    catch (WrongPortType wrongPortType) {
                        wrongPortType.printStackTrace();
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            attribute = Wavelength.getWlAttribute(n);
            string = String.valueOf(attribute.getIntValue());
            IFvPortModel iFvPortModel2 = null;
            if (iFvCardModel.getEqType() == 293) {
                iFvPortModel2 = viewInternalLink.getDwdmPort();
            }
            if (!iViewGraph.getGraphChildren().containsKey(string) && !(iFvCardModel instanceof IFvPSMModuleModel)) {
                FunctTxpCreator.addTxpInGrapher((ViewGrapher)iViewGraph, iFvCardModel, string, iFvPortModel2);
                continue;
            }
            if (!(iFvCardModel instanceof IFvPSMModuleModel)) continue;
            string = ViewManager.idToString((int)iFvCardModel.getIndex());
            if (iViewGraph.getGraphChildren().containsKey(string)) continue;
            FunctTxpCreator.addTxpInGrapher((ViewGrapher)iViewGraph, iFvCardModel, string, iFvPortModel2);
        }
    }

    public static void addTxpInGrapher(ViewGrapher viewGrapher, IFvCardModel iFvCardModel, String string, IFvPortModel iFvPortModel) {
        IViewGraph iViewGraph = null;
        try {
            SvgParams svgParams = new SvgParams(viewGrapher.getViewManager().getNode(), viewGrapher.getViewManager(), 6, (IViewGraph)viewGrapher, (Object)viewGrapher.getTk(), (Object)iFvCardModel, IViewGraph.Layers.Card);
            if (string != null) {
                svgParams.setHasOtherInstance(true);
            }
            if (iFvPortModel != null) {
                svgParams.setDiscoveredPort(iFvPortModel);
            }
            iViewGraph = SvgFactoryDirector.getViewElem(svgParams);
            if (string != null) {
                ((ViewCardGrapher)iViewGraph).setGraphKey(string);
            }
            viewGrapher.addGraphNode((IViewGraph)((ViewCompositeGraphic)iViewGraph), false, IViewGraph.Layers.Card);
            if (viewGrapher instanceof ViewBandDomainGrapher && ((ViewBandDomainGrapher)viewGrapher).getEven() != 0) {
                ((ViewCardGrapher)iViewGraph).doFlipH();
                ((ViewCardGrapher)iViewGraph).graphicFlipPortsLabel(1.0, -1.0);
            }
            viewGrapher.setMovable((IlvGraphic)((ViewCompositeGraphic)iViewGraph), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

