/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvEditDialog;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticalPatchCordModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.fv.net.IFvNetSidePosition;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.FVNodeModelDelegate;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PSMModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.MultishelfEventPanelController;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctNodeManager;
import cerent.cms.ui.functional.FunctView;
import cerent.cms.ui.functional.FunctViewInternalLink;
import cerent.cms.ui.functional.FunctionalCircuitPath;
import cerent.cms.ui.functional.FunctionalEditDialog;
import cerent.cms.ui.ms.MultishelfTabbedView;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.util.IFvDebug;
import cerent.util.view.fv.IFvOpenActions;
import cerent.util.view.fv.IViewCommand;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewLinksManager;
import cerent.util.view.fv.TreeViewCommand;
import cerent.util.view.fv.ViewCircuitPath;
import cerent.util.view.fv.ViewCommand;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewMouseAdapter;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.SvgParams;
import java.awt.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TreeSelectionEvent;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManagerDelegate
extends ViewManager
implements Observer {
    private IFvDebug db = FunctDebug.instance();
    private FunctNodeManager nodeManager = null;
    private ViewMouseAdapter mouseAdapter = null;
    private TccLinks tccLinks = null;
    private IEventPanelController iEpc = null;

    public ViewCommand getTreeViewCommand(TreeSelectionEvent treeSelectionEvent) {
        return new TreeViewCommand((ViewManager)this, (IViewCommand)this.getFunctNodeManager(), 1, treeSelectionEvent);
    }

    public ViewManagerDelegate(IFvNodeModel iFvNodeModel, IFvEditDialog iFvEditDialog, boolean bl, IFvNetSidePosition iFvNetSidePosition, IFvOpenActions iFvOpenActions) {
        super(iFvNodeModel, iFvEditDialog);
        this.startConstructor(bl);
        if (this.getNodeLinks().size() > 0) {
            this.setViewTk(new FunctView(iFvNodeModel, this, iFvNetSidePosition));
        } else {
            this.setViewTk(null);
        }
        this.endConstructor(iFvOpenActions);
    }

    public ViewManagerDelegate(IFvNodeModel iFvNodeModel, FunctionalEditDialog functionalEditDialog, IFvOpenActions iFvOpenActions) {
        super(iFvNodeModel, (IFvEditDialog)functionalEditDialog);
        this.startConstructor(false);
        if (this.getNodeLinks().size() > 0) {
            this.setViewTk(new FunctView(iFvNodeModel, this));
        } else {
            this.setViewTk(null);
        }
        this.findViewControllerAndToolKit(((FunctionalEditDialog)this.parentdialog).getParent());
        this.endConstructor(iFvOpenActions);
    }

    private void startConstructor(boolean bl) {
        this.setFromNfv(bl);
        this.tccLinks = new TccLinks(((FVNodeModelDelegate)this.nm).getDelegate(), "ViewManagerDelegate:TccLinks");
    }

    private void endConstructor(IFvOpenActions iFvOpenActions) {
        this.fvActions = iFvOpenActions;
        this.circuitPath = new ViewCircuitPath(this.getViewTk());
    }

    public FunctNodeManager getFunctNodeManager() {
        if (this.nodeManager == null) {
            this.nodeManager = new FunctNodeManager(this.nm, this);
        }
        return this.nodeManager;
    }

    public void setFunctNodeManager(FunctNodeManager functNodeManager) {
        this.nodeManager = functNodeManager;
    }

    public ViewMouseAdapter getMouseAdapter() {
        if (this.mouseAdapter == null) {
            this.mouseAdapter = new ViewMouseAdapter((ViewManager)this);
        }
        return this.mouseAdapter;
    }

    public IFvEditDialog getParentDialog() {
        return this.parentdialog;
    }

    private ArrayList<ViewInternalLink> getTccLinks() {
        ViewManager.addToLog((Object)this, (String)"call getTccLinks");
        List<OptLinkModel> list = this.getNodePatches();
        ArrayList<ViewInternalLink> arrayList = new ArrayList<ViewInternalLink>();
        Iterator<OptLinkModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            SvgParams svgParams = new SvgParams();
            svgParams.vm = this;
            svgParams.linkModel = iterator.next();
            svgParams.layer = IViewGraph.Layers.Link;
            FunctViewInternalLink functViewInternalLink = new FunctViewInternalLink(svgParams);
            if (this.db.on()) {
                try {
                    this.db.println("from->" + ((OptLinkModel)functViewInternalLink.getLink()).getFromPortModel().getEqTypeName() + " side=" + functViewInternalLink.getSideFrom() + " to->" + ((OptLinkModel)functViewInternalLink.getLink()).getToPortModel().getEqTypeName() + " side=" + functViewInternalLink.getSideTo());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    abstractCmsNoSuchEntityException.printStackTrace();
                }
            }
            arrayList.add(functViewInternalLink);
        }
        return arrayList;
    }

    public ArrayList<ViewInternalLink> getNodeLinks() {
        ViewManager.addToLog((Object)this, (String)"call getNodeLinks");
        try {
            return (ArrayList)this.tccLinks.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            abstractCmsIOException.printStackTrace();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        return new ArrayList<ViewInternalLink>();
    }

    private List<OptLinkModel> getNodePatches() {
        List<OptLinkModel> list = null;
        OptLinkModel[] optLinkModelArray = ((FVNodeModelDelegate)this.nm).getDelegate().getOpticalPatchCordModel().getAllOptLinkModel();
        list = Arrays.asList(optLinkModelArray);
        return list;
    }

    public ArrayList<ViewInternalLink> getLinksBySide(ArrayList<ViewInternalLink> arrayList, int n) {
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            if (!viewInternalLink.isOfSide(n)) continue;
            arrayList2.add(viewInternalLink);
        }
        return arrayList2;
    }

    public ArrayList<ViewInternalLink> getTxLink() {
        return this.getTxLink(this.getNodeLinks());
    }

    public ArrayList<ViewInternalLink> getTxLink(ArrayList<ViewInternalLink> arrayList) {
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            if (viewInternalLink.getSideFrom() != -10000 && viewInternalLink.getSideTo() != -10000) continue;
            arrayList2.add(viewInternalLink);
        }
        return arrayList2;
    }

    public ArrayList<ViewInternalLink> getLinksCrossSide(ArrayList<ViewInternalLink> arrayList) {
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            if (viewInternalLink.isTXPLnk() || !viewInternalLink.isCrossSide()) continue;
            arrayList2.add(viewInternalLink);
        }
        return arrayList2;
    }

    public Map<ViewManager.ViewPortTypeEnum, Map<Integer, IFvCardModel>> getDomainSortedCards(IFvSideModel[] iFvSideModelArray, ArrayList<ViewInternalLink> arrayList) {
        HashMap<ViewManager.ViewPortTypeEnum, Map<Integer, IFvCardModel>> hashMap = new HashMap<ViewManager.ViewPortTypeEnum, Map<Integer, IFvCardModel>>();
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        arrayList2.addAll(arrayList);
        HashMap<Integer, IFvCardModel> hashMap2 = new HashMap<Integer, IFvCardModel>();
        Map<Integer, IFvCardModel> map = this.filterOutTXPLink(arrayList2);
        Map<Integer, IFvCardModel> map2 = this.filterOutDropLink(arrayList2, iFvSideModelArray, hashMap2);
        Map<Integer, IFvCardModel> map3 = this.filterOutAddLink(arrayList2, iFvSideModelArray);
        Map<Integer, IFvCardModel> map4 = this.filterOutOtsLink(arrayList2, iFvSideModelArray);
        hashMap.put(ViewManager.ViewPortTypeEnum.TXP, map);
        hashMap.put(ViewManager.ViewPortTypeEnum.OTS, map4);
        hashMap.put(ViewManager.ViewPortTypeEnum.DROP, map2);
        hashMap.put(ViewManager.ViewPortTypeEnum.ADD, map3);
        hashMap.put(ViewManager.ViewPortTypeEnum.PROT, hashMap2);
        return hashMap;
    }

    public Map<Integer, IFvCardModel> filterOutTXPLink(ArrayList<ViewInternalLink> arrayList) {
        HashMap<Integer, IFvCardModel> hashMap = new HashMap<Integer, IFvCardModel>();
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            if (!viewInternalLink.isTXPLnk()) continue;
            IFvCardModel iFvCardModel = viewInternalLink.getNotOptPort().getCardModel();
            IFvPortModel iFvPortModel = viewInternalLink.getNotOptPort();
            int n = 0;
            try {
                n = iFvPortModel.getIFvInterfaceModel().getExpectedWaveLength();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            hashMap.put(n, iFvCardModel);
            arrayList2.add(viewInternalLink);
        }
        arrayList.removeAll(arrayList2);
        return hashMap;
    }

    private Map<Integer, IFvCardModel> filterOutDropLink(ArrayList<ViewInternalLink> arrayList, IFvSideModel[] iFvSideModelArray, Map<Integer, IFvCardModel> map) {
        HashMap<Integer, IFvCardModel> hashMap = new HashMap<Integer, IFvCardModel>();
        ArrayList<OptLinkModel> arrayList2 = new ArrayList<OptLinkModel>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            IFvCardModel iFvCardModel = null;
            IFvCardModel iFvCardModel2 = null;
            OptLinkModel optLinkModel = (OptLinkModel)viewInternalLink.getLink();
            try {
                iFvCardModel = (IFvCardModel)optLinkModel.getFromPortModel().getModuleModel();
                iFvCardModel2 = (IFvCardModel)optLinkModel.getToPortModel().getModuleModel();
                if (iFvCardModel == null || iFvCardModel2 == null) continue;
                if (this.isOfType(iFvSideModelArray, optLinkModel.getFromPortModel(), ViewManager.ViewPortTypeEnum.DROP)) {
                    this.considerPsm(hashMap, iFvCardModel2, iFvCardModel, map);
                    arrayList2.add(optLinkModel);
                    continue;
                }
                if (!ViewManagerDelegate.isOfType((IFvCardModel)iFvCardModel2, (ViewManager.ViewPortTypeEnum)ViewManager.ViewPortTypeEnum.DROP)) continue;
                this.considerPsm(hashMap, iFvCardModel, iFvCardModel2, map);
                arrayList2.add(optLinkModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
        }
        arrayList.removeAll(arrayList2);
        return hashMap;
    }

    private void considerPsm(Map<Integer, IFvCardModel> map, IFvCardModel iFvCardModel, IFvCardModel iFvCardModel2, Map<Integer, IFvCardModel> map2) {
        if (!(iFvCardModel2 instanceof IFvPSMModuleModel) && !(iFvCardModel instanceof IFvPSMModuleModel)) {
            if (!map.containsKey(iFvCardModel.getIndex())) {
                map.put(iFvCardModel.getIndex(), iFvCardModel2);
            } else if (iFvCardModel2 != map.get(iFvCardModel.getIndex())) {
                map.put(iFvCardModel.getIndex() + 1, iFvCardModel2);
            }
        } else {
            PSMModuleModel pSMModuleModel = iFvCardModel2 instanceof IFvPSMModuleModel ? (PSMModuleModel)iFvCardModel2 : (PSMModuleModel)iFvCardModel;
            switch (pSMModuleModel.getPSMType()) {
                case 1: {
                    map2.put(pSMModuleModel.getEntityIndex(), pSMModuleModel);
                    break;
                }
                case 0: 
                case 2: {
                    map.put(iFvCardModel.getIndex(), iFvCardModel2);
                }
            }
        }
    }

    private Map<Integer, IFvCardModel> filterOutAddLink(ArrayList<ViewInternalLink> arrayList, IFvSideModel[] iFvSideModelArray) {
        HashMap<Integer, IFvCardModel> hashMap = new HashMap<Integer, IFvCardModel>();
        ArrayList<OptLinkModel> arrayList2 = new ArrayList<OptLinkModel>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            IFvCardModel iFvCardModel = null;
            IFvCardModel iFvCardModel2 = null;
            OptLinkModel optLinkModel = (OptLinkModel)viewInternalLink.getLink();
            try {
                iFvCardModel = (IFvCardModel)optLinkModel.getFromPortModel().getModuleModel();
                iFvCardModel2 = (IFvCardModel)optLinkModel.getToPortModel().getModuleModel();
                if (iFvCardModel2 == null || iFvCardModel == null) continue;
                if (this.isOfType(iFvSideModelArray, optLinkModel.getToPortModel(), ViewManager.ViewPortTypeEnum.ADD) && !hashMap.containsKey(iFvCardModel.getIndex())) {
                    hashMap.put(iFvCardModel.getIndex(), iFvCardModel2);
                    arrayList2.add(optLinkModel);
                    continue;
                }
                if (!ViewManagerDelegate.isOfType((IFvCardModel)iFvCardModel, (ViewManager.ViewPortTypeEnum)ViewManager.ViewPortTypeEnum.ADD) || hashMap.containsKey(iFvCardModel2.getIndex())) continue;
                hashMap.put(iFvCardModel2.getIndex(), iFvCardModel);
                arrayList2.add(optLinkModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
        }
        arrayList.removeAll(arrayList2);
        return hashMap;
    }

    private Map<Integer, IFvCardModel> filterOutOtsLink(ArrayList<ViewInternalLink> arrayList, IFvSideModel[] iFvSideModelArray) {
        Object object;
        Serializable serializable;
        Object object2;
        ViewInternalLink viewInternalLink22 = null;
        OpticsPortModel opticsPortModel = null;
        HashMap<Serializable, ViewInternalLink> hashMap = new HashMap<Serializable, ViewInternalLink>();
        for (ViewInternalLink viewInternalLink22 : arrayList) {
            if (viewInternalLink22.isTXPLnk() || viewInternalLink22.isPassiveLnk()) continue;
            try {
                object2 = ((OptLinkModel)viewInternalLink22.getLink()).getFromModel();
                if (!(object2 instanceof OpticsPortModel) || (opticsPortModel = (OpticsPortModel)object2) == null || !this.isOfType(iFvSideModelArray, opticsPortModel, ViewManager.ViewPortTypeEnum.OTS) || opticsPortModel.getOptPortType() != OpticalPortType.OUT_COM || hashMap.containsKey(serializable = Integer.valueOf(opticsPortModel.getParent().getIndex()))) continue;
                hashMap.put(serializable, viewInternalLink22);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
            catch (NoSuchEquipment noSuchEquipment) {
                noSuchEquipment.printStackTrace();
            }
            catch (WrongPortType wrongPortType) {
                wrongPortType.printStackTrace();
            }
        }
        object2 = null;
        serializable = new HashMap<Integer, IFvCardModel>();
        int n = 0;
        for (int i = 0; i < iFvSideModelArray.length; ++i) {
            if (iFvSideModelArray[i] == null) continue;
            for (int n2 : object = iFvSideModelArray[i].getLinesIn()) {
                object2 = this.nm.getEntityModelByIndex(n2) != null ? (IFvCardModel)this.nm.getEntityModelByIndex(n2).getParentModel() : null;
                if (object2 == null) continue;
                if (this.insertOtsNotPsm((IModuleModel)object2)) {
                    serializable.put(n, (IFvCardModel)object2);
                }
                for (int j = 0; j < (hashMap.size() > 1 ? hashMap.size() - 1 : hashMap.size()); ++j) {
                    if (!hashMap.containsKey(object2.getIndex())) continue;
                    ViewInternalLink viewInternalLink = (ViewInternalLink)hashMap.get(object2.getIndex());
                    try {
                        object2 = (IFvCardModel)((OptLinkModel)viewInternalLink.getLink()).getToPortModel().getParent();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        continue;
                    }
                    if (!this.insertOtsNotPsm((IModuleModel)object2)) continue;
                    serializable.put(++n, object2);
                }
            }
        }
        for (ViewInternalLink viewInternalLink22 : arrayList) {
            if (viewInternalLink22.isTXPLnk()) continue;
            try {
                IPortModel iPortModel = ((OptLinkModel)viewInternalLink22.getLink()).getToModel();
                object = iPortModel.getModuleModel();
                IPortModel iPortModel2 = ((OptLinkModel)viewInternalLink22.getLink()).getFromModel();
                if (!(iPortModel2 instanceof OpticsPortModel)) continue;
                opticsPortModel = (OpticsPortModel)iPortModel2;
                IModuleModel iModuleModel = opticsPortModel.getModuleModel();
                if (iPortModel != null && this.isOfType(iFvSideModelArray, (IFvPortModel)iPortModel, ViewManager.ViewPortTypeEnum.OTS) && !serializable.containsValue(object) && this.insertOtsNotPsm((IModuleModel)object)) {
                    serializable.put(++n, (IFvCardModel)object);
                }
                if (opticsPortModel == null || !this.isOfType(iFvSideModelArray, opticsPortModel, ViewManager.ViewPortTypeEnum.OTS) || serializable.containsValue(iModuleModel) || !this.insertOtsNotPsm(iModuleModel)) continue;
                serializable.put(++n, (IFvCardModel)iModuleModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
        }
        arrayList.removeAll(hashMap.values());
        return serializable;
    }

    private boolean insertOtsNotPsm(IModuleModel iModuleModel) {
        PSMModuleModel pSMModuleModel;
        return !(iModuleModel instanceof PSMModuleModel) || (pSMModuleModel = (PSMModuleModel)iModuleModel).getPSMType() != 1;
    }

    private static String getCardName(IFvNodeModel iFvNodeModel, IFvCardModel iFvCardModel) {
        String string = ",";
        String string2 = " ";
        String string3 = "(";
        String string4 = ")";
        StringBuffer stringBuffer = new StringBuffer(50);
        if (iFvNodeModel.isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(iFvCardModel.getShelfId());
            stringBuffer.append(string);
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(iFvCardModel.getSlot());
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        stringBuffer.append(iFvCardModel.getEqTypeName());
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    private IFvOpticalPatchCordModel getPatchCordModel() {
        return this.nm.getOpticalPatchCordModel();
    }

    public void regForEvent(Observer observer) {
    }

    public void unRegForEvent(Observer observer) {
    }

    @Override
    public void update(Observable observable, Object object) {
        this.tccLinks.update();
        this.updateLinks((Integer)object);
    }

    private void updateLinks(Integer n) {
        HashMap hashMap = ViewManagerDelegate.getGraphDomain((IViewGraph)this.getViewTk());
        ArrayList arrayList = (ArrayList)this.getNodeLinks().clone();
        Iterator iterator = hashMap.values().iterator();
        this.getViewTk().updateLinks(arrayList, n);
        while (iterator.hasNext()) {
            IViewGraph iViewGraph = (IViewGraph)iterator.next();
            if (!(iViewGraph instanceof IViewLinksManager)) continue;
            ((IViewLinksManager)iViewGraph).updateLinks(arrayList, n);
        }
    }

    private void disposeAll() {
        this.disposeChildren((IViewGraph)this.getViewTk());
    }

    private void disposeChildren(IViewGraph iViewGraph) {
        if (iViewGraph.getGraphChildren() != null && !iViewGraph.getGraphChildren().isEmpty()) {
            for (IViewGraph iViewGraph2 : iViewGraph.getGraphChildren().values()) {
                this.disposeChildren(iViewGraph2);
            }
        }
        iViewGraph.dispose();
    }

    public void dispose() {
        this.disposeAll();
        if (this.nodeManager != null) {
            this.nodeManager.dispose();
        }
        this.nodeManager = null;
        this.mouseAdapter.dispose();
        this.mouseAdapter = null;
        this.tccLinks = null;
        this.circuitPath.dispose();
        super.dispose();
    }

    public ArrayList<ViewInternalLink> getLinkByBand(ArrayList<ViewInternalLink> arrayList, ViewManager.IViewValueOfType iViewValueOfType) {
        ArrayList<ViewInternalLink> arrayList2 = new ArrayList<ViewInternalLink>();
        for (ViewInternalLink viewInternalLink : arrayList) {
            boolean bl = true;
            if (iViewValueOfType != null) {
                bl = iViewValueOfType.isEqual((Object)viewInternalLink);
            }
            if (!viewInternalLink.isTXPLnk() && !viewInternalLink.isPSMLnk() || !bl) continue;
            arrayList2.add(viewInternalLink);
        }
        return arrayList2;
    }

    public ArrayList<ViewInternalLink> getInternalLinks(HashMap<Integer, IViewLink> hashMap) {
        ArrayList<ViewInternalLink> arrayList = new ArrayList<ViewInternalLink>();
        for (IViewLink iViewLink : hashMap.values()) {
            if (iViewLink.getLinkModel() == null) continue;
            arrayList.add(iViewLink.getLinkModel());
        }
        return arrayList;
    }

    public boolean isOpticsCard(IFvCardModel iFvCardModel) {
        return iFvCardModel instanceof IFvOpticsCardModel;
    }

    public boolean isCardAddable(IFvCardModel iFvCardModel, IViewCommand iViewCommand) {
        if (iViewCommand instanceof ViewGrapher) {
            return this.isCardAddable(iFvCardModel, (ViewGrapher)iViewCommand);
        }
        if (iViewCommand instanceof FunctView) {
            return this.isTxpCard(iFvCardModel) || this.isOpticsCard(iFvCardModel);
        }
        return false;
    }

    public boolean isCardAddable(IFvCardModel iFvCardModel, ViewGrapher viewGrapher) {
        if (viewGrapher instanceof FunctBandDomainGrapher && this.isTxpCard(iFvCardModel)) {
            return true;
        }
        return !(viewGrapher instanceof FunctBandDomainGrapher) && this.isOpticsCard(iFvCardModel);
    }

    public void tryJump(ViewName viewName) {
        if (this.iEpc != null) {
            if (this.iEpc instanceof ShelfEventPanelController) {
                ((ShelfEventPanelController)this.iEpc).getAvc().tryJumpView(viewName);
            } else if (this.iEpc instanceof MultishelfEventPanelController) {
                ((MultishelfEventPanelController)this.iEpc).getAvc().tryJumpView(viewName);
            }
        }
    }

    private void findViewControllerAndToolKit(Container container) {
        while (container != null) {
            Container container2 = container.getParent();
            if (container instanceof AbstractPane) {
                container2 = ((AbstractPane)((Object)container)).getParentView();
            }
            if (container2 instanceof ShelfTabbedView) {
                ShelfTabbedView shelfTabbedView = (ShelfTabbedView)((Object)container2);
                this.iEpc = shelfTabbedView.getMyController();
                return;
            }
            if (container2 instanceof MultishelfTabbedView) {
                MultishelfTabbedView multishelfTabbedView = (MultishelfTabbedView)((Object)container2);
                this.iEpc = multishelfTabbedView.getMyController();
                return;
            }
            if (container2 instanceof CardTabbedView) {
                CardTabbedView cardTabbedView = (CardTabbedView)((Object)container2);
                this.iEpc = cardTabbedView.getMyController();
                return;
            }
            container = container2;
        }
    }

    public IGuestPaneFactory getToolKit() {
        return ((FVNodeModelDelegate)this.nm).getDelegate().getUiToolkit();
    }

    public IEventPanelController getEventPanelController() {
        return this.iEpc;
    }

    public void tryJumpSide(IFvSideModel iFvSideModel) {
        ((FunctionalEditDialog)this.parentdialog).tryJumpSide(iFvSideModel);
    }

    public ViewCircuitPath getCircuitsPathManager() {
        return this.circuitPath;
    }

    public IFvNodeModel getNodeModel() {
        return this.nm;
    }

    public IFvViewCircuitPath getFunctionalCircuitPath() {
        if (this.functCircuitPath == null) {
            this.functCircuitPath = new FunctionalCircuitPath(this, null);
        }
        return this.functCircuitPath;
    }

    class TccLinks
    extends CachedValue {
        public TccLinks(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return ViewManagerDelegate.this.getTccLinks();
        }

        protected Object cloneValue() {
            ArrayList<ViewInternalLink> arrayList = new ArrayList<ViewInternalLink>();
            for (ViewInternalLink viewInternalLink : (ArrayList)this.value) {
                arrayList.add(viewInternalLink);
            }
            return arrayList;
        }
    }
}

