/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.l2sc.L2scEtherPortInfoTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UTable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class L2scEtherPortInfoPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    private L2scEtherPortInfoTableModel dataModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private L2scModuleModel eqpmtModel = null;
    private int numLines = 0;
    private int numPorts = 0;
    private static final SDebug db = new SDebug("L2scEtherPortInfoPane");

    public L2scEtherPortInfoPane(String string, TabbedView tabbedView, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        Object var6_6 = null;
        this.eqpmtModel = null;
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        int n = this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof L2scModuleModel) {
            this.eqpmtModel = (L2scModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not L2scModuleModel");
        }
        this.dataModel = new L2scEtherPortInfoTableModel(this.eqpmtModel, l2scPortModelArray, etherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.setTableHeader(new UTableHeader(this.table.getColumnModel()));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        if (this.eqpmtModel.getEqType() == 102) {
            this.removeColumn(10);
        } else if (this.eqpmtModel.getEqType() == 103) {
            this.removeColumn(7);
            this.removeColumn(8);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(L2scEtherPortInfoTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(L2scEtherPortInfoTableModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.table.sizeColumnsToFit(-1);
        this.registerForUpdates();
        this.add(jScrollPane);
    }

    private void removeColumn(int n) {
        String string;
        TableColumn tableColumn;
        if (n >= 0 && n < L2scEtherPortInfoTableModel.columnNames.length && (tableColumn = this.table.getColumn(string = L2scEtherPortInfoTableModel.columnNames[n])) != null) {
            this.table.removeColumn(tableColumn);
        }
    }

    private void registerForUpdates() {
        this.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (null != this.lineModels[i]) {
                this.lineModels[i].addObserver((Observer)((Object)this));
                if (!L2scEtherPortInfoPane.db.on) continue;
                db.finest("L2scEtherPortInfoPane added as observer for lineModel: " + this.lineModels[i]);
                continue;
            }
            db.println("Could not add observer for line=" + i + " because the lineModel is null!");
        }
    }

    public void update(Observable observable, Object object) {
        if (L2scEtherPortInfoPane.db.on) {
            db.finest("ob:" + observable + ", o:" + object);
        }
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                L2scEtherPortInfoPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else {
            this.dataModel.refresh();
            if (db.on()) {
                db.println("Do full refresh on table");
            }
        }
    }

    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
                if (!L2scEtherPortInfoPane.db.on) continue;
                db.finest("L2scEtherPortInfoPane deleted as observer for lineModel: " + this.lineModels[i]);
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        if (this.dataModel.isDirty()) {
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        try {
            this.dataModel.applyToModel();
            this.dataModel.resetDirty();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes. ", exception);
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refresh();
        this.dataModel.resetDirty();
    }

    public CSHelpID getHelpID() {
        CSHelpID cSHelpID = CSHelpConst.L2scEtherPortInfoPane;
        if (this.eqpmtModel != null && this.eqpmtModel.getEqType() == 238) {
            cSHelpID = CSHelpConst.MSISC100TEtherPortProvPane;
        }
        return cSHelpID;
    }

    class UTableHeader
    extends JTableHeader {
        TableColumnModel columnModel;

        public UTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.columnModel = tableColumnModel;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            int n2 = this.columnModel.getColumn(n).getModelIndex();
            L2scEtherPortInfoPane.this.dataModel;
            return L2scEtherPortInfoTableModel.columnToolTips[n2];
        }
    }
}

