/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.EtherMedia.sL2scEtherPortInfo;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.L2scEtherLineModel;
import cerent.cms.model.L2scEtherPortModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class L2scEtherPortInfoTableModel
extends AbstractTableModel
implements Observer {
    private L2scModuleModel eqpmtModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sL2scEtherPortInfo[] l2scEtherPortInfo = null;
    private String[] portName = null;
    private Boolean[] suppress = null;
    private int[] soakTime;
    public static String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "PSAS", "Soak Time", "Link State", "MTU", "Speed", "Duplex", "Flow Control", "Optics"};
    public static String[] columnToolTips = new String[]{null, null, null, "Pre-Service Alarm Suppression", "Alarm Soak Time", null, null, null, null, null, null};
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int PSAS_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int LINK_STATE_INDEX = 5;
    public static final int MTU_INDEX = 6;
    public static final int SPEED_INDEX = 7;
    public static final int DUPLEX_INDEX = 8;
    public static final int FLOW_CONTROL_INDEX = 9;
    public static final int OPTICS_INDEX = 10;
    private static final SDebug db = new SDebug("L2scEtherPortInfoTableModel");

    public L2scEtherPortInfoTableModel(L2scModuleModel l2scModuleModel, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = l2scModuleModel;
        this.isDirty = new boolean[this.numPorts][this.getColumnCount()];
        this.l2scEtherPortInfo = new sL2scEtherPortInfo[this.numPorts];
        this.portName = new String[this.numPorts];
        this.suppress = new Boolean[this.numPorts];
        this.soakTime = new int[this.numPorts];
        this.resetDirty();
        this.registerWithLineModels();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 3 || n2 == 4) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public sL2scEtherPortInfo getL2scEtherPortInfo(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.l2scEtherPortInfo[n] == null && this.portModels[n] instanceof L2scEtherPortModel) {
            L2scEtherPortModel l2scEtherPortModel = (L2scEtherPortModel)this.portModels[n];
            this.l2scEtherPortInfo[n] = l2scEtherPortModel.getL2scEtherPortInfo();
        }
        if (L2scEtherPortInfoTableModel.db.on) {
            db.finest("\ngetL2scEtherPortInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.l2scEtherPortInfo[n].adminState);
            db.finest("   linkProtocolState:" + this.l2scEtherPortInfo[n].linkProtocolState);
            db.finest("   mtu:" + this.l2scEtherPortInfo[n].mtu);
            db.finest("   duplex:" + this.l2scEtherPortInfo[n].duplex.value());
            db.finest("   flowControlNegotiated:" + this.l2scEtherPortInfo[n].flowControlNegotiated.value());
            db.finest("   opticsType:" + this.l2scEtherPortInfo[n].opticsType.value());
        }
        return this.l2scEtherPortInfo[n];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            L2scPortModel l2scPortModel = this.portModels[n];
            return String.valueOf(l2scPortModel.getPort() + l2scPortModel.getPortTypeString(n));
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "lineModels is null";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (L2scEtherPortInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.isDirty[n][1] = true;
            }
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getAdminState(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            boolean bl = this.l2scEtherPortInfo[n].adminState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing admin state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Boolean getPreServiceAlarmSuppress(int n) {
        if (this.lineModels[n] instanceof L2scEtherLineModel) {
            try {
                this.suppress[n] = ((L2scEtherLineModel)this.lineModels[n]).getPreServiceAlarmSuppress();
                if (L2scEtherPortInfoTableModel.db.on) {
                    db.println("getPSAS: row " + n + " suppress " + this.suppress[n]);
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                db.severe("Provisioning error caught accessing PSAS: " + (Object)((Object)eMCProvisionError));
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
            catch (Exception exception) {
                db.severe("Exception caught accessing PSAS: " + exception);
            }
        } else {
            db.info("Model is " + this.lineModels[n].getClass().getName());
        }
        if (this.suppress[n] == null) {
            this.suppress[n] = Boolean.FALSE;
        }
        return this.suppress[n];
    }

    private void setPreServiceAlarmSuppress(int n, Boolean bl) {
        this.suppress[n] = bl;
        this.isDirty[n][3] = true;
        if (L2scEtherPortInfoTableModel.db.on) {
            db.println("setPSAS, row " + n + " newSuppress " + bl);
        }
    }

    private int getSoakTime(int n) {
        try {
            this.soakTime[n] = this.lineModels[n].getSoakTime();
        }
        catch (NoSuchInterface noSuchInterface) {
            db.fine("No Such Interface: " + (Object)((Object)noSuchInterface));
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            boolean bl = this.l2scEtherPortInfo[n].linkProtocolState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getMTU(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            string = new Integer(this.l2scEtherPortInfo[n].mtu).toString();
        }
        catch (Exception exception) {
            if (L2scEtherPortInfoTableModel.db.on) {
                db.println("Exception caught accessing mtu: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getDuplex(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].duplex.value();
            switch (n2) {
                case 2: {
                    string = "Auto";
                    break;
                }
                case 0: {
                    string = "Full";
                    break;
                }
                case 1: {
                    string = "Half";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getSpeed(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].speed.value();
            switch (n2) {
                case 0: {
                    string = "10 Mbps";
                    break;
                }
                case 1: {
                    string = "100 Mbps";
                    break;
                }
                case 2: {
                    string = "1 Gbps";
                    break;
                }
                case 3: {
                    string = "Auto";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getFlowControl(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].flowControlNegotiated.value();
            switch (n2) {
                case 1: {
                    string = "Asymmetric";
                    break;
                }
                case 2: {
                    string = "Asymmetric local";
                    break;
                }
                case 0: {
                    string = "None";
                    break;
                }
                case 3: {
                    string = "Symmetric";
                    break;
                }
                default: {
                    string = "Unknown";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    private String getOpticsType(int n) {
        String string = "";
        try {
            this.getL2scEtherPortInfo(n);
            int n2 = this.l2scEtherPortInfo[n].opticsType.value();
            switch (n2) {
                case 2: {
                    string = "1000 LX";
                    break;
                }
                case 1: {
                    string = "1000 SX";
                    break;
                }
                case 3: {
                    string = "1000 ZX";
                    break;
                }
                case 50: {
                    string = "100 BX-D";
                    break;
                }
                case 49: {
                    string = "100 BX-U";
                    break;
                }
                case 46: {
                    string = "100 FX";
                    break;
                }
                case 47: {
                    string = "100 LX";
                    break;
                }
                case 0: {
                    string = "Unknown";
                    break;
                }
                case 4: {
                    string = "Unplugged";
                    break;
                }
                default: {
                    string = "REALLY_UNKNOWN";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block15: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.suppress[n];
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 5: {
                        return this.getLinkState(n);
                    }
                    case 6: {
                        return this.getMTU(n);
                    }
                    case 7: {
                        return this.getSpeed(n);
                    }
                    case 8: {
                        return this.getDuplex(n);
                    }
                    case 9: {
                        return this.getFlowControl(n);
                    }
                    case 10: {
                        return this.getOpticsType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block15;
                db.println("Error in getValueAt in L2scEtherPortInfoTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                this.setPreServiceAlarmSuppress(n, bl);
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            case 7: {
                return;
            }
            case 8: {
                return;
            }
            case 9: {
                return;
            }
            case 10: {
                return;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        this.l2scEtherPortInfo[n] = null;
        this.portName[n] = null;
        this.suppress[n] = this.getPreServiceAlarmSuppress(n);
        if (db.isFineEnabled()) {
            db.fine("refreshLineFromModel: row " + n + " suppress? " + this.suppress[n]);
        }
        this.soakTime[n] = this.getSoakTime(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.isDirty[i][1]) {
                this.lineModels[i].setAlias(this.portName[i]);
            }
            if (this.isDirty[i][3]) {
                try {
                    if (this.lineModels[i] instanceof L2scEtherLineModel) {
                        ((L2scEtherLineModel)this.lineModels[i]).setPreServiceAlarmSuppress(this.suppress[i]);
                        if (db.on()) {
                            db.println("applyToModel: row " + i + " setting PSAS " + this.suppress[i]);
                        }
                    }
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                }
            }
            if (this.isDirty[i][4]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.soakTime[i]);
                }
                this.lineModels[i].setSoakTime(this.soakTime[i]);
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void destroy() {
        this.unRegisterWithLineModels();
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.resetDirty();
        for (int i = 0; i < this.l2scEtherPortInfo.length; ++i) {
            this.l2scEtherPortInfo[i] = null;
            this.portName[i] = null;
            this.suppress[i] = null;
        }
        this.l2scEtherPortInfo = null;
        this.portName = null;
        this.suppress = null;
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.lineModels[i].deleteObserver(this);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if (this.lineModels == null) {
                if (db.on()) {
                    db.println("update: lineModels is null, cannot refresh.");
                }
                return;
            }
            int n = Arrays.asList(this.lineModels).indexOf(observable);
            if (n != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

