/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.EtherMedia.sEtherVtInfo;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.HoLoFactory;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class CEMRLoUsageTableModel
extends AbstractTableModel {
    public static final int VT_INDEX = 0;
    public static final int PORT_INDEX = 1;
    public static final int NEXT_STS = 2;
    public static final int NEXT_VT = 3;
    private static final SDebug db = new SDebug("CEMRLoUsageTableModel");
    private String[] columnNames;
    private ML2ModuleModel eqpmtModel = null;
    private sEtherVtInfo[] infoList = null;
    private ML2PosPortModel[] portModels = null;
    private EntityCellRenderer myPortRenderer;
    private int stsNum;

    public CEMRLoUsageTableModel(ML2ModuleModel mL2ModuleModel, int n) {
        this.eqpmtModel = mL2ModuleModel;
        this.initColumnNames();
        this.stsNum = n;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.infoList == null ? 0 : this.infoList.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block9: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLoIndex(this.infoList[n].vtNum, this.infoList[n].cktSize.value());
                    }
                    case 1: {
                        return String.valueOf(this.infoList[n].port);
                    }
                    case 2: {
                        if (this.infoList[n].nextVcgMemSts != 0) {
                            return this.getHoIndex(this.infoList[n].nextVcgMemSts);
                        }
                    }
                    case 3: {
                        if (this.infoList[n].nextVcgMemVt == 0) break;
                        return this.getLoIndex(this.infoList[n].nextVcgMemVt, this.infoList[n].cktSize.value());
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public String getHoIndex(int n) {
        int n2 = this.eqpmtModel.getNodeModel().getTdmProtocolType();
        if (db.on()) {
            db.println("LoUsage getHoIndex: sts=" + n + " framingType=" + n2);
        }
        IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n2, n);
        if (db.on()) {
            db.println("LoUsage getHoIndex: hoNum=" + iHoNum);
        }
        return String.valueOf(iHoNum.getHoNum());
    }

    private String getLoIndex(int n, int n2) {
        int n3 = this.eqpmtModel.getNodeModel().getTdmProtocolType();
        if (db.on()) {
            db.println("LoUsage getLoIndex: vt=" + n + " framingType=" + n3);
        }
        ILoNum iLoNum = HoLoFactory.idlVt2LoNum(n3, n2, n);
        if (db.on()) {
            db.println("LoUsage getLoIndex: loNum=" + iLoNum);
        }
        return HoLoHelper.getDisplay(iLoNum, "/", true);
    }

    public void updateTableModel() throws Exception {
        this.infoList = this.eqpmtModel.getEtherVtInfoList(this.stsNum);
        if (db.on()) {
            int n = this.infoList.length;
            db.println("\ngetEtherVtInfoList: stsNum=" + this.stsNum + "  length=" + n);
            for (int i = 0; i < n; ++i) {
                db.println(this.infoList[i].vtNum + "   " + this.infoList[i].port + "   " + this.infoList[i].nextVcgMemSts + "   " + this.infoList[i].nextVcgMemVt);
            }
        }
    }

    private void initColumnNames() {
        TDMTerminology tDMTerminology = this.eqpmtModel.getNodeModel().getTDMTerminology();
        this.columnNames = new String[4];
        this.columnNames[0] = tDMTerminology.getGeneralTerms(1);
        this.columnNames[1] = "Port";
        this.columnNames[2] = "Next " + tDMTerminology.getGeneralTerms(0) + " in VCG";
        this.columnNames[3] = "Next " + tDMTerminology.getGeneralTerms(1) + " in VCG";
    }
}

