/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.AbstractMsPassiveUnitGraphic;
import cerent.cms.ui.ms.AbstractMsShelfLayout;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.SDebug;
import cerent.util.gui.IconImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MsPassiveShelfLayout
extends AbstractMsShelfLayout {
    private static final Font TEXT_FONT = new Font("Arial", 0, 10);
    public static final SDebug db = new SDebug("MsPassiveShelfLayout");

    public MsPassiveShelfLayout(IShelfViewModel iShelfViewModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iShelfViewModel, abstractViewController, bayViewPanel);
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labels == null) {
            this.labels = new JLabel[this.getShelfSlotCount()];
            for (int i = 0; i < this.getShelfSlotCount(); ++i) {
                this.labels[i] = new JLabel("");
            }
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new GridLayout(1, this.getShelfSlotCount()));
        Dimension dimension = new Dimension(this.getUnitWidth(), this.getUnitHeight());
        ShelfTransferHandler shelfTransferHandler = new ShelfTransferHandler(this.chassis.getNodeModelDelegate().getChassisModelsInstance(), this.bvp.getRVP().getMVP());
        for (int i = 0; i < this.getShelfSlotCount(); ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new MsPassiveCardPanel(iconImpl, this, i + 1);
            this.cards[i].addMouseListener(this.mouseListener);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(shelfTransferHandler);
            this.slotsPanel.add(this.cards[i]);
        }
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setTransferHandler(shelfTransferHandler);
        this.refreshShelfColor();
    }

    protected void populateAllSlots() {
        for (int i = 0; i < this.getShelfSlotCount(); ++i) {
            PassiveModuleModel passiveModuleModel = ((PassiveChassisModel)this.chassis).getChildOfSlotNumber(i + 1);
            CardGraphic cardGraphic = this.createCard(passiveModuleModel, this, i + 1);
            this.addCard(i + 1, cardGraphic, passiveModuleModel);
        }
    }

    protected void refreshShelfLayout() {
        for (int i = 1; i <= this.getShelfSlotCount(); ++i) {
            this.removeCard(i);
        }
        this.populateAllSlots();
    }

    public int getShelfSlotCount() {
        if (this.chassis instanceof PassiveChassisModel) {
            return ((PassiveChassisModel)this.chassis).getNumberOfSlots();
        }
        return 0;
    }

    protected void configSpecialModule() {
    }

    protected int getUnitWidth() {
        return 205 / this.getShelfSlotCount();
    }

    protected int getUnitHeight() {
        return 10 * this.chassis.getRUOccupied() - 2;
    }

    private CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, int n) {
        if (entityModel != null) {
            if (entityModel.getEqType() == 308 || entityModel.getEqType() == 309) {
                return new MSMd40OddEvenPassiveUnit(abstractShelfLayout.getChassis(), entityModel, (MsPassiveShelfLayout)abstractShelfLayout, n);
            }
            return new MSPassiveUnit(abstractShelfLayout.getChassis(), entityModel, (MsPassiveShelfLayout)abstractShelfLayout, n);
        }
        PassiveModuleModel passiveModuleModel = ((PassiveChassisModel)abstractShelfLayout.getChassis()).getInnerChild();
        if (passiveModuleModel != null) {
            return new MSID50AlonePassiveUnit(abstractShelfLayout.getChassis(), passiveModuleModel, (MsPassiveShelfLayout)abstractShelfLayout, n);
        }
        return new MSEmptyPassiveUnit(abstractShelfLayout.getChassis(), (MsPassiveShelfLayout)abstractShelfLayout, n);
    }

    private class AbstractCntrPassiveUnit
    extends MSPassiveUnit {
        private final PassiveModuleModel innerUnit;
        private final String innerUnitName;
        private final String innerUnitNameShort;
        private static final String DEL_INNER_UNIT = "Delete Inner Unit";

        public AbstractCntrPassiveUnit(IShelfViewModel iShelfViewModel, IEntityModel iEntityModel, PassiveModuleModel passiveModuleModel, String string, MsPassiveShelfLayout msPassiveShelfLayout2, int n) {
            super(iShelfViewModel, iEntityModel, msPassiveShelfLayout2, n);
            this.innerUnit = passiveModuleModel;
            this.innerUnitName = string;
            this.innerUnitNameShort = string.replace("PASSIVE ", "");
            if (passiveModuleModel != null) {
                ((MsCntrCardPainter)this.cardPainter).setInnerUnit(this.innerUnitNameShort);
            }
        }

        boolean isSelected(int n, int n2) {
            return this.cardPainter instanceof MsCntrCardPainter && ((MsCntrCardPainter)this.cardPainter).isInnerContainerSelected(n, n2);
        }

        public void rightMouseClicked(Point point, CardPanel cardPanel) {
            if (this.isSelected(point.x, point.y)) {
                this.db.info("rightMouseClicked for inner unit: " + this.innerUnit);
                JPopupMenu jPopupMenu = null;
                jPopupMenu = new JPopupMenu("Action");
                JMenuItem jMenuItem = null;
                if (this.innerUnit != null) {
                    jMenuItem = this.makeMenuAction(DEL_INNER_UNIT, this.userPriv);
                    jPopupMenu.add(jMenuItem);
                } else {
                    JMenu jMenu = new JMenu("Add Unit");
                    jMenuItem = this.makeMenuAction(this.innerUnitName, this.userPriv);
                    jMenu.add(jMenuItem);
                    jPopupMenu.add(jMenu);
                }
                jPopupMenu.show(cardPanel, point.x, point.y);
            } else {
                super.rightMouseClicked(point, cardPanel);
            }
        }

        public String getTooltipText(String string, MouseEvent mouseEvent) {
            if (this.isSelected(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.innerUnit != null) {
                    StringBuffer stringBuffer;
                    block6: {
                        stringBuffer = new StringBuffer("");
                        try {
                            stringBuffer.append(this.innerUnit.getEqLabel().replace("PASSIVE ", ""));
                            stringBuffer.append(" [");
                            stringBuffer.append(this.unitPosition);
                            stringBuffer.append("]:");
                            if (this.innerUnit instanceof PassiveModuleModel) {
                                AbstractCntrPassiveUnit.appendString(stringBuffer, this.innerUnit.getLocation());
                            }
                            AbstractCntrPassiveUnit.appendString(stringBuffer, ElementDefaults.eqStateToString(this.innerUnit.getState()));
                            if (this.innerUnit instanceof MfgEntityModel) {
                                AbstractCntrPassiveUnit.appendString(stringBuffer, this.innerUnit.getServiceSt().toString(this.terms));
                            }
                            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        }
                        catch (Exception exception) {
                            this.db.println("Error in getToolTipText");
                            if (!this.db.on) break block6;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    return stringBuffer.toString();
                }
                return this.innerUnitNameShort + " [" + this.unitPosition + "]: Not Provisioned";
            }
            return super.getTooltipText(string, mouseEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem && actionEvent.getActionCommand().equals(DEL_INNER_UNIT)) {
                this.cardBehavior.deleteCard(this, this.innerUnit);
                return;
            }
            super.actionPerformed(actionEvent);
        }

        public ICardPainter getCardPainter() {
            return new MsCntrCardPainter(this, (MsPassiveShelfLayout)this.parent);
        }
    }

    private class MSEmptyPassiveUnit
    extends AbstractMsPassiveUnitGraphic {
        public MSEmptyPassiveUnit(IShelfViewModel iShelfViewModel, MsPassiveShelfLayout msPassiveShelfLayout2, int n) {
            super(iShelfViewModel, null, msPassiveShelfLayout2, n);
        }

        public String getTooltipText(MouseEvent mouseEvent) {
            return "UNIT [" + this.unitPosition + "]: Empty";
        }

        public String toString() {
            return "EmptyPassiveUnit";
        }
    }

    private class MSID50AlonePassiveUnit
    extends AbstractCntrPassiveUnit {
        public MSID50AlonePassiveUnit(IShelfViewModel iShelfViewModel, PassiveModuleModel passiveModuleModel, MsPassiveShelfLayout msPassiveShelfLayout2, int n) {
            super(iShelfViewModel, null, passiveModuleModel, passiveModuleModel.getEqLabel(), msPassiveShelfLayout2, n);
        }

        protected eEqType[] getProvisionableUnits() {
            return new eEqType[]{eEqType.PASSIVE_MD_40_ODD, eEqType.PASSIVE_MD_40_EVEN};
        }
    }

    private class MSMd40OddEvenPassiveUnit
    extends AbstractCntrPassiveUnit {
        public MSMd40OddEvenPassiveUnit(IShelfViewModel iShelfViewModel, IEntityModel iEntityModel, MsPassiveShelfLayout msPassiveShelfLayout2, int n) {
            super(iShelfViewModel, iEntityModel, ((PassiveChassisModel)iShelfViewModel).getInnerChild(), EntityModel.eqType2Name(iShelfViewModel.getTDMTerminology(), eEqType.PASSIVE_MD_ID_50), msPassiveShelfLayout2, n);
        }
    }

    private class MSPassiveUnit
    extends AbstractMsPassiveUnitGraphic {
        public MSPassiveUnit(IShelfViewModel iShelfViewModel, IEntityModel iEntityModel, MsPassiveShelfLayout msPassiveShelfLayout2, int n) {
            super(iShelfViewModel, iEntityModel, msPassiveShelfLayout2, n);
        }

        public String getTooltipText(String string, MouseEvent mouseEvent) {
            StringBuffer stringBuffer;
            block7: {
                stringBuffer = new StringBuffer("");
                try {
                    stringBuffer.append(string);
                    stringBuffer.append(" [");
                    stringBuffer.append(this.unitPosition);
                    stringBuffer.append("]:");
                    if (this.entityM instanceof PassiveModuleModel) {
                        MSPassiveUnit.appendString(stringBuffer, ((PassiveModuleModel)this.entityM).getLocation());
                        String string2 = ((PassiveModuleModel)this.entityM).getExtraInfo();
                        if (string2 != null && string2.length() > 0) {
                            MSPassiveUnit.appendString(stringBuffer, string2);
                        }
                    }
                    if (this.hasProvisionedCard()) {
                        MSPassiveUnit.appendString(stringBuffer, this.getStateString());
                        if (this.entityM instanceof MfgEntityModel) {
                            MSPassiveUnit.appendString(stringBuffer, ((MfgEntityModel)this.entityM).getServiceSt().toString(this.terms));
                        }
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    } else {
                        stringBuffer.append("Empty");
                    }
                }
                catch (Exception exception) {
                    this.db.println("Error in getToolTipText");
                    if (!this.db.on) break block7;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return stringBuffer.toString();
        }
    }

    private class MsCntrCardPainter
    extends AbstractMsPassiveUnitGraphic.MsCardPainter {
        private final int INTRL_CNT_X_POS;
        private final int INTRL_CNT_Y_POS;
        private final int INTRL_CNT_WIDTH;
        private final int INTRL_CNT_HEIGHT;
        private final Rectangle intrlCntRectangle;
        private final float INTRL_CNT_LABEL_FONT_SIZE = 8.0f;
        private final int INTRL_CNT_LABEL_X_OFFSET;
        private final int INTRL_CNT_LABEL_Y_OFFSET;
        private String intrlCntLabel;

        public MsCntrCardPainter(CardGraphic cardGraphic, MsPassiveShelfLayout msPassiveShelfLayout2) {
            super(cardGraphic, msPassiveShelfLayout2, -1);
            this.INTRL_CNT_LABEL_FONT_SIZE = 8.0f;
            this.INTRL_CNT_X_POS = this.UNIT_WIDTH / 4 * 3 - 5;
            this.INTRL_CNT_Y_POS = 3;
            this.INTRL_CNT_WIDTH = 40;
            this.INTRL_CNT_HEIGHT = this.UNIT_HEIGHT - 7;
            this.intrlCntRectangle = new Rectangle(this.INTRL_CNT_X_POS, this.INTRL_CNT_Y_POS, this.INTRL_CNT_WIDTH, this.INTRL_CNT_HEIGHT);
            this.INTRL_CNT_LABEL_X_OFFSET = this.INTRL_CNT_X_POS + this.INTRL_CNT_WIDTH / 2;
            this.INTRL_CNT_LABEL_Y_OFFSET = this.UNIT_HEIGHT - 7;
            this.intrlCntLabel = null;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.intrlCntRectangle);
            graphics2D.setColor(this.getCurrentColor());
            graphics2D.fill(this.intrlCntRectangle);
            graphics2D.setColor(Color.black);
            if (this.intrlCntLabel != null) {
                Font font = graphics2D.getFont();
                Font font2 = font.deriveFont(1, 8.0f);
                graphics2D.setFont(font2);
                FontMetrics fontMetrics = component.getFontMetrics(font2);
                graphics2D.drawString(this.intrlCntLabel, this.INTRL_CNT_LABEL_X_OFFSET - fontMetrics.stringWidth(this.intrlCntLabel) / 2, this.INTRL_CNT_LABEL_Y_OFFSET);
                graphics2D.setFont(font);
            }
        }

        void setInnerUnit(String string) {
            this.intrlCntLabel = string;
        }

        Color getCurrentColor() {
            return this.intrlCntLabel != null ? Color.white : Color.gray.brighter();
        }

        boolean isInnerContainerSelected(int n, int n2) {
            return n >= this.INTRL_CNT_X_POS && n <= this.INTRL_CNT_X_POS + this.INTRL_CNT_WIDTH && n2 >= this.INTRL_CNT_Y_POS && n2 <= this.INTRL_CNT_Y_POS + this.INTRL_CNT_HEIGHT;
        }
    }

    private class MsPassiveCardPanel
    extends MsCardPanel {
        final int unitPosition;

        public MsPassiveCardPanel(Icon icon, AbstractShelfLayout abstractShelfLayout, int n) {
            super(icon, abstractShelfLayout);
            this.unitPosition = n;
        }

        protected CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
            return MsPassiveShelfLayout.this.createCard(entityModel, abstractShelfLayout, this.unitPosition);
        }
    }
}

