/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ShelfInfo;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ms.MultishelfLayoutEditDialog;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class NppMultishelfLayoutPane
extends AbstractShelfTablePane
implements ActionListener {
    private final int SHELF_ID_IDX = 0;
    private final int RACK_NUM_IDX = 1;
    private final int RACK_POS_IDX = 2;
    private final int SHELF_TY_IDX = 3;
    private final int NUM_COLUMNS = 4;
    protected ChassisModels chassisModels;
    private JButton editB;
    private static final SDebug db = new SDebug("NppMultishelfLayoutPane");

    public NppMultishelfLayoutPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.chassisModels = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getChassisModelsInstance();
        this.tvObs = this.chassisModels;
    }

    private JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.NppMultishelfLayoutPane));
        this.editB = new JButton("Edit");
        this.editB.addActionListener(this);
        jPanel2.add(this.editB);
        WindowHelper.setEnabled((JComponent)this.editB, (boolean)this.isUserAuthorized());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new ShelfIdColumnRenderer(), new RackNumColumnRenderer(), new RackPosColumnRenderer(), new ShelfTyColumnRenderer()};
        this.model = new SortableRowTableModel((RowDataSource)new ShelfRowSource(), columnRendererArray);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof ChassisModelUpdate) {
            this.getObservableManager().addObservable((Observable)((Object)((ChassisModelUpdate)object).getChassisModel()));
        }
        this.repopulateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            ShelfInfo[] shelfInfoArray = this.chassisModels.getShelfInfos();
            for (int i = 0; i < shelfInfoArray.length; ++i) {
                this.tableData.add(shelfInfoArray[i]);
            }
        }
    }

    public void repopulateTable() {
        super.repopulateTable();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.model.getRowCount()) {
            this.clearTableSelection();
        }
    }

    private void updateTableAfterDelete(IShelfViewModel iShelfViewModel) {
        int n;
        if (this.nodeModel != null && this.nodeModel.isInited() && this.nodeModel.getConnectionState()) {
            ShelfInfo shelfInfo = null;
            for (ShelfInfo shelfInfo2 : this.tableData) {
                if (shelfInfo2.getShelfId() != iShelfViewModel.getShelfId()) continue;
                shelfInfo = shelfInfo2;
            }
            if (shelfInfo != null) {
                this.tableData.remove(shelfInfo);
            }
            if (this.model instanceof RowTableModel) {
                ((RowTableModel)this.model).dataSourceChanged();
            } else {
                this.model.fireTableDataChanged();
            }
        }
        if ((n = this.table.getSelectedRow()) < 0 || n > this.model.getRowCount()) {
            this.clearTableSelection();
        }
    }

    protected void registerWithModels() {
        this.getObservableManager().addObservable((Observable)((Object)this.chassisModels));
        IShelfViewModel[] iShelfViewModelArray = this.chassisModels.getShelfViewModels();
        for (int i = 0; i < iShelfViewModelArray.length; ++i) {
            this.getObservableManager().addObservable((Observable)((Object)iShelfViewModelArray[i]));
        }
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
        this.setDataSourceControl();
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelfInfo[] getShelfLayoutInfo() {
        ShelfInfo[] shelfInfoArray = null;
        List list = this.tableData;
        synchronized (list) {
            shelfInfoArray = this.tableData.toArray(new ShelfInfo[this.tableData.size()]);
        }
        return shelfInfoArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.editB)) {
            MultishelfLayoutEditDialog multishelfLayoutEditDialog = MultishelfLayoutEditDialog.instance(this);
            multishelfLayoutEditDialog.show();
            multishelfLayoutEditDialog.dispose();
        }
    }

    public void destroy() {
        db.info("destroy");
        if (this.getObservableManager() != null) {
            this.getObservableManager().reset();
        }
        super.destroy();
    }

    public void leavingPage() throws Exception {
        IShelfViewModel[] iShelfViewModelArray = this.chassisModels.getShelfViewModels();
        for (int i = 0; i < iShelfViewModelArray.length; ++i) {
            this.getObservableManager().removeObservable((Observable)((Object)iShelfViewModelArray[i]));
        }
        super.leavingPage();
    }

    public void deleteMessage(Observable observable, Object object) {
        this.updateTableAfterDelete((IShelfViewModel)((Object)observable));
        this.getObservableManager().removeObservable(observable);
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 0;
        }

        protected String getStringValue(ShelfInfo shelfInfo, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    if (shelfInfo.getShelfId() <= 12) {
                        string = "Shelf " + shelfInfo.getShelfId();
                        break;
                    }
                    string = "N/A";
                    break;
                }
                case 1: {
                    string = Integer.toString(shelfInfo.getRackNum());
                    break;
                }
                case 2: {
                    string = Integer.toString(shelfInfo.getRackPos());
                    break;
                }
                case 3: {
                    string = shelfInfo.getShelfTypeStr();
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ShelfInfo shelfInfo = (ShelfInfo)jTable.getValueAt(n, 0);
            String string = this.getStringValue(shelfInfo, n2);
            JLabel jLabel = new JLabel(string);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.black);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((ShelfInfo)object, n);
            String string2 = this.getStringValue((ShelfInfo)object2, n);
            return string.compareTo(string2);
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            this.getObservableManager().reset();
            NppMultishelfLayoutPane.this.registerWithModels();
            this.getObservableManager().setActive(true);
            this.initedOM = true;
            db.fine("initObservabledManager() done");
        }

        public void refreshFromModel() throws Exception {
            db.fine("InnerDsc::refreshFromModel()");
            if (!this.initedOM) {
                this.initObservableManager();
            }
            NppMultishelfLayoutPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)NppMultishelfLayoutPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class RackNumColumnRenderer
    extends BaseColumnRenderer {
        RackNumColumnRenderer() {
        }

        public String getName() {
            return "Rack Number";
        }

        public int getWidth() {
            return 150;
        }
    }

    class RackPosColumnRenderer
    extends BaseColumnRenderer {
        RackPosColumnRenderer() {
        }

        public String getName() {
            return "Rack Position";
        }

        public int getWidth() {
            return 150;
        }
    }

    class ShelfIdColumnRenderer
    extends BaseColumnRenderer {
        ShelfIdColumnRenderer() {
        }

        public String getName() {
            return "Shelf ID";
        }

        public int getWidth() {
            return 100;
        }
    }

    class ShelfRowSource
    extends AbstractRowDataSource {
        ShelfRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = NppMultishelfLayoutPane.this.tableData;
            synchronized (list) {
                var2_2 = NppMultishelfLayoutPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = NppMultishelfLayoutPane.this.tableData;
            synchronized (list) {
                n = NppMultishelfLayoutPane.this.tableData.size();
            }
            return n;
        }

        public Collection getAllObjects() {
            return NppMultishelfLayoutPane.this.tableData;
        }

        public Class getRowObjectClass() {
            return ShelfInfo.class;
        }
    }

    class ShelfTyColumnRenderer
    extends BaseColumnRenderer {
        ShelfTyColumnRenderer() {
        }

        public String getName() {
            return "Shelf Type";
        }

        public int getWidth() {
            return 150;
        }
    }
}

