/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.oadm.OadmOCHParametersProvPane;
import cerent.cms.ui.oadm.OadmOMSParametersProvPane;
import cerent.cms.ui.oadm.OadmOTSParametersProvPane;
import cerent.cms.ui.oadm.OadmOpticalThresholdPane;
import java.awt.Component;

public class OadmProvPane
extends NodeProvPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    protected OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsAmplifiedLineModel[] ampLineModels = this.model.getOpticsAmplifiedLineModels();
    private OpticsChannelModel[] chModels = this.model.getOpticsChannelModels();
    private OpticsMultiplexSectionModel[] omsModels = this.model.getOpticsOMSModels();
    private OpticsLineModel[] otsModels = this.model.getOpticsLineModels();

    public OadmProvPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model.getNodeModel();
        this.eqpmtModel = moduleModel;
        this.initProvPane(tabbedView);
    }

    protected void initProvPane(TabbedView tabbedView) {
        this.subTabs = new SubTabbedView(this.model, tabbedView);
        this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.subTabs));
        if (134 == this.eqpmtModel.getEqType() || 135 == this.eqpmtModel.getEqType() || 136 == this.eqpmtModel.getEqType()) {
            this.subTabs.addTab("Optical Chn", (Component)this.getOchTabs(this.subTabs, this.chModels));
        } else if (137 == this.eqpmtModel.getEqType() || 138 == this.eqpmtModel.getEqType()) {
            this.subTabs.addTab("Optical Band", (Component)this.getOmsTabs(this.subTabs, this.omsModels));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected Pane getOtsTabs(TabbedView tabbedView) {
        return new OadmOtsProvPane(tabbedView, this.otsModels);
    }

    protected Pane getOchTabs(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
        return new OadmOchProvPane(tabbedView, opticsChannelModelArray);
    }

    protected Pane getOmsTabs(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new OadmOmsProvPane(tabbedView, opticsMultiplexSectionModelArray);
    }

    protected Pane getOCHParametersProvTab(OpticsChannelModel[] opticsChannelModelArray) {
        return new OadmOCHParametersProvPane("Parameters", this.getParentView(), opticsChannelModelArray);
    }

    protected Pane getOTSParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new OadmOTSParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOmsParametersProvTab(OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new OadmOMSParametersProvPane("Parameters", this.getParentView(), opticsMultiplexSectionModelArray);
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new OadmOpticalThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    public boolean hasSubTabs() {
        return true;
    }

    private class OadmOchProvPane
    extends NodeProvPane {
        public OadmOchProvPane(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
            super("OadmOchProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)OadmProvPane.this.getOCHParametersProvTab(opticsChannelModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)OadmProvPane.this.getOptThresholdsTab(opticsChannelModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class OadmOmsProvPane
    extends NodeProvPane {
        public OadmOmsProvPane(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
            super("OadmOchProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)OadmProvPane.this.getOmsParametersProvTab(opticsMultiplexSectionModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)OadmProvPane.this.getOptThresholdsTab(opticsMultiplexSectionModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class OadmOtsProvPane
    extends NodeProvPane {
        public OadmOtsProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("OadmOtsProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)OadmProvPane.this.getOTSParametersProvTab(opticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)OadmProvPane.this.getOptThresholdsTab(opticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }
}

