/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ochterm.OchOpticalThresholdProvPane;
import cerent.cms.ui.ochterm.OchOpticalThresholdTableModel;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class OchOpticalThresholdPane
extends AbstractPane {
    protected AbstractOpticsLineModel[] lowerInterfaces;
    private ObservableManager _obsMgr = null;
    protected OchOpticalThresholdButtonPanel buttonPanel = null;
    JPanel labeledTablePanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected OpticsModuleModel eqpmtModel;
    public static final String WARNING_15MIN_TH_PANEL = "WARN_15MIN_TH";
    public static final String WARNING_1DAY_TH_PANEL = "WARN_1DAY_TH";
    public static final String ALARM_TH_PANEL = "ALARM_TH";
    public static final int WARNING_15MIN_TH = 0;
    public static final int WARNING_1DAY_TH = 1;
    public static final int ALARM_TH = 2;
    private boolean layoutInited = false;
    private JComboBox wlCB;
    private JLabel wlLabel;
    private JComboBox portCB;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private static final SDebug db = new SDebug("OchOpticalThresholdPane");

    public OchOpticalThresholdPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.panes = new Pane[4];
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.initializeLayout();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.layoutInited = true;
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
        this.getButtonPanel().refreshAction();
    }

    protected OchOpticalThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new OchOpticalThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.labeledTablePanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getOpticalThresholdProvPane(WARNING_15MIN_TH_PANEL, 0);
        this.tablePanel.add((Component)this.panes[0], WARNING_15MIN_TH_PANEL);
        this.panes[1] = this.getOpticalThresholdProvPane(WARNING_1DAY_TH_PANEL, 1);
        this.tablePanel.add((Component)this.panes[1], WARNING_1DAY_TH_PANEL);
        this.panes[2] = this.getOpticalThresholdProvPane(ALARM_TH_PANEL, 2);
        this.tablePanel.add((Component)this.panes[2], ALARM_TH_PANEL);
        this.cl.show(this.tablePanel, WARNING_15MIN_TH_PANEL);
        this.currentPane = this.panes[0];
        this.labeledTablePanel.add((Component)this.tableLabel, "North");
        this.labeledTablePanel.add((Component)this.tablePanel, "Center");
        return this.labeledTablePanel;
    }

    protected OchOpticalThresholdProvPane getOpticalThresholdProvPane(String string, int n) {
        return new OchOpticalThresholdProvPane(string, this.getParentView(), this.lowerInterfaces, n, this.wlCB, this.portCB);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            ((OchOpticalThresholdProvPane)pane).selectWlandPort();
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
            this.getButtonPanel().refreshAction();
        }
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            ((OchOpticalThresholdProvPane)this.panes[i]).dispose();
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    private JComboBox addCB(GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JComboBox jComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer());
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }

    protected void adjustColumn(int n) {
        this.removeColumn(4);
        this.removeColumn(3);
        this.removeColumn(5);
        this.removeColumn(6);
        this.removeColumn(7);
        if (n != 2) {
            this.addColumn(4);
            this.addColumn(3);
            this.setColumnW(3);
        } else {
            this.addColumn(5);
            this.addColumn(6);
            this.addColumn(7);
            this.setColumnW(4);
        }
    }

    protected void removeColumn(int n) {
        block2: {
            String string = OchOpticalThresholdTableModel.columnNames[n];
            try {
                TableColumn tableColumn = this.currentPane.getTable().getColumn(string);
                this.currentPane.getTable().removeColumn(tableColumn);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        String string = OchOpticalThresholdTableModel.columnNames[n];
        tableColumn.setHeaderValue(string);
        this.currentPane.getTable().getColumnModel().addColumn(tableColumn);
    }

    protected void setColumnW(int n) {
        TableColumn tableColumn = null;
        block4: for (int i = 0; i < n; ++i) {
            tableColumn = this.currentPane.getTable().getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(140);
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableColumn.setPreferredWidth(120);
                }
            }
        }
    }

    protected class OchOpticalThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonWarning;
        public JRadioButton buttonAlarm;
        public JButton showButton = new JButton("Retrieve");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup warningAlarmButtonGroup;
        protected int ALARM_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public OchOpticalThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonWarning = new JRadioButton("Warning", true);
            this.buttonAlarm = new JRadioButton("Alarm");
            this.warningAlarmButtonGroup = new ButtonGroup();
            this.warningAlarmButtonGroup.add(this.buttonWarning);
            this.warningAlarmButtonGroup.add(this.buttonAlarm);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OchOpticalThresholdButtonPanel.this.refreshAction();
                }
            });
            this.buttonWarning.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        OchOpticalThresholdButtonPanel.this.button15Min.setEnabled(true);
                        OchOpticalThresholdButtonPanel.this.button1Day.setEnabled(true);
                    } else {
                        OchOpticalThresholdButtonPanel.this.button15Min.setEnabled(false);
                        OchOpticalThresholdButtonPanel.this.button1Day.setEnabled(false);
                    }
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.buttonWarning, "North");
            jPanel.add((Component)this.buttonAlarm, "South");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            if (CommonHelper.isChannelPowerSupported(OchOpticalThresholdPane.this.eqpmtModel)) {
                JPanel jPanel3 = new JPanel(new GridBagLayout());
                CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(null);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets.bottom = 5;
                OchOpticalThresholdPane.this.wlLabel = new JLabel("Wavelenght: ");
                jPanel3.add((Component)OchOpticalThresholdPane.this.wlLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                OchOpticalThresholdPane.this.wlCB = OchOpticalThresholdPane.this.addCB(gridBagConstraints, jPanel3);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                JLabel jLabel = new JLabel("Port: ");
                jPanel3.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                OchOpticalThresholdPane.this.portCB = OchOpticalThresholdPane.this.addCB(gridBagConstraints, jPanel3);
                this.add(jPanel3);
            }
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            OchOpticalThresholdPane.this.tableLabelString = " ";
            if (this.warningAlarmButtonGroup.getSelection() == this.buttonAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm Thresholds");
                }
                n = this.ALARM_MASK;
                OchOpticalThresholdPane.this.tableLabelString = OchOpticalThresholdPane.this.tableLabelString + "Alarm Thresholds";
            } else {
                OchOpticalThresholdPane.this.tableLabelString = OchOpticalThresholdPane.this.tableLabelString + "Warning Thresholds";
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("1 Day");
                    }
                    n |= this.ONE_DAY_MASK;
                    OchOpticalThresholdPane.this.tableLabelString = OchOpticalThresholdPane.this.tableLabelString + ", 1 Day";
                } else {
                    OchOpticalThresholdPane.this.tableLabelString = OchOpticalThresholdPane.this.tableLabelString + ", 15 Min";
                }
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("WARNING 15MIN");
                    }
                    OchOpticalThresholdPane.this.showPanel(OchOpticalThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("WARNING 1DAY");
                    }
                    OchOpticalThresholdPane.this.showPanel(OchOpticalThresholdPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("ALARM TH");
                    }
                    OchOpticalThresholdPane.this.showPanel(OchOpticalThresholdPane.this.panes[2]);
                }
            }
            OchOpticalThresholdPane.this.tableLabel.setText(OchOpticalThresholdPane.this.tableLabelString);
            OchOpticalThresholdPane.this.adjustColumn(n);
        }
    }
}

