/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityContainer;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.ppm.PpmCard;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class PpmSlot
extends CardGraphic {
    private PpmCard ppmCard = null;
    private PpmModel ppmCardModel = null;
    private Rectangle mainRectangle;

    public PpmSlot(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
        super(entityModel, abstractShelfLayout, sDebug);
        if (sDebug.on()) {
            sDebug.println("PpmSlot: " + entityModel.getEqLabel() + "\tIndex: " + entityModel.getPositionInParent() + "\tNum of children: " + this.entityM.getChildren().size());
        }
        this.mainRectangle = this.cardPainter.getMainRectangle();
        this.setBounds(rectangle);
        this.createChildren();
    }

    protected void createChildren() {
        block7: {
            try {
                List list = this.entityM.getChildren();
                if (list.size() > 0) {
                    EntityModel entityModel = (EntityModel)list.get(0);
                    if (entityModel == null) {
                        return;
                    }
                    if (entityModel instanceof PpmModel) {
                        this.ppmCardModel = (PpmModel)entityModel;
                        this.ppmCard = this.createPpmCard(this.ppmCardModel, this.parent, new SDebug("PpmCard: " + this.ppmCardModel.getLocation()), this.getChildBounds());
                    } else if (this.db.on()) {
                        this.db.println("Entity is NOT PpmModel");
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                this.db.println("Exception while creating PPM card");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.registerForUpdates();
    }

    private void registerForUpdates() {
        if (this.entityM != null) {
            this.entityM.addObserver(this);
            if (this.ppmCardModel != null) {
                this.ppmCardModel.addObserver(this);
            }
            if (this.db.on()) {
                this.db.println("PpmSlot: Registered parent: " + this.entityM + "\tChild: " + this.ppmCardModel);
            }
        }
    }

    private void deregisterFromUpdates() {
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
            if (this.ppmCardModel != null) {
                this.ppmCardModel.deleteObserver(this);
            }
            if (this.db.on()) {
                this.db.println("PpmSlot: Deregistered parent: " + this.entityM + "\tChild: " + this.ppmCardModel);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (this.entityM == null) {
            if (this.db.on()) {
                this.db.println("update: entityM is NULL, no update");
            }
            return;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.ADDED) && observable == this.entityM) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (this.db.on()) {
                    this.db.println("PpmSlot: PPM card ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED) && observable instanceof PpmModel && (PpmModel)((Object)observable) == this.ppmCardModel) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (this.db.on()) {
                    this.db.println("PpmSlot: PPM Card DELETED");
                }
            }
        }
        super.update(observable, object);
    }

    public void draw(Graphics2D graphics2D) {
        this.computeVisibleRect(this.mainRectangle.getBounds());
        graphics2D.setColor(Color.gray.brighter());
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.mainRectangle);
        if (this.ppmCard != null) {
            this.ppmCard.draw(graphics2D);
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            if (this.ppmCard != null && this.ppmCard.contains(mouseEvent.getPoint())) {
                return this.ppmCard.getTooltipText(mouseEvent);
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getEqLabel());
            stringBuffer.append(" [");
            stringBuffer.append(PluggableHelper.getHierarchyNumString(((PluggableSlotModel)this.entityM).getHierarchyNums(), '-'));
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.mainRectangle.setBounds(rectangle);
        super.setBounds(this.mainRectangle);
    }

    protected Rectangle getChildBounds() {
        if (this.pci.is600()) {
            return new Rectangle(this.mainRectangle.x + 2, this.mainRectangle.y + 2, this.mainRectangle.width - 4, this.mainRectangle.height - 4);
        }
        return this.mainRectangle.getBounds();
    }

    public List getChildren() {
        ArrayList<PpmCard> arrayList = new ArrayList<PpmCard>();
        if (this.ppmCard != null) {
            arrayList.add(this.ppmCard);
        }
        return arrayList;
    }

    public boolean contains(Point point) {
        return point.x >= this.getX() && point.x <= this.getX() + this.getWidth() && point.y >= this.getY() && point.y <= this.getY() + this.getHeight();
    }

    public boolean hasProvisionedCard() {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.entityM instanceof EntityContainer) {
                    bl = this.entityM.getChildren().size() != 0;
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return bl;
    }

    protected void initLabel() {
    }

    public void dispose() {
        this.deregisterFromUpdates();
        if (this.ppmCard != null) {
            this.ppmCard.dispose();
            this.ppmCard = null;
        }
        super.dispose();
    }

    protected PpmCard createPpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
        return new PpmCard(entityModel, abstractShelfLayout, sDebug, rectangle);
    }

    private class ReplaceCard
    implements Runnable {
        private ReplaceCard() {
        }

        public void run() {
            block5: {
                try {
                    PpmSlot.this.deregisterFromUpdates();
                    if (PpmSlot.this.ppmCard != null) {
                        PpmSlot.this.ppmCard.dispose();
                        PpmSlot.this.ppmCard = null;
                    }
                    if (PpmSlot.this.entityM != null) {
                        PpmSlot.this.createChildren();
                    }
                }
                catch (Exception exception) {
                    if (!PpmSlot.this.db.on()) break block5;
                    PpmSlot.this.db.println("Error replacing PPM card: " + exception);
                    PpmSlot.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (PpmSlot.this.parent != null) {
                PpmSlot.this.parent.repaint();
            }
        }
    }
}

