/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Rmon.eAlarmSampleType;
import cerent.cms.idl.Rmon.eAlarmType;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.RmonThresholdModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;

public class RmonThresholdColumnRenderer
extends AbstractColumnRenderer {
    private static final int ALARM_INDEX = 0;
    private static final int SLOT_PORT = 1;
    private static final int VARIABLE = 2;
    private static final int ALARM_TYPE = 3;
    private static final int SAMPLE_TYPE = 4;
    private static final int INTERVAL = 5;
    private static final int RISING_THRESHOLD = 6;
    private static final int FALLING_THRESHOLD = 7;
    private static final int COLUMN_NO = 8;
    public static final String RMON_ALARM_TYPE_STRING = "RmonAlarmType";
    public static final String RMON_ALARM_SAMPLE_TYPE_FOR_FALLING_STRING = "RmonAlarmSampleTypeForFalling";
    public static final String RMON_ALARM_TYPE_FOR_ABSOLUTE_STRING = "RmonAlarmTypeForAbsolute";
    public static final String RMON_ALARM_SAMPLE_TYPE_STRING = "RmonAlarmSampleType";
    private static AttributeMaps attributeMap = new AttributeMaps();
    private JLabel label = new JLabel();
    private RmonThresholdManager rtm;
    protected static final SDebug db = new SDebug("RmonThresholdColumnRenderer");

    public RmonThresholdColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        sAlarmAdminInfo sAlarmAdminInfo2;
        String string = "";
        JLabel jLabel = this.label;
        RmonThresholdModel rmonThresholdModel = (RmonThresholdModel)object;
        this.rtm = RmonThresholdManager.getInstance((NodeModelDelegate)rmonThresholdModel.getNodeModel());
        try {
            sAlarmAdminInfo2 = rmonThresholdModel.getAlarmAdminInfo();
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = String.valueOf(rmonThresholdModel.getThresholdIndex());
                break;
            }
            case 1: {
                string = this.getSlotPort((NodeModelDelegate)rmonThresholdModel.getNodeModel(), sAlarmAdminInfo2.ifIndex);
                break;
            }
            case 2: {
                string = this.getStatsIdTypeString(sAlarmAdminInfo2.variable);
                break;
            }
            case 3: {
                string = this.getAlarmTypeString(sAlarmAdminInfo2.alarmType);
                break;
            }
            case 4: {
                string = this.getAlarmSampleTypeString(sAlarmAdminInfo2.sampleType);
                break;
            }
            case 5: {
                string = String.valueOf(sAlarmAdminInfo2.interval);
                break;
            }
            case 6: {
                string = String.valueOf(sAlarmAdminInfo2.risingThreshold);
                break;
            }
            case 7: {
                string = String.valueOf(sAlarmAdminInfo2.fallingThreshold);
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = RmonThresholdColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = RmonThresholdColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString(entityModel, false);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    private String getAlarmTypeString(eAlarmType eAlarmType2) {
        return RmonThresholdColumnRenderer.getRmonAttributeMaps().getAttributeForVal(RMON_ALARM_TYPE_STRING, eAlarmType2.value()).toString();
    }

    private String getAlarmSampleTypeString(eAlarmSampleType eAlarmSampleType2) {
        return RmonThresholdColumnRenderer.getRmonAttributeMaps().getAttributeForVal(RMON_ALARM_SAMPLE_TYPE_STRING, eAlarmSampleType2.value()).toString();
    }

    private String getStatsIdTypeString(eStatsId eStatsId2) {
        try {
            return this.rtm.getStatsIdStr(eStatsId2);
        }
        catch (Exception exception) {
            return "unknown or unsupported";
        }
    }

    public int compareColumn(Object object, Object object2, int n) {
        sAlarmAdminInfo sAlarmAdminInfo2;
        sAlarmAdminInfo sAlarmAdminInfo3;
        NodeModelDelegate nodeModelDelegate;
        int n2 = 0;
        try {
            nodeModelDelegate = (NodeModelDelegate)((RmonThresholdModel)object).getNodeModel();
            sAlarmAdminInfo3 = ((RmonThresholdModel)object).getAlarmAdminInfo();
            sAlarmAdminInfo2 = ((RmonThresholdModel)object2).getAlarmAdminInfo();
            this.rtm = RmonThresholdManager.getInstance(nodeModelDelegate);
        }
        catch (Exception exception) {
            return 0;
        }
        switch (n) {
            case 0: {
                n2 = ComparisonUtil.compare((int)((RmonThresholdModel)object).getThresholdIndex(), (int)((RmonThresholdModel)object2).getThresholdIndex());
                break;
            }
            case 1: {
                int n3;
                int n4;
                int n5 = RmonThresholdColumnRenderer.getSlotInt(nodeModelDelegate, sAlarmAdminInfo3.ifIndex);
                int n6 = RmonThresholdColumnRenderer.getSlotInt(nodeModelDelegate, sAlarmAdminInfo2.ifIndex);
                n2 = ComparisonUtil.compare((int)n5, (int)n6);
                if (n2 != 0 || (n2 = ComparisonUtil.compare((int)(n4 = RmonThresholdColumnRenderer.getPortInt(nodeModelDelegate, sAlarmAdminInfo3.ifIndex)), (int)(n3 = RmonThresholdColumnRenderer.getPortInt(nodeModelDelegate, sAlarmAdminInfo2.ifIndex)))) != 0) break;
                n2 = 0;
                break;
            }
            case 2: {
                n2 = this.rtm.getStatsIdSorter().compare(sAlarmAdminInfo3.variable, sAlarmAdminInfo2.variable);
                break;
            }
            case 3: {
                String string = this.getAlarmTypeString(sAlarmAdminInfo3.alarmType);
                String string2 = this.getAlarmTypeString(sAlarmAdminInfo2.alarmType);
                n2 = string.compareTo(string2);
                break;
            }
            case 4: {
                String string = this.getAlarmSampleTypeString(sAlarmAdminInfo3.sampleType);
                String string3 = this.getAlarmSampleTypeString(sAlarmAdminInfo2.sampleType);
                n2 = string.compareTo(string3);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)sAlarmAdminInfo3.interval, (int)sAlarmAdminInfo2.interval);
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare((long)sAlarmAdminInfo3.risingThreshold, (long)sAlarmAdminInfo2.risingThreshold);
                break;
            }
            case 7: {
                n2 = ComparisonUtil.compare((long)sAlarmAdminInfo3.fallingThreshold, (long)sAlarmAdminInfo2.fallingThreshold);
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[8];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = RmonThresholdColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Index";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Slot/Port";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Variable";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Alarm Type";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Sample Type";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Sample Period";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 6: {
                string = "Rising Threshold";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 7: {
                string = "Falling Threshold";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new RmonThresholdColumnRenderer(string, n3, bl, n2);
    }

    public static AttributeMaps getRmonAttributeMaps() {
        if (attributeMap.size() > 0) {
            return attributeMap;
        }
        String string = RMON_ALARM_TYPE_STRING;
        TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(1), new Attribute("Rising", 1));
        treeMap.put(new Integer(2), new Attribute("Falling", 2));
        treeMap.put(new Integer(3), new Attribute("Rising or Falling", 3));
        attributeMap.put(string, treeMap);
        string = RMON_ALARM_TYPE_FOR_ABSOLUTE_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(1), new Attribute("Rising", 1));
        attributeMap.put(string, treeMap);
        string = RMON_ALARM_SAMPLE_TYPE_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(1), new Attribute("Absolute", 1));
        treeMap.put(new Integer(2), new Attribute("Relative", 2));
        attributeMap.put(string, treeMap);
        string = RMON_ALARM_SAMPLE_TYPE_FOR_FALLING_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(2), new Attribute("Relative", 2));
        attributeMap.put(string, treeMap);
        return attributeMap;
    }
}

