/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceState;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.cms.ui.shelf.ColorBehaviour;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class CardGraphic
extends JComponent
implements Icon,
ImageObserver,
ActionListener,
Observer {
    protected static final String CHANGE_CARD_MENU_ITEM = "Change Card...";
    public static final int UNKNOWN = -1;
    public static final int NOT_PRESENT = 0;
    public static final int MISMATCH = 1;
    public static final int LOADING = 2;
    public static final int FAILED = 3;
    public static final int STANDBY = 4;
    public static final int ACTIVE = 5;
    public static final int DELETED = 6;
    public static final int ERROR = 7;
    public static final int PROVISIONED = 8;
    public static final int CRITICAL = 9;
    public static final int MAJOR = 10;
    public static final int MINOR = 11;
    public static final int OOS_MT = 12;
    protected ElementAlarmStore alarmStore;
    protected IAlarmStatus alarmStatus;
    protected eEqState eqState;
    protected EntityModel entityM;
    protected AbstractShelfLayout parent;
    protected CardBehavior cardBehavior;
    protected Color currentColor = Color.white;
    protected int slotNo;
    protected int nodeId;
    protected TDMTerminology terms;
    protected NodeModelDelegate nodeModel;
    protected boolean disabled = false;
    protected static final int DEFAULT_SLOTS_OCCUPIED = 1;
    protected int slotsOccupied = 1;
    protected ICardPainter cardPainter;
    protected IPlatform pci;
    protected boolean eqLabelIsSet = false;
    private boolean enablePortAlarm;
    protected SDebug db;

    public CardGraphic(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout) {
        this(iEntityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "CardGraphic:" + iEntityModel.getSlot()), false);
    }

    public CardGraphic(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        this(iEntityModel, abstractShelfLayout, sDebug, false);
    }

    public CardGraphic(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, boolean bl) {
        this((NodeModelDelegate)iEntityModel.getNodeModel(), iEntityModel, abstractShelfLayout, sDebug, bl);
    }

    public CardGraphic(NodeModelDelegate nodeModelDelegate, IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, boolean bl) {
        this.nodeModel = nodeModelDelegate;
        this.pci = this.nodeModel.getPlatform();
        this.terms = this.nodeModel.getTDMTerminology();
        this.db = sDebug;
        this.cardBehavior = this.pci.getCardBehavior(this.nodeModel, sDebug);
        this.entityM = (EntityModel)iEntityModel;
        this.parent = abstractShelfLayout;
        this.enablePortAlarm = bl;
        this.initialize();
    }

    public ICardPainter getCardPainter() {
        if (this.cardPainter != null) {
            return this.cardPainter;
        }
        return this.pci.getCardPainter(this);
    }

    public String toString() {
        return this.getEqLabel();
    }

    public int getSlot() {
        int n = 0;
        try {
            return this.entityM.getSlot();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return n;
        }
    }

    public int getSlotsOccupied() {
        return this.slotsOccupied;
    }

    protected void setSlotsOccupied(int n) {
        if (this.slotsOccupied != n) {
            if (this.db.on()) {
                this.db.println("setSlotsOccupied=" + n);
            }
            this.slotsOccupied = n;
            if (this.cardPainter != null) {
                this.cardPainter.updateWidth();
                this.setSize(this.getIconWidth(), this.getIconHeight());
            }
        }
    }

    protected void initSlotsOccupied() {
    }

    public int getIconHeight() {
        return this.cardPainter.getCardHeight();
    }

    public int getIconWidth() {
        return this.cardPainter.getCardWidth();
    }

    public Dimension getDimension() {
        return this.cardPainter.getMainRectangle().getSize();
    }

    public boolean hasProvisionedCard() {
        boolean bl = false;
        try {
            return this.entityM instanceof ModuleModel && this.entityM.getParent() != null;
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
            return bl;
        }
    }

    public IEntityModel getModel() {
        return this.entityM;
    }

    public IChassisModel getChassis() {
        return ((EntityModel)this.getModel()).getChassis();
    }

    public synchronized void refreshCard() {
        this.setCardColor();
        if (this.pci.is327() || this.pci.is310cl()) {
            this.initLabel();
        }
        this.repaint();
    }

    protected String getModeLabel() {
        return "";
    }

    protected void initLabel() {
        if (this.eqLabelIsSet) {
            return;
        }
        if (this.hasProvisionedCard()) {
            sMfgData_2_01 sMfgData_2_012 = ((PluggableModel)this.entityM).getMfgData();
            String string = sMfgData_2_012.name;
            if (string.equals("")) {
                return;
            }
            int n = this.getState();
            if (n == 5 || n == 4) {
                this.entityM.setEqLabel(string);
                this.eqLabelIsSet = true;
            }
        }
    }

    public String getMfgName() {
        String string = "???";
        if (this.hasProvisionedCard()) {
            sMfgData_2_01 sMfgData_2_012 = ((PluggableModel)this.entityM).getMfgData();
            string = sMfgData_2_012.name;
        }
        return string;
    }

    public String getEqLabel() {
        String string;
        block7: {
            string = "???";
            try {
                string = this.entityM.getEqLabel();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                return string;
            }
            try {
                if (this.getEqType() == 11) {
                    String string2;
                    int n = this.entityM.getSlot();
                    ArrayList arrayList = this.nodeModel.getMfgData(this.entityM.getShelfId());
                    if (n > 0 && (string2 = (String)arrayList.get(n - 1)) != null && string2.indexOf("AS") != -1) {
                        string = string + "AS";
                    }
                }
            }
            catch (Exception exception) {
                this.db.fine("Caught " + exception + " while trying to determine OC48-AS");
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public int getEqType() {
        int n;
        try {
            n = this.entityM.getEqType();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = 0;
        }
        return n;
    }

    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        String string = ElementDefaults.eqStateToString(this.eqState);
        if (this.db.on()) {
            this.db.println("stateString=" + string);
        }
        return string;
    }

    protected String getAlarmProfileString() {
        try {
            return "Alarm Profile: " + this.entityM.getAlarmProfileName();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("error retrieving alarm profile");
            }
            return "";
        }
    }

    protected String getAlarmStatusString() {
        String string = "";
        if (this.alarmStore == null) {
            if (this.db.on()) {
                this.db.println("alarm store is null");
            }
            return string;
        }
        if (this.getAlarmStatus() != null) {
            if (this.getAlarmStatus().critical() > 0) {
                string = "Critical Alarm";
            } else if (this.getAlarmStatus().major() > 0) {
                string = "Major Alarm";
            } else if (this.getAlarmStatus().minor() > 0) {
                string = "Minor Alarm";
            }
        }
        if (this.db.on()) {
            this.db.println("statusString=" + string);
        }
        return string;
    }

    protected String getExtraInfo() {
        return "";
    }

    protected static void appendString(StringBuffer stringBuffer, String string) {
        if (string != null && string.length() > 0) {
            stringBuffer.append(' ').append(string).append(',');
        }
    }

    protected IAlarmStatus getAlarmStatus() {
        if (this.alarmStatus == null && this.alarmStore != null) {
            this.alarmStatus = this.alarmStore.getAlarmStatus();
        }
        return this.alarmStatus;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        return this.getTooltipText(this.getEqLabel(), mouseEvent);
    }

    public String getTooltipText(String string, MouseEvent mouseEvent) {
        StringBuffer stringBuffer;
        block12: {
            stringBuffer = new StringBuffer("");
            boolean bl = this.getMfgName().equals("FILLER");
            try {
                stringBuffer.append(string);
                stringBuffer.append(this.getModeLabel());
                stringBuffer.append(" [");
                if (this.hasProvisionedCard()) {
                    if (this.entityM instanceof ModuleModel) {
                        stringBuffer.append(this.entityM.getSlot());
                    } else if (this.entityM instanceof PluggableModel) {
                        stringBuffer.append(((PluggableModel)this.entityM).getLocation());
                    } else {
                        stringBuffer.append(this.entityM.getPositionInParent());
                    }
                    stringBuffer.append("]: ");
                    CardGraphic.appendString(stringBuffer, this.getStateString());
                    if (this.entityM instanceof MfgEntityModel && !bl) {
                        CardGraphic.appendString(stringBuffer, ((MfgEntityModel)this.entityM).getServiceSt().toString(this.terms));
                    }
                    CardGraphic.appendString(stringBuffer, this.getAlarmStatusString());
                    CardGraphic.appendString(stringBuffer, this.getAlarmProfileString());
                    CardGraphic.appendString(stringBuffer, this.getExtraInfo());
                    if (bl) {
                        stringBuffer.append("  FILLER: Present ");
                    } else if (this.getState() == 1) {
                        stringBuffer.append("  " + this.getMfgName() + ": Present ");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                } else {
                    stringBuffer.append(this.entityM.getPositionInParent());
                    stringBuffer.append("]: ");
                    stringBuffer.append("Empty");
                }
            }
            catch (Exception exception) {
                this.db.println("Error in getToolTipText");
                if (!this.db.on) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private void setCardColor() {
        block10: {
            block9: {
                try {
                    ServiceState serviceState;
                    if (this.getEqType() == 95 && this.hasProvisionedCard()) {
                        this.currentColor = ColorBehaviour.setColor(8);
                        return;
                    }
                    if (this.entityM instanceof MfgEntityModel && (serviceState = (ServiceState)((MfgEntityModel)this.entityM).getServiceSt()).isFormOfMT() && this.hasProvisionedCard()) {
                        this.currentColor = ColorBehaviour.setColor(12);
                        return;
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block9;
                    this.db.println("Caught " + exception + " in setCardColor");
                }
            }
            int n = this.getState();
            if (!this.hasProvisionedCard() || n == -1) {
                return;
            }
            try {
                if (this.hasProvisionedCard()) {
                    this.currentColor = ColorBehaviour.setStateColor(this.currentColor, n);
                    if (n != 6) {
                        IAlarmStatus iAlarmStatus = this.getAlarmStatus();
                        this.currentColor = ColorBehaviour.setAlarmColor(iAlarmStatus, this.currentColor, n);
                    }
                }
            }
            catch (Exception exception) {
                this.db.println("Caught " + exception + " in setCardColor");
                if (!this.db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public synchronized int getState() {
        int n = -1;
        if (this.eqState == null) {
            return 0;
        }
        switch (this.eqState.value()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    private synchronized void setState() {
        block3: {
            try {
                if (this.entityM instanceof PluggableModel) {
                    this.eqState = ((PluggableModel)this.entityM).getState();
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void rightMouseClicked(Point point, CardPanel cardPanel) {
        JPopupMenu jPopupMenu = null;
        int n = this.getModel().getSlot();
        Object var5_5 = null;
        jPopupMenu = new JPopupMenu("Set Card Type");
        if (this.getModel() instanceof ModuleModel) {
            Object object;
            ModuleModel moduleModel;
            IEntityModel iEntityModel;
            block19: {
                iEntityModel = this.getModel();
                moduleModel = (ModuleModel)iEntityModel;
                boolean bl = this.nodeModel.getTdmProtocolTypeObj().isSonet();
                try {
                    if (this.entityM.getEqType() == 125) {
                        try {
                            this.createPopup(jPopupMenu, this.getMapOfAllCards((SlotModel)iEntityModel.getParent()));
                        }
                        catch (Exception exception) {
                            if (this.db.on()) {
                                SDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_BUILD_MENU);
                        }
                    } else if (!bl) {
                        String string = EntityModel.eqType2Name(this.terms, this.entityM.getEqType());
                        if (string.charAt(0) != cardPanel.getIcon().toString().charAt(0)) {
                            string = cardPanel.getIcon().toString();
                        }
                        jPopupMenu.add(new JMenuItem(string + " Card"));
                    } else {
                        jPopupMenu.add(new JMenuItem(EntityModel.eqType2Name(this.terms, this.entityM.getEqType()) + " Card"));
                    }
                    jPopupMenu.addSeparator();
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block19;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            jPopupMenu.add(this.makeMenuAction("Open Card", CardTabbedViewFactory.isCardViewAvailable((ModuleModel)iEntityModel)));
            boolean bl = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING);
            jPopupMenu.add(this.makeMenuAction("Delete Card", bl && moduleModel.isDeletable()));
            boolean bl2 = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.MAINTENANCE);
            jPopupMenu.addSeparator();
            if (CardBehavior.supportsGenericResetCard(this.pci, moduleModel.getEqType())) {
                jPopupMenu.add(this.makeMenuAction("Reset Card", bl2 && moduleModel.isResettable()));
            } else {
                jPopupMenu.add(this.makeMenuAction("Hard-reset Card", bl2 && moduleModel.isHardResettable()));
                jPopupMenu.add(this.makeMenuAction("Soft-reset Card", bl2 && moduleModel.isSoftResettable()));
            }
            if (moduleModel instanceof IosModuleModel && ((IosModuleModel)moduleModel).supportsIOS()) {
                jPopupMenu.addSeparator();
                object = moduleModel.getState();
                boolean bl3 = object == eEqState.ACTIVE || object == eEqState.STANDBY;
                jPopupMenu.add(this.makeMenuAction("Open IOS Connection...", bl3 && bl));
                jPopupMenu.add(this.makeMenuAction("IOS Startup Config...", bl));
            }
            if ((object = moduleModel.getParent()) instanceof SlotModel && ((SlotModel)object).getListOfValidChangeType(moduleModel.getEqTypeEnum()).size() > 0) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(this.makeMenuAction(CHANGE_CARD_MENU_ITEM, bl2 && this.isCardChangeAllowed()));
            }
            this.addCustomMenuItems(jPopupMenu);
        } else {
            try {
                this.createPopup(jPopupMenu, this.getMapOfAllCards((SlotModel)this.entityM));
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_BUILD_MENU);
            }
        }
        jPopupMenu.show(cardPanel, point.x, point.y);
    }

    protected boolean isCardChangeAllowed() {
        return this.cardBehavior.isCardChangeAllowed((ModuleModel)this.getModel());
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
    }

    protected JMenuItem makeMenuAction(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (bl) {
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public void openCard() {
        if (!this.isDisabled() && this.hasProvisionedCard() && CardTabbedViewFactory.isCardViewAvailable((ModuleModel)this.getModel())) {
            if (this.db.on()) {
                this.db.println("Opening card in slot " + this.slotNo);
            }
            ViewName viewName = new ViewName(new int[]{this.nodeId, this.nodeModel.isMultishelf() ? this.entityM.getChassis().getShelfId() : 0, this.slotNo});
            this.parent.getViewController().tryJumpView(viewName);
        }
    }

    protected void setDisabled(boolean bl) {
        if (this.db.on()) {
            String string = bl ? "true" : "false";
            this.db.println("setting disabled to " + string);
        }
        this.disabled = bl;
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("Called dispose");
        }
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
        }
        this.parent = null;
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver(this);
            if (this.enablePortAlarm) {
                this.alarmStore.disablePortAlarmsStatus();
            }
        }
        this.db.dispose();
    }

    public void update(Observable observable, Object object) {
        block9: {
            this.db.fine("update(" + observable + ", " + object + ")");
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
                try {
                    if (this.db.on()) {
                        this.db.println("\tReceived card change message");
                    }
                    this.eqLabelIsSet = false;
                    this.setState();
                    this.initSlotsOccupied();
                    this.refreshCard();
                }
                catch (Exception exception) {
                    this.db.fine("Caught " + exception + " in update");
                    if (this.db.on) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break block9;
                }
            }
            if (object instanceof IAlarmStatus) {
                try {
                    if (this.db.on()) {
                        this.db.println("\tReceived alarm status update");
                    }
                    this.refreshCard();
                }
                catch (Exception exception) {
                    this.db.fine("Caught " + exception + " in update");
                    if (!this.db.on) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Open Card")) {
                this.openCard();
            } else if (string.equals("Delete Card")) {
                boolean bl = this.cardBehavior.deleteCard(this.parent, (ModuleModel)this.getModel());
                this.setDisabled(bl);
            } else if (string.equals("Reset Card")) {
                this.cardBehavior.resetCard(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals("Hard-reset Card")) {
                this.cardBehavior.hardResetCard(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals("Soft-reset Card")) {
                this.cardBehavior.softResetCard(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals("Open IOS Connection...")) {
                this.cardBehavior.openIOS((ModuleModel)this.getModel());
            } else if (string.equals("IOS Startup Config...")) {
                this.cardBehavior.openIOSConfig(this.parent, (ModuleModel)this.getModel());
            } else if (string.equals(CHANGE_CARD_MENU_ITEM)) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                this.cardBehavior.addCard(this.parent, (EntityModel)this.getModel(), string);
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.cardPainter.paintIcon(component, graphics, n, n2);
    }

    protected Map getMapOfAllCards(SlotModel slotModel) throws Exception {
        Set<Object> set;
        Object object;
        Iterator<Object> iterator;
        Object object2;
        eEqType eEqType2;
        HashMap hashMap = new HashMap(slotModel.getMapOfValidModules());
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new CardComparator());
        for (Object object3 : hashMap.keySet()) {
            TreeSet<Object> treeSet;
            if (object3 instanceof eEqType) {
                eEqType2 = (eEqType)object3;
                treeMap.put(EntityModel.eqType2Name(this.terms, eEqType2), null);
                continue;
            }
            eEqType2 = hashMap.get(object3);
            if (eEqType2 instanceof HashMap) {
                object2 = (Map)((Object)eEqType2);
                iterator = object2.keySet().iterator();
                while (iterator.hasNext()) {
                    eEqType eEqType3;
                    treeSet = null;
                    object = iterator.next();
                    if (object instanceof eEqType) {
                        set = (eEqType)object;
                        treeMap.put(EntityModel.eqType2Name(this.terms, (eEqType)((Object)set)), null);
                        continue;
                    }
                    if (object2.get(object) instanceof Set) {
                        set = (Set)object2.get(object);
                        treeSet = new TreeSet(new CardComparator());
                        for (Object k : set) {
                            if (k instanceof eEqType) {
                                eEqType3 = (eEqType)k;
                                treeSet.add(EntityModel.eqType2Name(this.terms, eEqType3));
                                continue;
                            }
                            treeSet.add(k);
                        }
                        object2.put(object, treeSet);
                        treeMap.put((String)object3, object2);
                        continue;
                    }
                    if (!(object2.get(object) instanceof HashMap)) continue;
                    set = ((HashMap)object2.get(object)).keySet();
                    treeSet = new TreeSet<Object>(new BandComparator());
                    for (Object k : set) {
                        if (k instanceof eEqType) {
                            eEqType3 = (eEqType)k;
                            treeSet.add(EntityModel.eqType2Name(this.terms, eEqType3));
                            continue;
                        }
                        eEqType3 = ((HashMap)object2.get(object)).get(k);
                        HashMap hashMap2 = new HashMap();
                        hashMap2.put(k, eEqType3);
                        treeSet.add(hashMap2);
                    }
                    object2.put(object, treeSet);
                    treeMap.put((String)object3, object2);
                }
                continue;
            }
            object2 = (Set)hashMap.get(object3);
            iterator = new TreeSet(new CardComparator());
            treeSet = object2.iterator();
            while (treeSet.hasNext()) {
                object = treeSet.next();
                set = (eEqType)object;
                iterator.add(EntityModel.eqType2Name(this.terms, (eEqType)((Object)set)));
            }
            treeMap.put((String)object3, iterator);
        }
        if (this.db.on()) {
            this.db.println("getMapOfAllCards( " + slotModel.getSlot() + " )");
            for (Object object3 : treeMap.keySet()) {
                eEqType2 = treeMap.get(object3);
                if (eEqType2 != null) {
                    if (eEqType2 instanceof HashMap) {
                        object2 = (Map)((Object)eEqType2);
                        for (TreeSet<Object> treeSet : object2.keySet()) {
                            if (treeSet instanceof String) {
                                object = (String)((Object)treeSet);
                                set = hashMap.get(object);
                                this.db.print(object + " ->");
                                this.db.print(" " + set);
                                continue;
                            }
                            this.db.print(treeSet + " ->");
                            this.db.print(" " + treeSet);
                        }
                        continue;
                    }
                    object2 = (Set)((Object)eEqType2);
                    this.db.print(object3 + " ->");
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        this.db.print(" " + iterator.next());
                    }
                    this.db.println("");
                    continue;
                }
                this.db.println((String)object3);
            }
        }
        return treeMap;
    }

    protected void initialize() {
        block7: {
            if (this.entityM != null) {
                this.entityM.addObserver(this);
                this.setState();
                this.slotNo = this.entityM.getSlot();
                this.nodeId = this.entityM.getNodeModelDelegate().getNodeId();
                this.initSlotsOccupied();
            } else {
                this.slotNo = 0;
                this.nodeId = 0;
            }
            if (this.hasProvisionedCard()) {
                ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
                this.alarmStore = (ElementAlarmStore)elementAlarmStore.getCardAlarmStore(this.entityM.getShelfId(), this.slotNo);
                this.alarmStore.addAlarmStatusObserver(this);
                if (this.enablePortAlarm) {
                    this.alarmStore.enablePortAlarmsStatus(this.entityM.getModuleModel());
                }
            } else {
                this.alarmStore = null;
            }
            this.cardPainter = this.getCardPainter();
            this.setSize(this.getIconWidth(), this.getIconHeight());
            try {
                this.refreshCard();
            }
            catch (Exception exception) {
                this.db.println("Caught " + exception + " when refreshing card in initialize()");
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void resetLabel(eEqState eEqState2) {
    }

    protected void createPopup(JPopupMenu jPopupMenu, Map map) {
        jPopupMenu.add(new NonSelectableMI("Add Card"));
        jPopupMenu.addSeparator();
        boolean bl = AbstractPane.isUserAuthorized((IModel)this.getModel(), SecurityLevel.PROVISIONING);
        for (String string : map.keySet()) {
            Object object;
            JMenu jMenu;
            Object v = map.get(string);
            if (v instanceof HashMap) {
                jMenu = new JMenu(string);
                object = (Map)v;
                this.buildSubmenu(jMenu, (Map)object, bl);
                jPopupMenu.add(jMenu);
                continue;
            }
            if (v instanceof Set) {
                jMenu = new JMenu(string);
                object = (Set)map.get(string);
                this.buildSubmenu(jMenu, (Set)object, bl);
                jPopupMenu.add(jMenu);
                continue;
            }
            jPopupMenu.add(this.makeMenuAction(string, bl));
        }
    }

    private void buildSubmenu(JMenu jMenu, Map map, boolean bl) {
        for (String string : map.keySet()) {
            Object object;
            JMenu jMenu2 = new JMenu(string);
            Object v = map.get(string);
            if (v instanceof Set) {
                object = (Set)v;
                this.buildSubmenu(jMenu2, (Set)object, bl);
            } else if (v instanceof HashMap) {
                object = (HashMap)v;
                this.buildSubmenu(jMenu2, (HashMap)object, bl);
            }
            jMenu.add(jMenu2);
        }
    }

    private void buildSubmenu(JMenu jMenu, Set set, boolean bl) {
        for (Object e : set) {
            String string = "";
            if (e instanceof eEqType) {
                eEqType eEqType2 = (eEqType)e;
                string = EntityModel.eqType2Name(this.terms, eEqType2);
                jMenu.add(this.makeMenuAction(string, bl));
                continue;
            }
            if (e instanceof HashMap) {
                this.buildSubmenu(jMenu, (HashMap)e, bl);
                continue;
            }
            string = (String)e;
            jMenu.add(this.makeMenuAction(string, bl));
        }
    }

    private void buildSubmenu(JMenu jMenu, HashMap hashMap, boolean bl) {
        for (Object k : hashMap.keySet()) {
            Object v = hashMap.get(k);
            JMenu jMenu2 = new JMenu((String)k);
            if (v instanceof String) {
                jMenu2.add(this.makeMenuAction((String)v, bl));
            } else if (v instanceof Set) {
                this.buildSubmenu(jMenu2, (Set)v, bl);
            } else if (v instanceof HashMap) {
                this.buildSubmenu(jMenu2, (HashMap)v, bl);
            }
            jMenu.add(jMenu2);
        }
    }

    public ElementAlarmStore getCardAlarmStore() {
        return this.alarmStore;
    }

    private class BandComparator
    implements Comparator {
        private String key = "";

        private BandComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof HashMap) {
                if (object2 instanceof HashMap) {
                    String string = ((HashMap)object).keySet().toArray()[0].toString();
                    String string2 = ((HashMap)object2).keySet().toArray()[0].toString();
                    return string.compareTo(string2);
                }
                return -1;
            }
            return 1;
        }

        public boolean equals(Object object) {
            if (object instanceof HashMap) {
                String string = ((HashMap)object).keySet().toArray()[0].toString();
                return this.key.equals(string);
            }
            return false;
        }
    }

    private class CardComparator
    implements Comparator {
        private CardComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    if (string.startsWith("OC") && string2.startsWith("OC")) {
                        if (string.indexOf("_") != -1) {
                            string = string.replace('_', '.');
                        }
                        if (string2.indexOf("_") != -1) {
                            string2 = string2.replace('_', '.');
                        }
                        try {
                            Float f = new Float(string.substring(2));
                            Float f2 = new Float(string2.substring(2));
                            return f.compareTo(f2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return string.compareTo(string2);
                        }
                    }
                    return string.compareTo(string2);
                }
                return -1;
            }
            return 1;
        }
    }

    private class NonSelectableMI
    extends JMenuItem {
        public NonSelectableMI(String string) {
            super(string);
        }

        public void menuSelectionChanged(boolean bl) {
        }
    }
}

