/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.FcmrPortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public class FcmrCard
extends CardGraphic {
    private static final int LINE_RATE_ONLY = 0;
    private static final int DISTANCE_EXTENSION = 1;
    protected FcmrPortGraphic[] portGraphics = null;

    public FcmrCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "FC_MR:" + entityModel.getSlot()), true);
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            this.portGraphics = new FcmrPortGraphic[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.portGraphics[i] = new FcmrPortGraphic(this, this.cardPainter.getMultiPortOpticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getOpticonYOffset() + this.cardPainter.getOpticonYSpacing() * i, (PortModel)list.get(i));
            }
        }
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    protected String getModeLabel() {
        String string = "";
        Attribute attribute = ElementDefaults.getAttributeForCardOperMode((ModuleModel)this.entityM, "FcmrCardMode");
        string = "(" + attribute.getKey() + ")";
        return string;
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus) {
            List list = this.entityM.getChildren();
            for (int i = 0; i < this.portGraphics.length; ++i) {
                PortModel portModel = (PortModel)list.get(i);
                IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus == null) continue;
                if (this.db.on()) {
                    int n = this.entityM.getSlot();
                    this.db.println("SlotNo=" + n + ", PortNo=" + portModel.getPort() + ", portEqType=" + portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                }
                this.portGraphics[i].setAlarmState(iAlarmStatus.getHighestSeverity());
            }
        }
    }

    public void dispose() {
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].dispose();
            this.portGraphics[i] = null;
        }
        this.portGraphics = null;
        super.dispose();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].draw(graphics2D);
        }
    }
}

