/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.MaintTabPwrMonitoringPane;
import cerent.cms.ui.shelf.OchsPwrMonitoringChartModel;
import cerent.cms.ui.shelf.XAssisChartElements;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import cerent.util.gui.BarChart;
import com.klg.jclass.chart.ChartDataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;

public class MaintPwrMonitoringPane
extends AbstractPane
implements ActionListener,
ITabName {
    private static final String REFRESH = "Refresh";
    public static final int MAX_SPLIT_PANEL = 2;
    private JButton refreshButton = new JButton("Refresh");
    private JLabel refreshLabel = new JLabel("");
    private boolean isGUIInited = false;
    private boolean isModelInited = false;
    protected boolean isMultiShelf = ((NodeModelDelegate)this.getUiModel().getNodeModel()).isMultishelf();
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "MaintPwrMonitoringPane");
    public static final int DONTCARESIDE = 255;
    protected int side;
    private JSplitPane splitPane;
    private BarChart[] chart = null;
    private ChartDataCard[] chartDataCard = null;
    private JPanel[] chartPane = null;
    protected FillerCard[] cards = null;
    protected int evenOdd;
    private boolean IS_FIRST_CHART_3D = false;
    private boolean IS_SECOND_CHART_3D = false;

    public MaintPwrMonitoringPane(String string, TabbedView tabbedView, int n) {
        this(string, tabbedView.getUiModel(), tabbedView);
        this.chartDataCard = new ChartDataCard[2];
        this.chartPane = new JPanel[2];
        this.chart = new BarChart[2];
        for (int i = 0; i < 2; ++i) {
            this.chartPane[i] = new JPanel(new BorderLayout());
        }
        this.side = n;
        this.evenOdd = 0;
    }

    public MaintPwrMonitoringPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
    }

    private void initGUI() {
        if (db.on()) {
            db.println("initGUI()");
        }
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.initButtonPanel();
        this.initChartsPanel();
        this.initCharts();
        this.isGUIInited = true;
    }

    protected void initButtonPanel() {
        if (db.on()) {
            db.println("initButtonPanel()");
        }
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintDwdmPwrMonitoring);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addRight(this.refreshLabel);
        this.add(cSHelpButtonPane, "South");
    }

    protected void initModel() {
        if (db.on()) {
            db.println("initModel()");
        }
        int n = 0;
        this.cards = new FillerCard[2];
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (MaintTabPwrMonitoringPane.isPwrMonitoringSupported(nodeModelDelegate)) {
            int n2;
            Object object;
            if (this.getUiModel() instanceof IChassisModel) {
                n += this.fillCardItems((EntityModel)this.getUiModel(), n);
            } else if (this.getUiModel() instanceof NodeModelDelegate) {
                object = nodeModelDelegate.getChassisModels();
                for (n2 = 0; n2 < ((IEntityModel[])object).length && n < 2; ++n2) {
                    n = this.fillCardItems((EntityModel)object[n2], n);
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (this.cards[n2] == null && n == 1) {
                    n2 = 1;
                }
                if (this.cards[n2] == null) continue;
                object = new OchsPwrMonitoringChartModel(nodeModelDelegate.getOchsPwrMonitoringModel(), this.cards[n2].getIdx(), this.cards[n2].getBand(), XAssisChartElements.factoryCreate(this.cards[n2].getCardType(), this.evenOdd));
                try {
                    ((OchsPwrMonitoringChartModel)((Object)object)).init();
                    this.prepareChartData((OchsPwrMonitoringChartModel)((Object)object), n2);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    if (!db.on()) continue;
                    db.println("CTCUserException initializing chart for " + this.cards[n2].getIdx() + " :" + (Object)((Object)cTCUserException));
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Exception initializing chart for " + this.cards[n2].getIdx() + " :" + exception);
                }
            }
            this.isModelInited = true;
        } else if (db.on()) {
            db.println("initModel: model NOT inited");
        }
        if (!this.isGUIInited) {
            this.initGUI();
        } else {
            this.initCharts();
        }
    }

    private void prepareChartData(OchsPwrMonitoringChartModel ochsPwrMonitoringChartModel, int n) {
        int n2 = ochsPwrMonitoringChartModel.getSide();
        int n3 = n2 % 2;
        if (this.chartDataCard[n3] != null) {
            for (int i = 0; i < 2; ++i) {
                if (this.chartDataCard[i] != null) continue;
                n3 = i;
            }
        }
        this.chartDataCard[n3] = new ChartDataCard();
        this.chartDataCard[n3].setChartDataModel(ochsPwrMonitoringChartModel);
        this.chartDataCard[n3].setCardType(this.cards[n].getCardType());
        this.chartDataCard[n3].setCardSlot(this.cards[n].getSlot());
        if (this.isMultiShelf) {
            this.chartDataCard[n3].setCardShelf(this.cards[n].getShelf());
        }
        if (db.on()) {
            db.println("initModel: model succesfully inited for side " + n2);
        }
    }

    protected int fillCardItems(EntityModel entityModel, int n) {
        int n2 = 0;
        int n3 = 0;
        List list = this.getCardList(entityModel);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IModuleModel iModuleModel;
            block4: {
                n2 = 0;
                iModuleModel = (IModuleModel)iterator.next();
                try {
                    if (!(iModuleModel instanceof OpticsModuleModel)) break block4;
                    n2 = ((OpticsModuleModel)iModuleModel).getSide();
                }
                catch (ClassCastException classCastException) {
                    if (!db.on()) continue;
                    KDebug.printStackTrace((Throwable)classCastException);
                    continue;
                }
            }
            if (n2 != this.side && n2 != this.side + 1 && this.side != 255) continue;
            int n4 = this.side == 255 ? (n == 0 ? 1 : 0) : (n3 = n2 % 2);
            if (n < 2) {
                n += this.endFill(n3, iModuleModel);
                continue;
            }
            db.warning("Too many 32WSS cards in the node!");
            break;
        }
        return n;
    }

    protected int endFill(int n, IModuleModel iModuleModel) {
        if (this.wxcAlreadyPresent(n)) {
            return 0;
        }
        this.cards[n] = new FillerCard();
        this.cards[n].setIdx(iModuleModel.getEntityIndex());
        this.cards[n].setSlot(iModuleModel.getSlot());
        if (this.isMultiShelf) {
            this.cards[n].setShelf(iModuleModel.getShelfId());
        }
        db.fine("Found WSS slot: " + iModuleModel.getSlot() + " tIndex: " + this.cards[n].getIdx());
        int n2 = iModuleModel.getEqType();
        this.cards[n].setCardType(n2);
        switch (n2) {
            case 191: 
            case 263: 
            case 266: 
            case 294: 
            case 295: 
            case 296: {
                this.cards[n].setBand(0);
                break;
            }
            case 242: 
            case 267: 
            case 270: {
                this.cards[n].setBand(1);
                break;
            }
            default: {
                if (!db.on()) break;
                db.println("Unknown Band");
            }
        }
        return 1;
    }

    protected boolean wxcAlreadyPresent(int n) {
        if (this.cards[n] != null) {
            switch (this.cards[n].getCardType()) {
                case 191: 
                case 242: 
                case 263: 
                case 267: 
                case 294: 
                case 296: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static List getCardPwrMonitor(IModel iModel) {
        List list = null;
        list = ((EntityModel)iModel).getDescendantsOfEqType(191);
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(242));
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(263));
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(267));
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(294));
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(296));
        return MaintPwrMonitoringPane.filterOutNonDeletedCard(list);
    }

    public static List getWssE(IModel iModel) {
        List list = null;
        ArrayList<OpticsModuleModel> arrayList = new ArrayList<OpticsModuleModel>();
        list = ((EntityModel)iModel).getDescendantsOfEqType(267);
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(263));
        for (int i = 0; i < list.size(); ++i) {
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)list.get(i);
            if (!opticsModuleModel.isEvenWavelengthCard()) continue;
            arrayList.add(opticsModuleModel);
        }
        return MaintPwrMonitoringPane.filterOutNonDeletedCard(arrayList);
    }

    public static List getSMR2(IModel iModel) {
        List list = null;
        list = ((EntityModel)iModel).getDescendantsOfEqType(295);
        return MaintPwrMonitoringPane.filterOutNonDeletedCard(list);
    }

    public static List getWxc(IModel iModel) {
        List list = null;
        list = ((EntityModel)iModel).getDescendantsOfEqType(266);
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(270));
        list.addAll(((EntityModel)iModel).getDescendantsOfEqType(297));
        return MaintPwrMonitoringPane.filterOutNonDeletedCard(list);
    }

    private static List filterOutNonDeletedCard(List list) {
        ArrayList<OpticsModuleModel> arrayList = new ArrayList<OpticsModuleModel>();
        for (int i = 0; i < list.size(); ++i) {
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)list.get(i);
            if (opticsModuleModel.getState() != eEqState.DELETED) {
                arrayList.add(opticsModuleModel);
                continue;
            }
            if (!db.on()) continue;
            db.println("Deleted card found: " + opticsModuleModel.toString());
        }
        return arrayList;
    }

    protected List getCardList(EntityModel entityModel) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(MaintPwrMonitoringPane.getSMR2(entityModel));
        if (arrayList.size() == 0) {
            arrayList.addAll(MaintPwrMonitoringPane.getWxc(entityModel));
        }
        if (arrayList.size() == 0) {
            arrayList.addAll(MaintPwrMonitoringPane.getCardPwrMonitor(entityModel));
        }
        return arrayList;
    }

    private void initChartsPanel() {
        if (db.on()) {
            db.println("initChartsPanel: create the GUI containers");
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.chartPane[1], this.chartPane[0]);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        jPanel.add((Component)this.splitPane, "Center");
        this.add(jPanel, "Center");
        if (this.chartDataCard[0] != null && this.chartDataCard[1] != null) {
            this.splitPane.setResizeWeight(0.5);
            this.splitPane.setDividerLocation(0.5);
        }
    }

    private void initCharts() {
        if (this.isModelInited) {
            if (db.on()) {
                db.println("initCharts: model inited, draw charts");
            }
            for (int i = 0; i < 2; ++i) {
                if (this.chartDataCard[i] == null) continue;
                this.chart[i] = this.setUpChart(this.chartDataCard[i], i);
                this.chartPane[i].add((Component)this.chart[i].getComponentObj(), "Center");
                if (!db.on()) continue;
                db.println("initCharts: added SIDE" + i + " chart to pane");
            }
            if (this.chart[0] != null) {
                this.chart[0].set3D(this.IS_FIRST_CHART_3D);
            }
            if (this.chart[1] != null) {
                this.chart[1].set3D(this.IS_SECOND_CHART_3D);
            }
            if (this.chartDataCard[0] == null) {
                this.splitPane.setResizeWeight(1.0);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private BarChart setUpChart(ChartDataCard chartDataCard, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        BarChart barChart = new BarChart(BarChart.BarStyle.STACKED, true);
        barChart.setDataSource((ChartDataModel)chartDataCard.getChartDataModel());
        barChart.setYStepUnit(new Double(1.0), new Double(1.0));
        stringBuilder.append("Optical Side");
        stringBuilder.append(" ");
        stringBuilder.append(chartDataCard.getChartDataModel().getSideStr());
        stringBuilder.append(": ");
        if (this.isMultiShelf) {
            stringBuilder.append("shelf ");
            stringBuilder.append(chartDataCard.getCardShelf());
            stringBuilder.append(" - ");
        }
        stringBuilder.append("slot ");
        stringBuilder.append(chartDataCard.getCardSlot());
        stringBuilder.append(" (");
        stringBuilder.append(EntityModel.eqType2Name((TDMTerminology)SONETTDMTerminology.instance(), chartDataCard.getCardType()));
        stringBuilder.append(")");
        barChart.setAutoLabel(true);
        barChart.setBarOverlap(100);
        barChart.setGridVisible(true);
        barChart.setYaxisTitle("dBm");
        barChart.setXaxisTitle("Channel ID");
        barChart.setOrigin(-25.0);
        barChart.setMin(-25.0);
        barChart.setHeader(stringBuilder.toString());
        Color color = new Color(187, 187, 240);
        barChart.setBackground(color);
        barChart.setLegendAnchor(7);
        barChart.setLegendOrientation(8);
        barChart.setLegendVisible(true);
        barChart.setAutoLabelTexts(" dBm", (Object[])this.getWavelengthAttributes(chartDataCard.getCardType()));
        return barChart;
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage()");
        }
        ToolTipManager.sharedInstance().setDismissDelay(2000);
        if (!this.isModelInited) {
            if (db.on()) {
                db.println("enteringPage: call initModel()");
            }
            this.initModel();
        } else {
            this.refreshModel();
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage()");
        }
        ToolTipManager.sharedInstance().setDismissDelay(4000);
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh()");
        }
        try {
            if (!this.isModelInited) {
                if (db.on()) {
                    db.println("refresh: call initModel(), initCharts()");
                }
                this.initModel();
                this.initCharts();
                this.validate();
            } else {
                this.refreshModel();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PWR_MONIT);
        }
        this.refreshLabel.setText(this.getTimeStampString());
    }

    protected String getTimeStampString() {
        return "Refreshed: " + MaintPwrMonitoringPane.getFormattedDateTime();
    }

    public void destroy() {
        super.destroy();
        if (db.on()) {
            db.println("destroy()");
        }
        if (this.isModelInited) {
            if (db.on()) {
                db.println("destroy: disposing chart models");
            }
            this.chartDataCard = null;
        }
    }

    public static boolean hasWxc(IModel iModel) {
        int n = 0;
        if (iModel instanceof IChassisModel) {
            n = MaintPwrMonitoringPane.getWxc((EntityModel)iModel).size();
        } else if (iModel instanceof NodeModelDelegate) {
            IEntityModel[] iEntityModelArray = ((NodeModelDelegate)iModel).getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                n += MaintPwrMonitoringPane.getWxc((EntityModel)iEntityModelArray[i]).size();
            }
        }
        return n >= 1;
    }

    public static boolean hasSMR2(IModel iModel) {
        int n = 0;
        if (iModel instanceof IChassisModel) {
            n = MaintPwrMonitoringPane.getSMR2((EntityModel)iModel).size();
        } else if (iModel instanceof NodeModelDelegate) {
            IEntityModel[] iEntityModelArray = ((NodeModelDelegate)iModel).getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                n += MaintPwrMonitoringPane.getSMR2((EntityModel)iEntityModelArray[i]).size();
            }
        }
        return n >= 1;
    }

    public static int getROADMCount(IModel iModel) {
        int n = 0;
        if (iModel instanceof IChassisModel) {
            n = MaintPwrMonitoringPane.getCardPwrMonitor((EntityModel)iModel).size();
        } else if (iModel instanceof NodeModelDelegate) {
            IEntityModel[] iEntityModelArray = ((NodeModelDelegate)iModel).getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                n += MaintPwrMonitoringPane.getCardPwrMonitor((EntityModel)iEntityModelArray[i]).size();
            }
        }
        return n;
    }

    public static boolean hasWssE(IModel iModel) {
        int n = 0;
        if (iModel instanceof IChassisModel) {
            n = MaintPwrMonitoringPane.getWssE((EntityModel)iModel).size();
        } else if (iModel instanceof NodeModelDelegate) {
            IEntityModel[] iEntityModelArray = ((NodeModelDelegate)iModel).getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                n += MaintPwrMonitoringPane.getWssE((EntityModel)iEntityModelArray[i]).size();
            }
        }
        return n >= 1;
    }

    protected Attribute[] getWavelengthAttributes(int n) {
        switch (n) {
            case 191: {
                return Wavelength.getOchncCWavelengthAttrs(32);
            }
            case 263: 
            case 266: 
            case 294: 
            case 295: {
                return Wavelength.getOchncCWavelengthAttrs(40);
            }
            case 242: {
                return Wavelength.getOchncLWavelengthAttrs(32);
            }
            case 267: 
            case 270: {
                return Wavelength.getOchncLWavelengthAttrs(40);
            }
        }
        return new Attribute[0];
    }

    private void refreshModel() {
        if (this.chart[0] != null) {
            this.IS_FIRST_CHART_3D = this.chart[0].is3D();
        }
        if (this.chart[1] != null) {
            this.IS_SECOND_CHART_3D = this.chart[1].is3D();
        }
        for (int i = 0; i < 2; ++i) {
            this.chartPane[i].removeAll();
            this.chartDataCard[i] = null;
            this.chart[i] = null;
        }
        this.cards = null;
        this.initModel();
        this.validate();
    }

    private class ChartDataCard {
        private OchsPwrMonitoringChartModel chartDataModel;
        private int cardShelf;
        private int cardSlot;
        private int cardType;

        private ChartDataCard() {
        }

        public int getCardType() {
            return this.cardType;
        }

        public void setCardType(int n) {
            this.cardType = n;
        }

        public final int getCardShelf() {
            return this.cardShelf;
        }

        public final int getCardSlot() {
            return this.cardSlot;
        }

        public final OchsPwrMonitoringChartModel getChartDataModel() {
            return this.chartDataModel;
        }

        public final void setChartDataModel(OchsPwrMonitoringChartModel ochsPwrMonitoringChartModel) {
            this.chartDataModel = ochsPwrMonitoringChartModel;
        }

        public final void setCardShelf(int n) {
            this.cardShelf = n;
        }

        public final void setCardSlot(int n) {
            this.cardSlot = n;
        }

        public String toString() {
            return "shelf=" + this.cardShelf + ",slot=" + this.cardSlot + ",type=" + this.cardType;
        }
    }

    protected class FillerCard {
        private int idx;
        private int shelf;
        private int slot;
        private int band;
        private int cardType;

        protected FillerCard() {
        }

        public final int getBand() {
            return this.band;
        }

        public final void setBand(int n) {
            this.band = n;
        }

        public final int getCardType() {
            return this.cardType;
        }

        public final void setCardType(int n) {
            this.cardType = n;
        }

        public final int getIdx() {
            return this.idx;
        }

        public final void setIdx(int n) {
            this.idx = n;
        }

        public final int getShelf() {
            return this.shelf;
        }

        public final void setShelf(int n) {
            this.shelf = n;
        }

        public final int getSlot() {
            return this.slot;
        }

        public final void setSlot(int n) {
            this.slot = n;
        }

        public String toString() {
            return "idx=" + this.idx + ",shelf=" + this.shelf + ",slot=" + this.slot + ",type=" + this.cardType + ",band=" + this.band;
        }
    }
}

