/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.OhXConnectionPane;
import cerent.cms.ui.shelf.OhXConnectionRowObject;
import cerent.util.ComparisonUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class OhXConColumnRenderer
extends AbstractColumnRenderer {
    private static final int SLOT_A = 0;
    private static final int PORT_A = 1;
    private static final int TYPE_A = 2;
    private static final int SLOT_B = 3;
    private static final int PORT_B = 4;
    private static final int TYPE_B = 5;
    private static final int CIRCUIT_NAME = 6;
    private static final int CIRCUIT_TYPE = 7;
    private static final String[] columnNames = new String[]{"Slot A", "Port A", "Type A", "Slot B", "Port B", "Type B", "Circuit Name", "Circuit Type"};
    private static final int numColumns = columnNames.length;
    private static final int[] columnWidths = new int[]{45, 45, 100, 45, 45, 100, 140, 130};
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 2);
    private JLabel label;
    private int mode;
    private static final SDebug db = new SDebug((KDebug)OhXConnectionPane.db, "OhXConColumnRenderer");

    public OhXConColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.label.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
        this.label.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
        OhXConnectionRowObject ohXConnectionRowObject = (OhXConnectionRowObject)object;
        if (ohXConnectionRowObject == null) {
            this.label.setText("<null info>");
            return this.label;
        }
        String string = "";
        try {
            switch (this.mode) {
                case 0: {
                    string = new Integer(ohXConnectionRowObject.getInputSlot()).toString();
                    break;
                }
                case 1: {
                    string = PortHelper.getConcatenatedString((int[])ohXConnectionRowObject.getInputPortNum());
                    break;
                }
                case 2: {
                    string = ohXConnectionRowObject.getInputChannelType();
                    break;
                }
                case 3: {
                    string = new Integer(ohXConnectionRowObject.getOutputSlot()).toString();
                    break;
                }
                case 4: {
                    string = PortHelper.getConcatenatedString((int[])ohXConnectionRowObject.getOutputPortNum());
                    break;
                }
                case 5: {
                    string = ohXConnectionRowObject.getOutputChannelType();
                    break;
                }
                case 6: {
                    string = ohXConnectionRowObject.getName();
                    break;
                }
                case 7: {
                    string = ohXConnectionRowObject.getCircuitType();
                    break;
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.warning("Caught exception in OhXConColumnRenderer.getTableCellRendererComponent()");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        this.label.setText(string);
        return this.label;
    }

    public static ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnRendererArray[i] = new OhXConColumnRenderer(i, columnNames[i], columnWidths[i], true, 2);
        }
        return columnRendererArray;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        OhXConnectionRowObject ohXConnectionRowObject = (OhXConnectionRowObject)object;
        OhXConnectionRowObject ohXConnectionRowObject2 = (OhXConnectionRowObject)object2;
        try {
            switch (n) {
                case 0: {
                    n2 = ohXConnectionRowObject.getInputSlot() - ohXConnectionRowObject2.getInputSlot();
                    break;
                }
                case 1: {
                    n2 = ComparisonUtil.compare((int[])ohXConnectionRowObject.getInputPortNum(), (int[])ohXConnectionRowObject2.getInputPortNum());
                    break;
                }
                case 2: {
                    n2 = ohXConnectionRowObject.getInputChannelType().compareTo(ohXConnectionRowObject2.getInputChannelType());
                    break;
                }
                case 3: {
                    n2 = ohXConnectionRowObject.getOutputSlot() - ohXConnectionRowObject2.getOutputSlot();
                    break;
                }
                case 4: {
                    n2 = ComparisonUtil.compare((int[])ohXConnectionRowObject.getOutputPortNum(), (int[])ohXConnectionRowObject2.getOutputPortNum());
                    break;
                }
                case 5: {
                    n2 = ohXConnectionRowObject.getOutputChannelType().compareTo(ohXConnectionRowObject2.getOutputChannelType());
                    break;
                }
                case 6: {
                    n2 = ohXConnectionRowObject.getName().compareTo(ohXConnectionRowObject2.getName());
                    break;
                }
                case 7: {
                    n2 = ohXConnectionRowObject.getCircuitType().compareTo(ohXConnectionRowObject2.getCircuitType());
                    break;
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.warning("Caught exception in OhXConColumnRenderer.compareColumn()");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        return n2;
    }
}

