/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpDataLinkModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.shelf.lmp.DataLinkPane;
import cerent.cms.ui.shelf.lmp.crs.DlCheckOchPortCmd;
import cerent.cms.ui.shelf.lmp.crs.DlCheckPlimCmd;
import cerent.cms.ui.shelf.lmp.crs.DlCheckPrivilegesCmd;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.cms.ui.shelf.lmp.crs.DlCommandGroup;
import cerent.cms.ui.shelf.lmp.crs.DlCreateCmd;
import cerent.cms.ui.shelf.lmp.crs.DlDeleteCmd;
import cerent.cms.ui.shelf.lmp.crs.DlEditCmd;
import cerent.cms.ui.shelf.lmp.crs.ICrsLmpCallback;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.Pair;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrsDataLinkManager {
    DataLinkPane pane;
    INodeHelper nodeHelper;
    SDebug db;
    NodeModelDelegate node;
    LmpTeLinkModels teModels;
    private ICrsLmpCallback cb;

    public CrsDataLinkManager(DataLinkPane dataLinkPane, NodeModelDelegate nodeModelDelegate, INodeHelper iNodeHelper, ICrsLmpCallback iCrsLmpCallback, SDebug sDebug) {
        this.cb = iCrsLmpCallback;
        this.pane = dataLinkPane;
        this.node = nodeModelDelegate;
        this.nodeHelper = iNodeHelper;
        this.db = sDebug;
        this.teModels = nodeModelDelegate.getLmpTeLinkModels();
    }

    public void create(String string, sDataLinkAttrsEx sDataLinkAttrsEx2) {
        ArrayList<DlCommand> arrayList = new ArrayList<DlCommand>();
        arrayList.add(new DlCheckOchPortCmd(this, sDataLinkAttrsEx2.tIndex));
        if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) == 0) {
            arrayList.add(new DlCheckPrivilegesCmd(this, string));
            arrayList.add(new DlCheckPlimCmd(this, string, sDataLinkAttrsEx2.remote_crsPort, false));
            arrayList.add(new DlCreateCmd(this, string, sDataLinkAttrsEx2, true, true));
        } else {
            arrayList.add(new DlCreateCmd(this, string, sDataLinkAttrsEx2, true, false));
        }
        ArrayList<DlCommand> arrayList2 = new ArrayList<DlCommand>(1);
        arrayList2.add(new DlCommandGroup(this, arrayList));
        new Thread(new Invoker(arrayList2, "Creating data link...")).start();
    }

    public void edit(String string, LmpDataLinkModel lmpDataLinkModel, String string2, sDataLinkAttrsEx sDataLinkAttrsEx2) {
        Object object;
        ArrayList<DlCommand> arrayList = new ArrayList<DlCommand>();
        arrayList.add(new DlCheckOchPortCmd(this, sDataLinkAttrsEx2.tIndex));
        if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) == 0) {
            arrayList.add(new DlCheckPrivilegesCmd(this, string));
            if (!string2.equals(string)) {
                arrayList.add(new DlCheckPrivilegesCmd(this, string2));
            }
            arrayList.add(new DlCheckPlimCmd(this, string2, sDataLinkAttrsEx2.remote_crsPort, false));
            try {
                object = new sDataLinkAttrsEx(lmpDataLinkModel.getType(), lmpDataLinkModel.getLocalTeLinkId(), lmpDataLinkModel.getLocalPortId(), lmpDataLinkModel.getRemoteDataLinkId(), lmpDataLinkModel.isRemoteCrs(), lmpDataLinkModel.getRemoteCrsPortId());
                arrayList.add(new DlCheckPlimCmd(this, string2, lmpDataLinkModel.getRemoteCrsPortId(), true));
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(object);
                arrayList.add(new DlDeleteCmd(this, lmpDataLinkModel.getLocalDataLinkId(), (sDataLinkAttrsEx)object, false, true));
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)lmpException.getEid());
                return;
            }
            arrayList.add(new DlCreateCmd(this, string2, sDataLinkAttrsEx2, false, true));
        }
        arrayList.add(new DlEditCmd(this, lmpDataLinkModel, sDataLinkAttrsEx2, string2));
        object = new ArrayList<DlCommand>(1);
        object.add(new DlCommandGroup(this, arrayList));
        new Thread(new Invoker((List<DlCommand>)object, "Editing data link...")).start();
    }

    public void delete(List<Pair<Integer, sDataLinkAttrsEx>> list) {
        ArrayList<DlCommand> arrayList = new ArrayList<DlCommand>();
        for (Pair<Integer, sDataLinkAttrsEx> pair : list) {
            String string;
            try {
                string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(this.node.getLmpTeLinkModels().getTeLink(((sDataLinkAttrsEx)pair.getSecond()).te_link_id).getRemoteNodeId()));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.LMP_INVALID_TE_LINK_INDEX);
                return;
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)lmpException.getEid());
                return;
            }
            ArrayList<DlCommand> arrayList2 = new ArrayList<DlCommand>(2);
            if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) == 0) {
                arrayList2.add(new DlCheckPrivilegesCmd(this, string));
                arrayList2.add(new DlCheckPlimCmd(this, string, ((sDataLinkAttrsEx)pair.getSecond()).remote_crsPort, true));
                arrayList2.add(new DlDeleteCmd(this, (Integer)pair.getFirst(), (sDataLinkAttrsEx)pair.getSecond(), true, true));
            } else {
                arrayList2.add(new DlDeleteCmd(this, (Integer)pair.getFirst(), (sDataLinkAttrsEx)pair.getSecond(), true, false));
            }
            arrayList.add(new DlCommandGroup(this, arrayList2));
        }
        new Thread(new Invoker(arrayList, "Deleting data links...")).start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invoker
    implements Runnable {
        private List<DlCommand> commands;
        private String message;

        public Invoker(List<DlCommand> list, String string) {
            this.commands = list;
            this.message = string;
        }

        @Override
        public void run() {
            CrsDataLinkManager.this.cb.operationStarted(this.message);
            HashMap<DlCommand.Key, Object> hashMap = new HashMap<DlCommand.Key, Object>();
            for (DlCommand dlCommand : this.commands) {
                hashMap = dlCommand.execute(hashMap);
                if (dlCommand.ok()) continue;
                CrsDataLinkManager.this.cb.operationStarted("Rolling back...");
                if (!dlCommand.undo()) {
                    ErrorMsg.displayError((Component)((Object)CrsDataLinkManager.this.pane), (EID)EMC.EID_ROLLBACK_FAILED);
                }
                CrsDataLinkManager.this.cb.operationStarted(this.message);
            }
            CrsDataLinkManager.this.cb.operationStopped();
        }
    }
}

