/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.idl.SonetMedia.sLineThresholds600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;

public abstract class CxcTdmLinePmThresholdsTableModel
extends TdmTableModel
implements ResettablePmThresholdsTableModel {
    protected boolean[] rowDirty = null;
    protected sLineThresholds600[] statsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    public String[] columnNames;
    private static final SDebug db = new SDebug("CxcTdmLinePmThresholdsTableModel");

    public CxcTdmLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.initColumnNames();
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sLineThresholds600[this.numLines];
    }

    protected abstract void initColumnNames();

    protected void refreshPmStats(int n) {
        if (this.statsVal.length > 0 && this.statsVal[n] == null) {
            try {
                this.statsVal[n] = new sLineThresholds600();
                this.model[n].getLineThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sLineThresholds600 getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                int n3 = this.model[n].getPortModel().getEqType();
                switch (n2) {
                    case 8: 
                    case 9: {
                        if (n3 == 28) {
                            return false;
                        }
                        return this.isProtectModuleCellEditable(n, n2);
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (n3 == 28 || n3 == 29) {
                            return false;
                        }
                        return this.isProtectModuleCellEditable(n, n2);
                    }
                }
                return this.isProtectModuleCellEditable(n, n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    private boolean isProtectModuleCellEditable(int n, int n2) throws AbstractCmsNoSuchEntityException {
        if (this.isUserAuthorizedToEditCell() && !this.model[0].getModuleModel().isProtectModule()) {
            return n2 > 0 && !this.model[n].isProtectLine();
        }
        return false;
    }

    private boolean isUserAuthorizedToEditCell() {
        return AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING);
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefLineThr(eEqType2, eEqType3, this.nearEnd, this.intervalType);
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sLineThresholds) {
            sLineThresholds sLineThresholds2 = (sLineThresholds)object;
            this.statsVal[n] = new sLineThresholds600();
            this.statsVal[n].es = sLineThresholds2.es;
            this.statsVal[n].ses = sLineThresholds2.ses;
            this.statsVal[n].cv = sLineThresholds2.cv;
            this.statsVal[n].uas = sLineThresholds2.uas;
            this.statsVal[n].fc = sLineThresholds2.fc;
            this.statsVal[n].psc = sLineThresholds2.psc;
            this.statsVal[n].psd = sLineThresholds2.psd;
            this.statsVal[n].pscw = sLineThresholds2.pscw;
            this.statsVal[n].psdw = sLineThresholds2.psdw;
            this.statsVal[n].pscs = sLineThresholds2.pscs;
            this.statsVal[n].psds = sLineThresholds2.psds;
            this.statsVal[n].pscr = sLineThresholds2.pscr;
            this.statsVal[n].psdr = sLineThresholds2.psdr;
        }
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    protected void printStats(sLineThresholds600 sLineThresholds6002) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sLineThresholds6002.cv);
            db.println("ES " + sLineThresholds6002.es);
            db.println("SES " + sLineThresholds6002.ses);
            db.println("FC " + sLineThresholds6002.fc);
            db.println("UAS " + sLineThresholds6002.uas);
            db.println("PSC " + sLineThresholds6002.psc);
            db.println("PSD " + sLineThresholds6002.psd);
            db.println("PSC-W " + sLineThresholds6002.pscw);
            db.println("PSD-W " + sLineThresholds6002.psdw);
            db.println("PSC-S " + sLineThresholds6002.pscs);
            db.println("PSD-S " + sLineThresholds6002.psds);
            db.println("PSC-R " + sLineThresholds6002.pscr);
            db.println("PSD-R " + sLineThresholds6002.psdr);
            db.println("===============================================");
        }
    }
}

