/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.E3LineUpdate;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.WbeModuleModel;
import cerent.cms.model.WbeSlot;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds3i.Ds3iProvPane;
import cerent.cms.ui.e1.E1ProvPane;
import cerent.cms.ui.e3.E3ProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class E1E3Ds3ProvPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] e3Lines;
    protected Ds123LineModel[] ds3Lines;
    protected Ds123LineModel[] e1Lines;
    private static final SDebug dbg = new SDebug("WbeProvPane");

    public E1E3Ds3ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, Ds123LineModel[] ds123LineModelArray3) {
        super(string, tabbedView);
        this.e1Lines = ds123LineModelArray;
        this.e3Lines = ds123LineModelArray2;
        this.ds3Lines = ds123LineModelArray3;
        boolean bl = true;
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        bl = wbeModuleModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
        this.registerWithModel();
    }

    protected void createSubTabs() {
        if (dbg.on()) {
            dbg.info("Creating SubTabs");
        }
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        this.subTabs.addTab("Broadband Ports", (Component)this.getBbeTab(wbeModuleModel));
        this.subTabs.addTab("E1", (Component)this.getE1Tab(this.e1Lines));
        this.subTabs.addTab("E3", (Component)this.getE3Tab(this.e3Lines));
        this.subTabs.addTab("DS3", (Component)this.getDs3Tab(this.ds3Lines));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
    }

    private Pane getWbeTab(WbeModuleModel wbeModuleModel) {
        WbeSlot wbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            wbeSlot = null;
            try {
                wbeSlot = wbeModuleModel.getWbeSlot();
                iPortContainerArray = new IPortContainer[]{wbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve WbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, wbeModuleModel, new MutablePortsProvPane("Wideband Ports", this.subTabs, iPortContainerArray, wbeSlot.getEqType(), false, CSHelpConst.WbePortProvPane, dbg));
    }

    private Pane getBbeTab(WbeModuleModel wbeModuleModel) {
        BbeSlot bbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            bbeSlot = null;
            boolean bl = true;
            try {
                bbeSlot = wbeModuleModel.getBbeSlot();
                iPortContainerArray = new IPortContainer[]{bbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve BbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, wbeModuleModel, new MutablePortsProvPane("Broadband Ports", this.subTabs, iPortContainerArray, bbeSlot.getEqType(), true, CSHelpConst.BbePortProvPane, dbg, false));
    }

    private Pane getE1Tab(Ds123LineModel[] ds123LineModelArray) {
        return new E1ProvPane("E1", this.subTabs, ds123LineModelArray, false);
    }

    private Pane getE3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new E3ProvPane("E3", this.subTabs, ds123LineModelArray, false);
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds3iProvPane("DS3", this.subTabs, ds123LineModelArray, false);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        }
        if (object instanceof E3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received E3LineUpdate..");
            }
            this.e3Lines = (Ds123LineModel[])((E3LineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

