/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WbeModuleModel;
import cerent.cms.model.WbeSlot;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1ProvPane;
import cerent.cms.ui.ds3e.Ds3eProvPane;
import cerent.cms.ui.ec1.Ec1ProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class WbeProvPane
extends AbstractSubTabbedPane
implements ITabName {
    public String DS1_E1_TAB_NAME = "DS1/E1";
    public String DS3_E3_TAB_NAME = "DS3/E3";
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected Ds123LineModel[] ds1Lines;
    private static final SDebug dbg = new SDebug("WbeProvPane");

    public WbeProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        boolean bl;
        WbeModuleModel wbeModuleModel;
        block6: {
            if (dbg.on()) {
                dbg.info("Creating SubTabs");
            }
            wbeModuleModel = (WbeModuleModel)this.getUiModel();
            bl = true;
            try {
                bl = wbeModuleModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
                if (bl) {
                    this.DS3_E3_TAB_NAME = "DS3";
                    this.DS1_E1_TAB_NAME = "DS1";
                } else {
                    this.DS3_E3_TAB_NAME = "E3";
                    this.DS1_E1_TAB_NAME = "E1";
                }
            }
            catch (Exception exception) {
                dbg.println("Could not determine tdmProtocolType for WbeProvPane!");
                if (!dbg.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.subTabs.addTab("Broadband Ports", (Component)this.getBbeTab(wbeModuleModel));
        this.subTabs.addTab(this.DS1_E1_TAB_NAME, (Component)this.getDs1Tab(this.ds1Lines));
        this.subTabs.addTab(this.DS3_E3_TAB_NAME, (Component)this.getDs3Tab(this.ds3Lines));
        if (bl) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(wbeModuleModel, this.ec1Lines));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
    }

    private Pane getWbeTab(WbeModuleModel wbeModuleModel) {
        WbeSlot wbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            wbeSlot = null;
            try {
                wbeSlot = wbeModuleModel.getWbeSlot();
                iPortContainerArray = new IPortContainer[]{wbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve WbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, wbeModuleModel, new MutablePortsProvPane("Wideband Ports", this.subTabs, iPortContainerArray, wbeSlot.getEqType(), false, CSHelpConst.WbePortProvPane, dbg));
    }

    private Pane getBbeTab(WbeModuleModel wbeModuleModel) {
        BbeSlot bbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            bbeSlot = null;
            try {
                bbeSlot = wbeModuleModel.getBbeSlot();
                iPortContainerArray = new IPortContainer[]{bbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve BbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, wbeModuleModel, new MutablePortsProvPane("Broadband Ports", this.subTabs, iPortContainerArray, bbeSlot.getEqType(), true, CSHelpConst.BbePortProvPane, dbg));
    }

    private Pane getEc1Tab(WbeModuleModel wbeModuleModel, TdmLineModel[] tdmLineModelArray) {
        return new Ec1ProvPane("EC1", this.subTabs, tdmLineModelArray, false, true);
    }

    private Pane getDs1Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds1ProvPane(this.DS1_E1_TAB_NAME, this.subTabs, ds123LineModelArray, false);
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds3eProvPane(this.DS3_E3_TAB_NAME, this.subTabs, ds123LineModelArray, false);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

