/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.wxc.WxcOchParametersTableModel;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class WxcOchParametersProvPane
extends NodeProvPane
implements TableModelListener {
    private OpticsOchTermModel[] ochModels;
    private WxcOchParametersTableModel dataModel = null;
    private OpticsModuleModel eqpmtModel;
    private ObservableManager _obsMgr = null;
    private UScrollPane scrollPane;
    private boolean notInited = true;
    private AbstractOpticsLineModel[] lowerInterfaces;
    private JLabel buttonLabel;

    public WxcOchParametersProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
    }

    protected void init() {
        this.ochModels = this.getHO();
        this.dataModel = new WxcOchParametersTableModel(this.ochModels, this.eqpmtModel);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.add((Component)this.scrollPane, "Center");
        this.prepareColumns();
        this.getObsMgr().addObservable((Observable[])this.ochModels);
        this.getObsMgr().addObservable((Observable[])this.lowerInterfaces);
        super.registerWithModel();
        this.notInited = false;
    }

    private OpticsOchTermModel[] getHO() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[0]), 1, this.getUiModel());
        return collection.toArray(new OpticsOchTermModel[0]);
    }

    protected void prepareColumns() {
        this.table.moveColumn(14, 0);
        this.table.moveColumn(16, 1);
        this.table.moveColumn(15, 5);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(16));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(15));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        AdminState[] adminStateArray = AdminState.getAdminStatesNoIS_NoMT(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        tableColumn.setPreferredWidth(170);
        this.removeColumn(6);
        this.removeColumn(7);
        this.removeColumn(13);
        this.removeColumn(1);
        this.removeColumn(4);
        this.removeColumn(0);
        this.table.updateUI();
    }

    protected void createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(null);
        this.add(cSHelpButtonPane, "South");
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
        this.dataModel.addToRemovedColumns(n);
    }

    protected void addColumn(int n) {
        String string = this.dataModel.getColumnName(n);
        TableColumn tableColumn = new TableColumn(n);
        tableColumn.setHeaderValue(string);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.getTable().getColumnModel().addColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (bl || bl2) {
            boolean bl3 = true;
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.ochModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.dataModel != null) {
                this.dataModel.refreshLineFromModel(n);
            }
        } else if (db.on()) {
            db.println("In OchParametersTableModel changeMessage cannot find Model " + observable);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }

    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                WxcOchParametersProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void structureChangeMessage(Observable observable, Object object) {
        this.getObsMgr().removeObservable((Observable[])this.ochModels);
        this.ochModels = this.getHO();
        this.getObsMgr().addObservable((Observable[])this.ochModels);
        this.dataModel.setOchTermModel(this.ochModels);
        super.structureChangeMessage(observable, object);
    }

    protected void deleteMessage(Observable observable, Object object) {
        this.getObsMgr().removeObservable((Observable[])this.ochModels);
        this.ochModels = this.getHO();
        this.dataModel.setOchTermModel(this.ochModels);
        this.getObsMgr().addObservable((Observable[])this.ochModels);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lowerInterfaces);
            this._obsMgr.removeObservable((Observable[])this.ochModels);
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.WxcOCHParametersProvPane;
    }
}

