/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Feature;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.xpl2.XPL2ProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class XPL2CardProvPane
extends NodeProvPane
implements ActionListener {
    XPL2ModuleModel module = (XPL2ModuleModel)this.getUiModel();
    JRadioButton l2button = new JRadioButton("L2 over DWDM", true);
    JRadioButton ge10Button = new JRadioButton("10GE MXP");
    JRadioButton ge20Button = new JRadioButton("20GE MXP");

    public XPL2CardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (this.module.getEqType() == 271) {
            this.ge10Button.setText("10GE TXP");
            this.ge20Button.setVisible(false);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.l2button);
        buttonGroup.add(this.ge10Button);
        buttonGroup.add(this.ge20Button);
        if (this.module.getNodeModelDelegate().provides(Feature.IDL_220) && this.isUserAuthorized()) {
            this.l2button.addActionListener(this);
            this.ge10Button.addActionListener(this);
            this.ge20Button.addActionListener(this);
        } else {
            this.l2button.setEnabled(false);
            this.ge10Button.setEnabled(false);
            this.ge20Button.setEnabled(false);
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 0, 1, 5));
        jPanel2.add(this.l2button);
        jPanel2.add(this.ge10Button);
        jPanel2.add(this.ge20Button);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Card Mode"));
        jPanel.add(jPanel2);
        this.add(jPanel, "Center");
        this.registerWithModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        eCardOperMode eCardOperMode2 = this.module.getCardOperMode();
        if (!((eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_2MXP || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP) && this.ge10Button.isSelected() || eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP && this.ge20Button.isSelected() || (eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH) && this.l2button.isSelected())) {
            this.setDirty();
        }
    }

    public void applyChangesToModel() throws Exception {
        eCardOperMode eCardOperMode2 = null;
        if (this.l2button.isSelected()) {
            eCardOperMode2 = this.module.getEqType() == 271 ? eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH : eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH;
        } else if (this.ge10Button.isSelected()) {
            eCardOperMode2 = this.module.getEqType() == 271 ? eCardOperMode.OPER_MODE_10GEXP_TXP : eCardOperMode.OPER_MODE_GEXP_2MXP;
        } else if (this.ge20Button.isSelected()) {
            eCardOperMode2 = eCardOperMode.OPER_MODE_GEXP_MXP;
        }
        try {
            this.setCursor(3);
            boolean bl = true;
            String string = ErrorMsg.getString((EID)EMC.WID_CARD_MODE_CHANGE) + "\n\nIs it OK to continue?";
            bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)"Change Card Mode");
            if (!bl) {
                this.refresh();
                return;
            }
            this.module.setCardOperMode(eCardOperMode2);
            ((XPL2ProvPane)((Object)this.getParent().getParent())).disableL2Tabs();
        }
        catch (Exception exception) {
            throw new ConfigError(exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    public void refreshFromModel() throws Exception {
        eCardOperMode eCardOperMode2 = this.module.getCardOperMode();
        this.l2button.setSelected(eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH);
        this.ge10Button.setSelected(eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_2MXP || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP);
        this.ge20Button.setSelected(eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2CardProvPane;
    }
}

