/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.EtherL2Media.eMultiGetProtocolStates;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BoardBusyError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ILearnedAddress;
import cerent.cms.model.IModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.MgetReqExpiredTimeout;
import cerent.cms.model.MgetReqInProgress;
import cerent.cms.model.MgetReqProtocolError;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongParameters;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.xpl2.XPL2MacAddrColumnRenderer;
import cerent.cms.ui.xpl2.XPL2MacAddrSourceInfo;
import cerent.cms.ui.xpl2.XPL2MacAddrTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPL2MacAddrDataSource
extends AbstractRowDataSource {
    private static SDebug db = new SDebug("XPL2MacAddrDataSource");
    private static final Preferences prefs = Preferences.instance();
    private IModel model = null;
    private TreeMap<XPL2MacAddrSourceInfo, Integer> portTreeMap = new TreeMap(new PortComparator());
    private TreeMap<Short, Short> vlanTreeMap = new TreeMap();
    private ArrayList<XPL2MacAddrSourceInfo> macAddrInfoList = new ArrayList();
    private static int NUM_OF_ENTRIES_PER_REQUEST = 1000;
    private static boolean continueRequest = true;
    private static boolean stopRequest = false;

    public XPL2MacAddrDataSource() {
        NUM_OF_ENTRIES_PER_REQUEST = prefs.getInt("ctc", this.getMacAddrPropertyName(), NUM_OF_ENTRIES_PER_REQUEST);
        prefs.setInt("ctc", this.getMacAddrPropertyName(), NUM_OF_ENTRIES_PER_REQUEST);
    }

    private String getMacAddrPropertyName() {
        return "xpl2.MacAddrLearning.entries.per.request";
    }

    public void setModel(IModel iModel) {
        this.model = iModel;
    }

    private XPL2MacAddrSourceInfo createMacAddrInfo(ILearnedAddress iLearnedAddress) {
        PortModel portModel = this.getPortModel(iLearnedAddress.getIfIndex());
        XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo = new XPL2MacAddrSourceInfo(iLearnedAddress, portModel);
        this.portTreeMap.put(xPL2MacAddrSourceInfo, new Integer(iLearnedAddress.getIfIndex()));
        Short s = new Short(iLearnedAddress.getVlanId());
        this.vlanTreeMap.put(s, s);
        return xPL2MacAddrSourceInfo;
    }

    public TreeMap<XPL2MacAddrSourceInfo, Integer> getPortTreeMap() {
        return this.portTreeMap;
    }

    public TreeMap<Short, Short> getVlanTreeMap() {
        return this.vlanTreeMap;
    }

    public void clearLearnedAddress() throws NoSuchEquipment {
        if (this.model == null) {
            return;
        }
        try {
            ((XPL2ModuleModel)this.model).clearLearnedAddress();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        this.macAddrInfoList.clear();
        this.fireDataSourceChanged();
    }

    public int getRowCount() {
        return this.macAddrInfoList.size();
    }

    public Object getObjectAtRow(int n) {
        return this.macAddrInfoList.get(n);
    }

    public Collection<XPL2MacAddrSourceInfo> getAllObjects() {
        return this.macAddrInfoList;
    }

    private PortModel getPortModel(int n) {
        IPortModel iPortModel = null;
        try {
            iPortModel = ((XPL2ModuleModel)this.model).getNodeModelDelegate().getIfModels().getInterfaceModel(n).getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        if (iPortModel != null && iPortModel instanceof PortModel) {
            return (PortModel)iPortModel;
        }
        return null;
    }

    protected static ILearnedAddress[] loadLearnedAddress(XPL2ModuleModel xPL2ModuleModel, sVlanRangeInfo[] sVlanRangeInfoArray, eMultiGetProtocolStates eMultiGetProtocolStates2) throws Exception {
        ILearnedAddress[] iLearnedAddressArray = null;
        boolean bl = false;
        try {
            iLearnedAddressArray = xPL2ModuleModel.getLearnedMacInfo(sVlanRangeInfoArray, eMultiGetProtocolStates2, NUM_OF_ENTRIES_PER_REQUEST);
        }
        catch (WrongParameters wrongParameters) {
            ErrorMsg.displayError((Component)XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), (EID)CEMC.EID_SVLAN_OUT_OF_RANGE);
            continueRequest = false;
            bl = true;
        }
        catch (EMCProvisionError eMCProvisionError) {
            SDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
            ErrorMsg.displayDetailed(XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), EMC.EID_GENERIC_REFRESH_ERROR, eMCProvisionError.getEID().getMessage());
            continueRequest = false;
            bl = true;
        }
        catch (NotSupportedOnEquipment notSupportedOnEquipment) {
            SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
            ErrorMsg.displayDetailed(XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, notSupportedOnEquipment.getMessage());
            continueRequest = false;
            bl = true;
        }
        catch (MgetReqInProgress mgetReqInProgress) {
            SDebug.printStackTrace((Throwable)mgetReqInProgress);
            ErrorMsg.displayError((Component)XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), (EID)EMC.EID_GET_REQUEST_IN_PROGRESS, (Object)"The resource is currently being used, please retry later.");
            continueRequest = false;
            bl = true;
        }
        catch (MgetReqExpiredTimeout mgetReqExpiredTimeout) {
            SDebug.printStackTrace((Throwable)mgetReqExpiredTimeout);
            ErrorMsg.displayError((Component)XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), (EID)EMC.EID_GET_REQUEST_EXPIRED_TIMEOUT);
            continueRequest = false;
            bl = true;
        }
        catch (MgetReqProtocolError mgetReqProtocolError) {
            SDebug.printStackTrace((Throwable)mgetReqProtocolError);
            ErrorMsg.displayError((Component)XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), (EID)EMC.EID_GET_REQUEST_PROTOCOL_ERROR);
            continueRequest = false;
            bl = true;
        }
        catch (BoardBusyError boardBusyError) {
            SDebug.printStackTrace((Throwable)boardBusyError);
            ErrorMsg.displayError((Component)XPL2MacAddrDataSource.getFrame(xPL2ModuleModel), (EID)EMC.EID_BOARD_BUSY);
            continueRequest = false;
            bl = true;
        }
        if (bl) {
            EventBus.instance().notifyEvent((Object)XPL2MacAddrDataSource.class.toString(), (Object)XPL2MacAddrTableModel.LOAD_ERROR);
            throw new Exception("Internal Error");
        }
        return iLearnedAddressArray;
    }

    private static Component getFrame(XPL2ModuleModel xPL2ModuleModel) {
        return xPL2ModuleModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    public void loadMacAddressList(SvlanRange[] svlanRangeArray) {
        Thread thread = new Thread(new LearnedMacAddrThread((XPL2ModuleModel)this.model, svlanRangeArray));
        thread.start();
    }

    public void dispose() {
        this.portTreeMap.clear();
        this.vlanTreeMap.clear();
        this.macAddrInfoList.clear();
        this.model = null;
    }

    public void stopAnyCall() {
        stopRequest = true;
    }

    class LearnedMacAddrThread
    implements Runnable {
        SvlanRange[] range = null;
        XPL2ModuleModel model = null;

        public LearnedMacAddrThread(XPL2ModuleModel xPL2ModuleModel, SvlanRange[] svlanRangeArray) {
            this.model = xPL2ModuleModel;
            this.range = svlanRangeArray;
        }

        public void run() {
            int n;
            EventBus.instance().notifyEvent((Object)XPL2MacAddrDataSource.class.toString(), (Object)XPL2MacAddrTableModel.LOAD_START);
            XPL2MacAddrDataSource.this.vlanTreeMap = new TreeMap();
            XPL2MacAddrDataSource.this.portTreeMap = new TreeMap(new PortComparator());
            ArrayList<ILearnedAddress> arrayList = new ArrayList<ILearnedAddress>();
            eMultiGetProtocolStates eMultiGetProtocolStates2 = eMultiGetProtocolStates.MGET_GET_START;
            continueRequest = true;
            stopRequest = false;
            sVlanRangeInfo[] sVlanRangeInfoArray = new sVlanRangeInfo[this.range.length];
            boolean bl = false;
            for (n = 0; n < this.range.length; ++n) {
                sVlanRangeInfo sVlanRangeInfo2 = new sVlanRangeInfo();
                sVlanRangeInfo2.minVlanId = this.range[n].low;
                sVlanRangeInfo2.maxVlanId = this.range[n].high;
                sVlanRangeInfoArray[n] = sVlanRangeInfo2;
            }
            while (continueRequest) {
                if (stopRequest) {
                    try {
                        this.model.getLearnedMacInfo(sVlanRangeInfoArray, eMultiGetProtocolStates.MGET_GET_STOP, NUM_OF_ENTRIES_PER_REQUEST);
                    }
                    catch (Exception exception) {
                        if (!db.on) break;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                ILearnedAddress[] iLearnedAddressArray = null;
                try {
                    iLearnedAddressArray = XPL2MacAddrDataSource.loadLearnedAddress(this.model, sVlanRangeInfoArray, eMultiGetProtocolStates2);
                }
                catch (Exception exception) {
                    arrayList.clear();
                    bl = true;
                    break;
                }
                if (stopRequest) {
                    arrayList.clear();
                    continue;
                }
                eMultiGetProtocolStates2 = eMultiGetProtocolStates.MGET_GET_NEXT;
                if (iLearnedAddressArray == null) break;
                for (int i = 0; i < iLearnedAddressArray.length; ++i) {
                    arrayList.add(iLearnedAddressArray[i]);
                }
                if (iLearnedAddressArray.length != 0 && !iLearnedAddressArray[iLearnedAddressArray.length - 1].isLastAddress()) continue;
                break;
            }
            XPL2MacAddrDataSource.this.macAddrInfoList.clear();
            for (n = 0; n < arrayList.size(); ++n) {
                XPL2MacAddrDataSource.this.macAddrInfoList.add(XPL2MacAddrDataSource.this.createMacAddrInfo((ILearnedAddress)arrayList.get(n)));
            }
            XPL2MacAddrDataSource.this.fireDataSourceChanged();
            if (!bl) {
                EventBus.instance().notifyEvent((Object)XPL2MacAddrDataSource.class.toString(), (Object)XPL2MacAddrTableModel.LOAD_FINISHED);
            }
        }
    }

    class PortComparator
    implements Comparator {
        PortComparator() {
        }

        public int compare(Object object, Object object2) {
            return XPL2MacAddrColumnRenderer.comparePort((XPL2MacAddrSourceInfo)object, (XPL2MacAddrSourceInfo)object2);
        }
    }
}

