/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eAISActionType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SVlanList;
import cerent.cms.model.SVlanProfileModels;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPL2SvlanProfileMappingTableModel
extends AbstractTableModel
implements Observer {
    private static EntityCellRenderer portRenderer = new EntityCellRenderer(false);
    private static final int SVLAN_INDEX = 0;
    static final String SVLAN_HEADER = "SVLAN";
    private boolean cellEditable = true;
    private XPL2ModuleModel eqpmt;
    private XPL2LineModel[] lineModels;
    private XPL2Layer2LineModel[] layerModels;
    private PortModel[] portModels;
    private String[] columnNames;
    private IVlanInfo[] vlanDB;
    private String[] vlanNames;
    private SVlanList vlandbList;
    private SVlanList ulist;
    private SVlanList slist;
    private int numRows;
    private Object[] profileNames;
    private Map<Integer, Map<Short, ISVlanProfileModel>> mappings;
    private Map<Integer, Map<Short, String>> mappingEdits;
    private long nameSequenceNum;
    private ObservableManager om;
    private static final SDebug db = new SDebug("XPL2SvlanProfileMappingTableModel");

    public XPL2SvlanProfileMappingTableModel(XPL2ModuleModel xPL2ModuleModel, PortModel[] portModelArray, XPL2LineModel[] xPL2LineModelArray, SVlanList sVlanList) throws CTCUserException {
        if (xPL2ModuleModel == null || xPL2LineModelArray == null || sVlanList == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmt=" + xPL2ModuleModel + " portModels=" + portModelArray + " lineModels=" + this.lineModels + " user svlan list=" + sVlanList);
            }
            throw new IllegalArgumentException("eqpmt/portModels/lines/slist must all be non-null");
        }
        this.eqpmt = xPL2ModuleModel;
        this.lineModels = xPL2LineModelArray;
        this.initLayerModels();
        this.portModels = portModelArray;
        this.ulist = sVlanList;
        this.recalculateColumnHeaders();
        this.mappingEdits = new HashMap<Integer, Map<Short, String>>();
        this.om = new ObservableManager(this, true){

            protected int indexOf(Observable observable) {
                int n = this.observables.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.observables.get(i);
                    if (e != observable) continue;
                    return i;
                }
                return -1;
            }
        };
        this.om.setPassing(true);
        this.om.setPassing(false);
        this.addObservable((Observable)((Object)xPL2ModuleModel));
        this.addObservableDesc(xPL2ModuleModel);
        this.registerWithInterfaces();
        this.registerWithPorts();
        this.getSvlanProfileModels().addAllObservers(this);
    }

    private void addObservable(Observable observable) {
        if (db.on()) {
            db.println("adding observable: " + observable);
        }
        this.om.addObservable(observable);
    }

    private void deleteObservable(Observable observable) {
        if (db.on()) {
            db.println("deleting observable: " + observable);
        }
        this.om.removeObservable(observable);
    }

    private void addObservableDesc(EntityModel entityModel) {
        if (db.on()) {
            db.println("adding observable descendant: " + entityModel);
        }
        List list = entityModel.getDescendants();
        for (Object e : list) {
            this.addObservable((Observable)((Object)((EntityModel)e)));
        }
    }

    private void deleteObservableDesc(EntityModel entityModel) {
        if (db.on()) {
            db.println("deleting observable descendant: " + entityModel);
        }
        List list = entityModel.getDescendants();
        for (Object e : list) {
            this.deleteObservable((Observable)((Object)((EntityModel)e)));
        }
    }

    public void setPassing(boolean bl) {
        if (db.on()) {
            db.println("setting passing mode to: " + bl);
        }
        boolean bl2 = this.om.isPassing();
        this.om.setPassing(bl);
        if (bl2 && !bl) {
            this.om.setBlockingModeController(null);
        }
        if (db.on()) {
            db.println("...om state now: " + this.om);
        }
    }

    public boolean didMissEvent() {
        return this.om.getBlockingModeControllerState() > 0;
    }

    public void setCellEditable(boolean bl) {
        this.cellEditable = bl;
    }

    private void initLayerModels() {
        int n = this.lineModels.length;
        this.layerModels = new XPL2Layer2LineModel[n];
        for (int i = 0; i < n; ++i) {
            this.layerModels[i] = this.lineModels[i].getLayer2LineModel();
        }
    }

    private SVlanProfileModels getSvlanProfileModels() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmt.getNodeModel();
        SVlanProfileModels sVlanProfileModels = nodeModelDelegate.getSVlanProfileModels();
        return sVlanProfileModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initMappings() {
        boolean bl;
        block10: {
            if (db.on()) {
                db.println("initMappings() enter");
            }
            bl = false;
            SVlanProfileModels sVlanProfileModels = this.getSvlanProfileModels();
            try {
                Map<Integer, Map<Short, ISVlanProfileModel>> map = sVlanProfileModels.getProfileMappings(this.eqpmt);
                if (db.on()) {
                    int n = 0;
                    for (Map<Short, ISVlanProfileModel> object2 : map.values()) {
                        n += object2.size();
                    }
                    db.println("finished mapping lookup and found: " + n + " mappings...");
                    TreeSet<Integer> treeSet = new TreeSet<Integer>(map.keySet());
                    Iterator iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        Integer n2 = (Integer)iterator.next();
                        db.println("port: " + n2);
                        Map<Short, ISVlanProfileModel> map2 = map.get(n2);
                        TreeSet<Short> treeSet2 = new TreeSet<Short>(map2.keySet());
                        for (Short s : treeSet2) {
                            db.println("  svlan: " + s + ", profile: " + map2.get(s));
                        }
                    }
                }
                XPL2ModuleModel xPL2ModuleModel = this.eqpmt;
                synchronized (xPL2ModuleModel) {
                    bl = this.areEqual(map, this.mappings);
                    this.mappings = map;
                }
            }
            catch (CTCUserException cTCUserException) {
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
        return bl;
    }

    private boolean areEqual(Map<Integer, Map<Short, ISVlanProfileModel>> map, Map<Integer, Map<Short, ISVlanProfileModel>> map2) {
        if (map == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        return ((Object)map).equals(map2);
    }

    private IVlanInfo[] getVlanDb() {
        return this.eqpmt.getVlanDb();
    }

    private boolean initVlanDB() {
        return this.initVlanDB(false);
    }

    private boolean initVlanDB(boolean bl) {
        IVlanInfo[] iVlanInfoArray;
        Object object = iVlanInfoArray = bl || this.vlanDB == null ? this.getVlanDb() : null;
        if (db.on() && iVlanInfoArray != null) {
            db.println("new vlan DB length: " + iVlanInfoArray.length);
        }
        boolean bl2 = false;
        if (bl && iVlanInfoArray == null) {
            return bl2;
        }
        if (this.vlanDB != null && iVlanInfoArray != null && !XPL2SvlanProfileMappingTableModel.areEqual(this.vlanDB, iVlanInfoArray)) {
            this.vlanDB = null;
        }
        if (this.vlanDB == null) {
            bl2 = true;
            this.vlanDB = iVlanInfoArray;
            this.vlanNames = new String[4093];
            this.vlandbList = new SVlanList();
            BitSet bitSet = this.vlandbList.getBitSet();
            for (int i = 0; i < this.vlanDB.length; ++i) {
                IVlanInfo iVlanInfo = this.vlanDB[i];
                int n = iVlanInfo.getVlanId() - 1;
                this.vlanNames[n] = iVlanInfo.getVlanName();
                bitSet.set(n);
            }
            this.vlandbList.or(bitSet);
        }
        return bl2;
    }

    private static boolean areEqual(IVlanInfo[] iVlanInfoArray, IVlanInfo[] iVlanInfoArray2) {
        boolean bl;
        if (iVlanInfoArray == null) {
            return iVlanInfoArray2 == null;
        }
        if (iVlanInfoArray2 == null) {
            return false;
        }
        if (iVlanInfoArray == iVlanInfoArray2) {
            return true;
        }
        int n = iVlanInfoArray.length;
        boolean bl2 = bl = n == iVlanInfoArray2.length;
        if (bl) {
            for (int i = 0; i < n && bl; ++i) {
                IVlanInfo iVlanInfo = iVlanInfoArray[i];
                IVlanInfo iVlanInfo2 = iVlanInfoArray2[i];
                bl = iVlanInfo.getVlanId() == iVlanInfo2.getVlanId() && iVlanInfo.getVlanName().equals(iVlanInfo2.getVlanName());
            }
        }
        return bl;
    }

    synchronized SVlanList getVlanDbIntersectedList(SVlanList sVlanList) {
        this.initVlanDB();
        SVlanList sVlanList2 = new SVlanList(this.vlandbList);
        sVlanList2.and(sVlanList.getBitSet());
        return sVlanList2;
    }

    synchronized String[] getVlanNames() {
        this.initVlanDB();
        return this.vlanNames;
    }

    private boolean intersectWithVlanDB() {
        this.initVlanDB();
        SVlanList sVlanList = new SVlanList(this.vlandbList);
        boolean bl = false;
        sVlanList.and(this.ulist.getBitSet());
        boolean bl2 = bl = this.slist == null || !sVlanList.equals(this.slist);
        if (bl) {
            this.slist = sVlanList;
        }
        return bl;
    }

    private Object[] getNewProfileNames() {
        Object[] objectArray;
        block3: {
            objectArray = null;
            try {
                SVlanProfileModels sVlanProfileModels = this.getSvlanProfileModels();
                this.nameSequenceNum = sVlanProfileModels.getNameSequenceNum();
                ISVlanProfileModel[] iSVlanProfileModelArray = sVlanProfileModels.getSVlanProfileModels();
                Object[] objectArray2 = new Object[iSVlanProfileModelArray.length];
                for (int i = 0; i < iSVlanProfileModelArray.length; ++i) {
                    ISVlanProfileModel iSVlanProfileModel = iSVlanProfileModelArray[i];
                    int n = iSVlanProfileModel.getIndex();
                    String string = iSVlanProfileModel.getName();
                    objectArray2[i] = string;
                }
                Arrays.sort(objectArray2);
                objectArray = new Object[iSVlanProfileModelArray.length + 1];
                System.arraycopy(objectArray2, 0, objectArray, 1, iSVlanProfileModelArray.length);
                objectArray[0] = "Detach Current";
            }
            catch (CTCUserException cTCUserException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
        return objectArray;
    }

    private boolean initProfileNames() {
        return this.initProfileNames(false);
    }

    boolean hasNameSequenceNumChanged() {
        SVlanProfileModels sVlanProfileModels = this.getSvlanProfileModels();
        long l = sVlanProfileModels.getNameSequenceNum();
        boolean bl = l != this.nameSequenceNum;
        return bl;
    }

    private boolean initProfileNames(boolean bl) {
        boolean bl2 = false;
        if (!bl && this.profileNames != null) {
            bl2 = this.hasNameSequenceNumChanged();
        }
        Object[] objectArray = bl || this.profileNames == null || bl2 ? this.getNewProfileNames() : null;
        boolean bl3 = bl2;
        if (bl && objectArray == null) {
            return bl3;
        }
        if (this.profileNames != null && objectArray != null && !XPL2SvlanProfileMappingTableModel.areEqual(this.profileNames, objectArray)) {
            this.profileNames = null;
        }
        if (this.profileNames == null) {
            bl3 = true;
            this.profileNames = objectArray;
        }
        return bl3;
    }

    private static boolean areEqual(Object[] objectArray, Object[] objectArray2) {
        boolean bl;
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray == objectArray2) {
            return true;
        }
        int n = objectArray.length;
        boolean bl2 = bl = n == objectArray2.length;
        if (bl) {
            for (int i = 0; i < n && bl; ++i) {
                Object object = objectArray[i];
                Object object2 = objectArray2[i];
                bl = object.equals(object2);
            }
        }
        return bl;
    }

    public synchronized Object[] getProfileNames() {
        this.initProfileNames();
        return this.profileNames;
    }

    private String getPortNum(int n) {
        PortModel portModel = this.portModels[n];
        String string = portRenderer.getPortString(portModel, false);
        return string;
    }

    synchronized String[] getPortNums() {
        int n = this.portModels.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getPortNum(i);
        }
        return stringArray;
    }

    private void recalculateColumnHeaders() {
        int n = 1 + this.lineModels.length;
        if (this.columnNames == null || this.columnNames.length != n) {
            this.columnNames = new String[n];
        }
        this.columnNames[0] = SVLAN_HEADER;
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.columnNames[i + 1] = this.getPortNum(i);
        }
        if (db.on()) {
            db.println("recalculateColumnHeaders determined there are now: " + n + " columns");
        }
    }

    @Override
    public synchronized boolean isCellEditable(int n, int n2) {
        return n2 > 0 && this.cellEditable;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.columnNames == null ? 1 : this.columnNames.length;
    }

    @Override
    public synchronized String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public synchronized int getRowCount() {
        return this.slist == null ? 0 : this.slist.getSvlans().length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    static String getVlanDisplay(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(n));
        stringBuilder.append(" (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        short s = -1;
        String string = null;
        Observer observer = this;
        synchronized (observer) {
            s = this.slist.getSvlans()[n];
            if (n2 == 0) {
                String string2 = this.vlanNames[s - 1];
                return XPL2SvlanProfileMappingTableModel.getVlanDisplay(s, string2);
            }
        }
        string = "";
        if (this.mappings == null) {
            return string;
        }
        observer = null;
        XPL2ModuleModel xPL2ModuleModel = this.eqpmt;
        synchronized (xPL2ModuleModel) {
            observer = this.portModels[n2 - 1];
        }
        int n3 = observer == null ? -1 : ((EntityModel)observer).getIndex();
        Map<Short, String> map = null;
        Map<Short, ISVlanProfileModel> map2 = null;
        Map<Integer, Map<Short, String>> map3 = this.mappingEdits;
        synchronized (map3) {
            map = this.mappingEdits.get(n3);
            String string3 = null;
            if (map != null && (string3 = map.get(s)) != null && string3.equals("Detach Current")) {
                string3 = "";
            }
            if (string3 != null) {
                string = string3;
            } else {
                ISVlanProfileModel iSVlanProfileModel;
                map2 = this.mappings.get(n3);
                if (map2 != null && (iSVlanProfileModel = map2.get(s)) != null) {
                    string = iSVlanProfileModel.getName();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("setValueAt(" + object + ", " + n + ", " + n2 + ")");
        }
        short s = -1;
        Object var5_5 = null;
        Observer observer = this;
        synchronized (observer) {
            s = this.slist.getSvlans()[n];
        }
        observer = null;
        XPL2ModuleModel xPL2ModuleModel = this.eqpmt;
        synchronized (xPL2ModuleModel) {
            observer = this.portModels[n2 - 1];
        }
        int n3 = observer == null ? -1 : ((EntityModel)observer).getIndex();
        boolean bl = false;
        Map<Integer, Map<Short, String>> map = this.mappingEdits;
        synchronized (map) {
            String string;
            Object object2;
            Map<Short, ISVlanProfileModel> map2 = this.mappings.get(n3);
            if (map2 != null && (object2 = map2.get(s)) != null && (string = object2.getName()) != null && string.equals(object)) {
                return;
            }
            object2 = this.mappingEdits.get(n3);
            if (object2 == null) {
                object2 = new HashMap();
                this.mappingEdits.put(n3, (Map<Short, String>)object2);
            }
            bl = true;
            object2.put(s, object.toString());
        }
        if (bl) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        boolean bl = false;
        Map<Integer, Map<Short, String>> map = this.mappingEdits;
        synchronized (map) {
            bl = this.mappingEdits.size() > 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDirty() {
        int n;
        int n2;
        if (db.on()) {
            db.println("resetDirty() enter");
        }
        ArrayList<Integer> arrayList = null;
        ArrayList<Integer> arrayList2 = null;
        XPL2SvlanProfileMappingTableModel xPL2SvlanProfileMappingTableModel = this;
        synchronized (xPL2SvlanProfileMappingTableModel) {
            if (this.slist == null) {
                return;
            }
            short[] sArray = this.slist.getSvlans();
            Map<Integer, Map<Short, String>> map = this.mappingEdits;
            synchronized (map) {
                int n3 = this.mappingEdits.size();
                if (n3 == 0) {
                    return;
                }
                if (db.on()) {
                    db.println("# of edits to consider: " + n3);
                }
                arrayList = new ArrayList<Integer>(n3);
                arrayList2 = new ArrayList<Integer>(n3);
                for (Integer n4 : this.mappingEdits.keySet()) {
                    n2 = -1;
                    int n5 = n4;
                    XPL2LineModel xPL2LineModel = null;
                    Object object = this.eqpmt;
                    synchronized (object) {
                        for (int i = 0; i < this.portModels.length; ++i) {
                            if (this.portModels[i].getIndex() != n5) continue;
                            xPL2LineModel = this.lineModels[i];
                            n2 = i + 1;
                            break;
                        }
                    }
                    if (xPL2LineModel == null) {
                        if (!db.on()) continue;
                        db.println("warning: line not found for any port");
                        continue;
                    }
                    object = this.mappingEdits.get(n4);
                    for (Short s : object.keySet()) {
                        short s2 = s;
                        int n6 = Arrays.binarySearch(sArray, s2);
                        if (n6 < 0) continue;
                        n = n6;
                        if (db.on()) {
                            db.println("found dirty cell (" + n + ", " + n2 + ")");
                        }
                        arrayList.add(n);
                        arrayList2.add(n2);
                    }
                }
                this.mappingEdits.clear();
            }
        }
        if (arrayList == null || arrayList2 == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i);
            n2 = (Integer)arrayList2.get(i);
            this.fireTableCellUpdated(n, n2);
            if (!db.on()) continue;
            db.println("fired cell update (" + n + ", " + n2 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLineFromModel(int n) {
        block17: {
            XPL2LineModel xPL2LineModel = this.lineModels[n - 1];
            IPortModel iPortModel = null;
            if (db.on()) {
                db.println("refreshing line from assoc. w/ column: " + n);
            }
            try {
                block16: {
                    block15: {
                        try {
                            iPortModel = xPL2LineModel.getPortModel();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!db.on()) break block15;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                    if (iPortModel != null) {
                        if (db.on()) {
                            db.println("refreshing col: " + n + " for line: " + xPL2LineModel);
                        }
                        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmt.getNodeModel();
                        SVlanProfileModels sVlanProfileModels = nodeModelDelegate.getSVlanProfileModels();
                        Map<Integer, Map<Short, ISVlanProfileModel>> map = null;
                        try {
                            map = sVlanProfileModels.getProfileMappings(iPortModel);
                            if (db.on()) {
                                db.println("updated line profile mapping for: " + xPL2LineModel);
                                db.println("...the lack of mapping entries means the default profile is in use");
                                this.dumpMappings(map);
                            }
                            XPL2ModuleModel xPL2ModuleModel = this.eqpmt;
                            synchronized (xPL2ModuleModel) {
                                this.mappings.putAll(map);
                            }
                        }
                        catch (CTCUserException cTCUserException) {
                            if (!db.on()) break block16;
                            SDebug.printStackTrace((Throwable)cTCUserException);
                        }
                    }
                }
                this.resetLineCache(iPortModel);
                if (db.on()) {
                    db.println("firing table cell updates for col: " + n);
                }
                for (int i = 0; i < this.numRows; ++i) {
                    this.fireTableCellUpdated(i, n);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block17;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void dumpMappings(Map<Integer, Map<Short, ISVlanProfileModel>> map) {
        for (Integer n : map.keySet()) {
            db.println("port: " + n);
            Map<Short, ISVlanProfileModel> map2 = map.get(n);
            for (Short s : map2.keySet()) {
                db.print("  vlan: " + s);
                db.println(" -> profile: " + map2.get(s));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLineCache(IPortModel iPortModel) throws Exception {
        if (iPortModel != null) {
            int n = iPortModel.getIndex();
            Map<Integer, Map<Short, String>> map = this.mappingEdits;
            synchronized (map) {
                this.mappingEdits.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int applyToModel(int n, DetailedLog detailedLog) throws Exception {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmt.getNodeModel();
        SVlanProfileModels sVlanProfileModels = nodeModelDelegate.getSVlanProfileModels();
        XPL2LineModel xPL2LineModel = null;
        int n2 = -1;
        PortModel portModel = null;
        String string = null;
        int n3 = n - 1;
        int n4 = 0;
        int n5 = 0;
        Map<Integer, Map<Short, String>> map = this.mappingEdits;
        synchronized (map) {
            Object object = this.eqpmt;
            synchronized (object) {
                n4 = this.portModels.length;
                if (n3 < 0 || n3 >= n4) {
                    throw new IllegalArgumentException("Column index must be in the range 1-" + n4);
                }
                portModel = this.portModels[n3];
                string = portRenderer.getPortString(portModel, false);
                n2 = portModel.getIndex();
                xPL2LineModel = this.lineModels[n3];
            }
            object = this.mappingEdits.get(n2);
            if (object == null) {
                return n5;
            }
            n5 = object.size();
            if (db.on()) {
                db.println("# of svlan edits found: " + object.size() + " for col: " + n);
            }
            HashSet hashSet = new HashSet(object.keySet());
            for (Short s : hashSet) {
                Object object2;
                short s2 = s;
                String string2 = (String)object.get(s);
                if (db.on()) {
                    db.println("applyProfileMapping(" + xPL2LineModel + ", " + s2 + ", " + string2 + ")");
                }
                try {
                    DetailedLog detailedLog2;
                    XPL2ModuleModel xPL2ModuleModel;
                    if (!sVlanProfileModels.applyProfileMapping(xPL2LineModel, s2, string2)) {
                        xPL2ModuleModel = this.eqpmt;
                        synchronized (xPL2ModuleModel) {
                            object2 = this.mappings.get(n2);
                            if (object2 != null) {
                                object2.remove(s);
                            }
                            continue;
                        }
                    }
                    xPL2ModuleModel = sVlanProfileModels.getProfileByName(string2);
                    if (xPL2ModuleModel == null) continue;
                    object2 = this.eqpmt;
                    synchronized (object2) {
                        detailedLog2 = this.mappings.get(n2);
                        if (detailedLog2 == null) {
                            detailedLog2 = new HashMap<Short, ISVlanProfileModel>();
                            this.mappings.put(n2, (Map<Short, ISVlanProfileModel>)detailedLog2);
                        }
                        detailedLog2.put((Short)s, (ISVlanProfileModel)xPL2ModuleModel);
                    }
                    try {
                        object2 = xPL2LineModel.getAisAction();
                        if (object2 != eAISActionType.AIS_ACTION_SQUELCH_PORT || !xPL2ModuleModel.getLinkIntegrity() || detailedLog == null) continue;
                        detailedLog2 = new DetailedLog(2, ErrorMsg.getString((EID)EMC.WID_AIS_PORT_SQUELCH_NC_LINK_INTEGRITY, (Object)string2, (Object)string, (Object)s));
                        detailedLog.addChild(detailedLog2);
                        detailedLog.updateTime();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
                catch (CTCUserException cTCUserException) {
                    if (detailedLog != null) {
                        object2 = new DetailedLog(3, "An error occurred while storing SVLAN profile mapping '" + string2 + "' for port: " + string + " and SVLAN: " + s2, (Exception)((Object)cTCUserException));
                        detailedLog.addChild((DetailedLog)object2);
                        detailedLog.updateTime();
                    }
                    throw cTCUserException;
                }
            }
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initLines() {
        boolean bl = false;
        XPL2ModuleModel xPL2ModuleModel = this.eqpmt;
        synchronized (xPL2ModuleModel) {
            bl = this.initLineModels();
        }
        return bl;
    }

    private boolean initLineModels() {
        boolean bl;
        XPL2LineModel[] xPL2LineModelArray = this.eqpmt.getXPL2EtherLines();
        boolean bl2 = bl = !XPL2SvlanProfileMappingTableModel.areEqual(xPL2LineModelArray, this.lineModels);
        if (db.on()) {
            db.println("initLineModels - lines changed: " + bl);
        }
        if (bl) {
            this.unRegisterWithInterfaces();
            this.unRegisterWithPorts();
            this.lineModels = xPL2LineModelArray;
            this.initLayerModels();
            this.portModels = this.eqpmt.getXPL2EtherPorts();
            this.registerWithInterfaces();
            this.registerWithPorts();
            this.recalculateColumnHeaders();
            if (db.on()) {
                int n;
                db.println("(Re)initializating with " + xPL2LineModelArray.length + " lines for this card " + this.eqpmt + " are: ");
                for (n = 0; n < xPL2LineModelArray.length; ++n) {
                    db.println("  " + n + ": " + xPL2LineModelArray[n]);
                }
                db.println("...and initializating with " + this.portModels.length + " ports for this card " + this.eqpmt + " are: ");
                for (n = 0; n < this.portModels.length; ++n) {
                    db.println("  " + n + ": " + this.portModels[n]);
                }
            }
        }
        return bl;
    }

    private void refreshFromModelLogException() {
        block2: {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.refreshFromModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFromModel(SVlanList sVlanList) throws Exception {
        Map<Integer, Map<Short, ISVlanProfileModel>> map;
        Map<Integer, Map<Short, String>> map2;
        if (db.on()) {
            db.println("refreshFromModel() enter");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Object object = this.eqpmt;
        synchronized (object) {
            bl3 = this.initLineModels();
            if (bl3) {
                map2 = this.mappingEdits;
                synchronized (map2) {
                    this.mappingEdits.clear();
                }
                bl = true;
                this.fireTableStructureChanged();
            }
        }
        object = null;
        map2 = this;
        synchronized (map2) {
            if (sVlanList != null && !sVlanList.equals(this.ulist)) {
                bl4 = true;
                this.ulist = sVlanList;
            }
            object = this.slist;
            this.numRows = this.slist.getSvlans().length;
            if (bl4 |= this.intersectWithVlanDB()) {
                map = this.mappingEdits;
                synchronized (map) {
                    this.mappingEdits.clear();
                }
                if (!bl) {
                    bl2 = this.diff((SVlanList)object);
                }
            }
            if ((bl5 = this.initProfileNames(true)) && !bl) {
                bl2 = true;
                this.fireTableDataChanged();
            }
        }
        map2 = this.mappingEdits;
        synchronized (map2) {
            map = this.mappings;
            bl6 = this.initMappings();
            this.resetDirty();
            if (!(!bl6 || bl && bl2)) {
                this.diff(map);
            }
        }
    }

    private static boolean areEqual(XPL2LineModel[] xPL2LineModelArray, XPL2LineModel[] xPL2LineModelArray2) {
        boolean bl;
        boolean bl2 = bl = xPL2LineModelArray == xPL2LineModelArray2;
        if (!bl) {
            if (xPL2LineModelArray == null) {
                bl = xPL2LineModelArray2 == null;
            } else if (xPL2LineModelArray2 != null) {
                boolean bl3 = bl = xPL2LineModelArray.length == xPL2LineModelArray2.length;
                if (bl) {
                    for (int i = 0; i < xPL2LineModelArray.length && bl; bl &= xPL2LineModelArray[i].getIndex() == xPL2LineModelArray2[i].getIndex(), ++i) {
                    }
                }
            }
        }
        return bl;
    }

    private synchronized boolean diff(SVlanList sVlanList) {
        if (sVlanList == null || this.slist == null) {
            this.fireTableDataChanged();
            return true;
        }
        SVlanList sVlanList2 = new SVlanList(sVlanList);
        SVlanList sVlanList3 = new SVlanList(this.slist);
        sVlanList2.andNot(this.slist.getBitSet());
        sVlanList3.andNot(sVlanList.getBitSet());
        short[] sArray = sVlanList2.getSvlans();
        short[] sArray2 = sVlanList3.getSvlans();
        int n = Math.max(sArray.length, sArray2.length);
        int n2 = sArray.length;
        int n3 = sArray2.length;
        while (n2 >= 0 || n3 >= 0) {
            int n4 = -1;
            int n5 = -1;
            if (n2 >= 0) {
                n4 = sArray[n2];
            }
            if (n3 >= 0) {
                n5 = sArray2[n2];
            }
            if (n4 > n5) {
                this.fireTableRowsDeleted(n2, n2);
                --n2;
                continue;
            }
            if (n5 > n4) {
                this.fireTableRowsInserted(n3, n3);
                --n3;
                continue;
            }
            if (n4 < 0) continue;
            this.fireTableRowsUpdated(n2, n2);
            --n2;
            --n3;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean diff(Map<Integer, Map<Short, ISVlanProfileModel>> map) {
        Map<Integer, Map<Short, String>> map2 = this.mappingEdits;
        synchronized (map2) {
            if (map == null) {
                if (this.mappings == null) {
                    return false;
                }
                this.fireTableDataChanged();
                return true;
            }
            if (this.mappings == null) {
                this.fireTableDataChanged();
                return true;
            }
            if (!((Object)map.keySet()).equals(this.mappings.keySet())) {
                this.fireTableStructureChanged();
                return true;
            }
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            Object object = this.eqpmt;
            synchronized (object) {
                for (int i = 0; i < this.portModels.length; ++i) {
                    PortModel portModel = this.portModels[i];
                    int n = portModel.getIndex();
                    hashMap.put(n, i + 1);
                }
            }
            object = null;
            Object object2 = this;
            synchronized (object2) {
                object = new SVlanList(this.slist);
            }
            object2 = ((SVlanList)object).getSvlans();
            for (Integer n : this.mappings.keySet()) {
                Map<Short, ISVlanProfileModel> map3 = map.get(n);
                Map<Short, ISVlanProfileModel> map4 = this.mappings.get(n);
                Map<Short, String> map5 = this.mappingEdits.get(n);
                for (Short s : map4.keySet()) {
                    int n2;
                    String string;
                    ISVlanProfileModel iSVlanProfileModel = map3.get(s);
                    ISVlanProfileModel iSVlanProfileModel2 = map4.get(s);
                    String string2 = string = map5 != null ? map5.get(s) : null;
                    if (string == null && iSVlanProfileModel2 != null) {
                        string = iSVlanProfileModel2.getName();
                    }
                    if (iSVlanProfileModel2 == null && iSVlanProfileModel == null || iSVlanProfileModel != null && iSVlanProfileModel.getName().equals(string) || (n2 = Arrays.binarySearch((short[])object2, s)) < 0) continue;
                    int n3 = -1;
                    Integer n4 = (Integer)hashMap.get(n);
                    if (n4 == null) continue;
                    n3 = n4;
                    this.fireTableCellUpdated(n2, n3);
                }
            }
        }
        return false;
    }

    private void registerWithInterfaces() {
        for (XPL2Layer2LineModel etherLineModel : this.layerModels) {
            this.addObservable((Observable)((Object)etherLineModel));
        }
        for (EtherLineModel etherLineModel : this.lineModels) {
            this.addObservable((Observable)((Object)etherLineModel));
        }
    }

    private void registerWithPorts() {
        for (PortModel portModel : this.portModels) {
            this.addObservable((Observable)((Object)portModel));
        }
    }

    private void unRegisterWithInterfaces() {
        if (this.layerModels != null) {
            for (EtherLineModel etherLineModel : this.layerModels) {
                if (etherLineModel == null) continue;
                this.deleteObservable((Observable)((Object)etherLineModel));
            }
        }
        if (this.lineModels != null) {
            for (EtherLineModel etherLineModel : this.lineModels) {
                if (etherLineModel == null) continue;
                this.deleteObservable((Observable)((Object)etherLineModel));
            }
        }
    }

    private void unRegisterWithPorts() {
        if (this.portModels != null) {
            for (PortModel portModel : this.portModels) {
                this.deleteObservable((Observable)((Object)portModel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block6: {
            if (db.on()) {
                db.println("dispose() enter");
            }
            this.deleteObservableDesc(this.eqpmt);
            this.deleteObservable((Observable)((Object)this.eqpmt));
            try {
                this.getSvlanProfileModels().deleteAllObservers(this);
            }
            catch (CTCUserException cTCUserException) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
        XPL2SvlanProfileMappingTableModel xPL2SvlanProfileMappingTableModel = this;
        synchronized (xPL2SvlanProfileMappingTableModel) {
            this.unRegisterWithInterfaces();
            this.unRegisterWithPorts();
            this.vlanDB = null;
            this.profileNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        Object object2;
        Integer n;
        if (db.on()) {
            db.println("update(" + observable + "(" + observable.getClass().getName() + "), " + object + ")");
        }
        if (observable instanceof EntityModel) {
            if (object instanceof Integer) {
                n = (Integer)object;
                if (n.equals(ModelUpdateType.ADDED)) {
                    if (db.on()) {
                        db.println("Possible Port model: " + observable + " ADDED on assoc. pluggable container");
                    }
                    this.refreshFromModelLogException();
                } else if (observable instanceof ModuleModel && n.equals(ModelUpdateType.CHANGED)) {
                    object2 = this.getVlanDb();
                    boolean bl = false;
                    XPL2SvlanProfileMappingTableModel xPL2SvlanProfileMappingTableModel = this;
                    synchronized (xPL2SvlanProfileMappingTableModel) {
                        bl = XPL2SvlanProfileMappingTableModel.areEqual(this.vlanDB, object2);
                    }
                    if (!bl) {
                        if (db.on()) {
                            db.println("user set of vlans to be displayed may have changed");
                        }
                        this.refreshFromModelLogException();
                    }
                }
            }
        } else if (observable instanceof PortModel) {
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("Port model: " + observable + " DELETED");
                }
                this.refreshFromModelLogException();
            }
        } else if (observable instanceof SVlanProfileModels || observable instanceof SVlanProfileModels) {
            this.refreshFromModelLogException();
        } else if (observable instanceof XPL2Layer2LineModel) {
            if (!(object instanceof Integer)) {
                return;
            }
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got an Changed Message for " + observable);
                }
                int n2 = -1;
                object2 = this;
                synchronized (object2) {
                    n2 = Arrays.asList(this.layerModels).indexOf(observable);
                }
                if (n2 >= 0) {
                    this.refreshLineFromModel(n2 + 1);
                }
            }
        } else if (observable instanceof XPL2LineModel) {
            if (!(object instanceof Integer)) {
                return;
            }
            if (((Integer)object).equals(ModelUpdateType.CHANGED) || ((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("Got an Delete/Update Message for " + observable);
                }
                int n3 = -1;
                object2 = this;
                synchronized (object2) {
                    n3 = Arrays.asList(this.lineModels).indexOf(observable);
                }
                if (n3 >= 0) {
                    this.refreshLineFromModel(n3 + 1);
                }
            }
        }
        if (observable instanceof EntityModel && object instanceof Integer) {
            n = (Integer)object;
            object2 = (IVlanInfo[])observable;
            if (n.equals(ModelUpdateType.ADDED)) {
                this.addObservableDesc((EntityModel)object2);
            } else if (n.equals(ModelUpdateType.DELETED)) {
                this.deleteObservable((Observable)object2);
                this.deleteObservableDesc((EntityModel)object2);
            }
        }
    }
}

