/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.PersistableCachedValue;
import cerent.cms.model.PersistableModel;
import cerent.cms.xml.AbstractMetaData;
import cerent.cms.xml.AbstractSimpleMetaData;
import cerent.cms.xml.AttributeCmdClassification;
import cerent.cms.xml.IAttributeCmdClassification;
import cerent.cms.xml.IMethodMetaData;
import cerent.cms.xml.ISimpleMetaData;
import cerent.cms.xml.MetaData;
import cerent.cms.xml.MetaDataFactory;
import cerent.cms.xml.MethodState;
import cerent.cms.xml.MethodTypeInfo;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.TypeInfoRepository;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class MetaDataRepository {
    static final String[] StringArrayTemplate = new String[0];
    static final Class[] ClassArrayTemplate = new Class[0];
    private static MetaDataRepository instance;
    private static HashMap attributeLookup;
    private static HashMap metaDataLookup;
    public static final String SCHEMA_DIR = "/schema/";
    private static final String METADATA_RES = "schema/CTCMetaData.ini";
    private static final String METADATA_FILE = "/schema/CTCMetaData.ini";
    private static final String XML_METADATA_FILE_PREF = "xml.metadatafile";
    private static final String XML_PREFER_NCV = "xml.preferncv";
    private static final String NO_PERMISSION = "NO_PERMISSION";
    private static final String DELIMITER = ",";
    private static final String GET_ARG_NAMES = ".GETArgNames";
    private static final String GET_ARG_TYPES = ".GETArgTypes";
    private static final String GET_ARG_HELPERS = ".GETArgHelpers";
    private static final String SET_ARG_NAMES = ".SETArgNames";
    private static final String SET_ARG_TYPES = ".SETArgTypes";
    private static final String SET_ARG_HELPERS = ".SETArgHelpers";
    private static final String RETURN_TYPE = ".ReturnType";
    private static final String RETURN_HELPER = ".ReturnHelper";
    private static final String IS_ACTION = ".IsAction";
    private static final String PUB_ARG_NAMES = ".ArgNames";
    private static final String PUB_ARG_TYPES = ".ArgTypes";
    private static final String PUB_ARG_HLPRS = ".ArgHelpers";
    private static final String ENUM = "Enum";
    private static final String STRUCT = "Struct";
    private static final String GENERIC = "Generic";
    static IAttributeCmdClassification[] IAttributeCmdClassificationArrayTmpl;
    private URL metadataUrl = null;
    private TypeInfoRepository typeInfoRepository;
    private static Properties metaDataProperties;
    private SDebug db;

    private MetaDataRepository(boolean bl) throws CTCUserException {
        instance = this;
        this.db = new MetaDataRepositoryDebug("MetaDataRep");
        this.loadMetaDataProperties(bl ? this.db : null);
    }

    public static synchronized MetaDataRepository getInstance(boolean bl) throws CTCUserException {
        if (instance == null) {
            return new MetaDataRepository(bl);
        }
        return instance;
    }

    public static MetaDataRepository getInstance() throws CTCUserException {
        return MetaDataRepository.getInstance(true);
    }

    public TypeInfoRepository getTypeInfoRepository() {
        return this.typeInfoRepository;
    }

    public void load(InputStream inputStream) throws FileNotFoundException, IOException {
        metaDataProperties.load(inputStream);
        inputStream.close();
    }

    private void generateCTCUserException(String string) throws CTCUserException {
        throw new CTCUserException("(" + this.metadataUrl + ") " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetaDataProperties(KDebug kDebug) throws CTCUserException {
        boolean bl = true;
        InputStream inputStream = null;
        String string = Preferences.instance().getProperty("ctc", XML_METADATA_FILE_PREF, "");
        this.metadataUrl = null;
        try {
            this.metadataUrl = MetaDataRepository.getMetaDataUrl();
            inputStream = this.metadataUrl.openStream();
            bl = false;
        }
        catch (MalformedURLException malformedURLException) {
            if (kDebug != null) {
                kDebug.println("malformed metadatafile file: " + string);
            } else {
                System.out.println("malformed metadatafile file: " + string);
            }
        }
        catch (IOException iOException) {
            if (kDebug != null) {
                kDebug.println("error reading metadatafile file: " + string);
            } else {
                System.out.println("error reading metadatafile file: " + string);
            }
        }
        finally {
            if (bl) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                inputStream = null;
            }
        }
        if (inputStream == null) {
            this.generateCTCUserException("MetaDataFile Not Found: " + string);
        }
        metaDataProperties = new Properties();
        try {
            this.load(inputStream);
            this.initializeLookup();
            this.loadMethodTypeInfo(kDebug);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new CTCUserException("Unable to load MetaDataFile:" + string + " Reason:" + exception.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            inputStream = null;
        }
    }

    public static URL getMetaDataUrl() {
        URL uRL = null;
        String string = Preferences.instance().getProperty("ctc", XML_METADATA_FILE_PREF, "");
        try {
            if (string == null || string.length() == 0) {
                URLClassLoader uRLClassLoader = (URLClassLoader)MetaDataRepository.class.getClassLoader();
                uRL = uRLClassLoader.getResource(METADATA_RES);
            } else {
                uRL = !string.startsWith("file:") && !string.startsWith("http:") ? new URL("file", "", string.replace('\\', '/')) : new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL exception for MetaData.ini file: " + malformedURLException);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMethodTypeInfo(KDebug kDebug) throws CTCUserException {
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = MetaDataRepository.getTypeInfoUrl();
            inputStream = uRL.openStream();
            this.typeInfoRepository = TypeInfoRepository.createFromXmlStream(inputStream, uRL, kDebug);
            this.typeInfoRepository.addSuperMethodsToSubclasses();
        }
        catch (Exception exception) {
            if (kDebug != null) {
                KDebug.printStackTrace((Throwable)exception);
                throw new CTCUserException("Unable to load TypeInfoFile:" + uRL == null ? "null" : uRL.getPath() + " Reason:" + exception.toString());
            }
            exception.printStackTrace(System.out);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static URL getTypeInfoUrl() {
        return TypeInfoRepository.getTypeInfoUrl();
    }

    public boolean isPublicMethod(String string, String string2, String[] stringArray) throws CTCUserException {
        boolean bl = this.typeInfoRepository != null && this.typeInfoRepository.lookupMethodTypeInfo(string, string2, stringArray, null) != null;
        return bl;
    }

    public boolean isPublicMethodByType(String string, String string2, String[] stringArray) {
        boolean bl = this.typeInfoRepository != null && this.typeInfoRepository.lookupMethodTypeInfoByType(string, string2, stringArray) != null;
        return bl;
    }

    public boolean isPublicMethodByType(String string, String string2, Class[] classArray) {
        int n = classArray == null ? 0 : classArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return this.isPublicMethodByType(string, string2, stringArray);
    }

    public MethodTypeInfo getInfoForPublicMethod(String string, String string2, String[] stringArray) throws CTCUserException {
        String string3;
        String string4;
        MethodTypeInfo methodTypeInfo = null;
        if (this.typeInfoRepository != null && (methodTypeInfo = this.typeInfoRepository.lookupMethodTypeInfo(string, string2, stringArray, null, false)) == null && !string.equals(string4 = this.typeInfoRepository.lookupFullyQualifiedClassName(string3 = MethodTypeInfo.getLastSegment(string)))) {
            methodTypeInfo = this.typeInfoRepository.lookupMethodTypeInfo(string4, string2, stringArray, null, false);
        }
        return methodTypeInfo;
    }

    private static String getKey(Object object) {
        String string = MetaDataRepository.pcvKey(object);
        if (string != null) {
            return string;
        }
        string = object instanceof Method ? MetaDataRepository.getKey((Method)object) : (object instanceof String ? (String)object : object.getClass().getName());
        return string;
    }

    private static String getKey(Method method) {
        String string = method.getDeclaringClass().getName() + "." + method.getName();
        return string;
    }

    private static String[] getArgTypes(Object object) {
        String[] stringArray = null;
        if (object instanceof Method) {
            stringArray = MetaDataRepository.getArgTypes((Method)object);
        }
        return stringArray;
    }

    private static String[] getArgTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray == null ? 0 : classArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public boolean isAction(Object object) throws CTCUserException {
        String string = MetaDataRepository.getKey(object);
        String[] stringArray = MetaDataRepository.getArgTypes(object);
        ISimpleMetaData iSimpleMetaData = null;
        try {
            iSimpleMetaData = stringArray == null ? this.getMetData(string, null) : this.getMetDataByType(string, stringArray);
        }
        catch (CTCUserException cTCUserException) {
            if (this.db.on()) {
                this.db.println("could not find NCV/CV metadata for attribute of type: " + object == null ? "null" : object.getClass().getName());
            }
            return true;
        }
        return iSimpleMetaData == null ? false : iSimpleMetaData.getIsAction();
    }

    public boolean isAction(String string) throws CTCUserException {
        return this.isAction(string, null);
    }

    public boolean isAction(String string, String[] stringArray) throws CTCUserException {
        Object object;
        boolean bl = false;
        if (this.typeInfoRepository != null && (object = this.getMetDataFromTypeInfoRepoByType(string, stringArray)) != null) {
            return object.getIsAction();
        }
        object = metaDataProperties.getProperty(string + IS_ACTION);
        if (object != null) {
            bl = new Boolean(((String)object).trim());
        } else {
            this.generateCTCUserException("MetaData not found for " + string + IS_ACTION);
        }
        return bl;
    }

    public static Properties getMetaDataProperties() {
        return metaDataProperties;
    }

    protected IMethodMetaData getMetDataFromTypeInfoRepo(String string, String[] stringArray) {
        MethodTypeInfo methodTypeInfo = null;
        if (this.typeInfoRepository != null) {
            methodTypeInfo = this.typeInfoRepository.lookupMethodTypeInfo(string, stringArray, null);
        }
        return methodTypeInfo;
    }

    protected IMethodMetaData getMetDataFromTypeInfoRepoByType(String string, String[] stringArray) {
        MethodTypeInfo methodTypeInfo = null;
        if (this.typeInfoRepository != null) {
            methodTypeInfo = this.typeInfoRepository.lookupMethodTypeInfoByType(string, stringArray);
        }
        return methodTypeInfo;
    }

    private static String pcvKey(Object object) {
        PersistableModel persistableModel;
        String string = null;
        if (object instanceof PersistableCachedValue && (persistableModel = ((PersistableCachedValue)object).getPersistableModel()) != null) {
            string = MetaDataRepository.generateKey(persistableModel.getClass().getName(), object.getClass().getName());
        }
        return string;
    }

    public ISimpleMetaData getMetData(Object object) throws CTCUserException {
        String string = MetaDataRepository.pcvKey(object);
        if (string == null && object != null) {
            string = object.getClass().getName();
        }
        return this.getMetData(string, null);
    }

    public ISimpleMetaData getMetData(MethodState methodState) throws CTCUserException {
        return this.getMetData(methodState.toString(), null);
    }

    public ISimpleMetaData getMetData(String string) throws CTCUserException {
        return this.getMetData(string, null);
    }

    public ISimpleMetaData getMetData(String string, String[] stringArray) throws CTCUserException {
        Object object;
        AbstractMetaData abstractMetaData = null;
        if (this.typeInfoRepository != null && (object = this.getMetDataFromTypeInfoRepo(string, stringArray)) != null) {
            return object;
        }
        object = (HashMap)metaDataLookup.get(string);
        if (object != null) {
            abstractMetaData = MetaDataFactory.createMetaData((HashMap)object);
        } else {
            String[] stringArray2 = MetaDataRepository.parseKey(string);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (string2.length() > 0 && string3.length() > 0) {
                try {
                    Class[] classArray = ReflectionUtil.superclasses(string2);
                    for (int i = 0; i < classArray.length; ++i) {
                        String string4 = classArray[i].getName() + string3;
                        object = (HashMap)metaDataLookup.get(string4);
                        if (object == null) continue;
                        abstractMetaData = MetaDataFactory.createMetaData((HashMap)object);
                        metaDataLookup.put(string, object);
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return abstractMetaData;
    }

    public IMethodMetaData getMetDataByType(String string, String[] stringArray) throws CTCUserException {
        MethodTypeInfo methodTypeInfo = null;
        if (this.typeInfoRepository != null) {
            methodTypeInfo = this.typeInfoRepository.lookupMethodTypeInfoByType(string, stringArray);
        }
        return methodTypeInfo;
    }

    private static String[] parseKey(String string) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        int n = string.indexOf("$");
        if (n < 0) {
            n = string.lastIndexOf(".");
        }
        stringArray[0] = string.substring(0, n);
        stringArray[1] = string.substring(n, string.length());
        return stringArray;
    }

    private static String generateKey(String string, String string2) {
        int n;
        String string3 = null;
        int n2 = n = string2 == null ? -1 : string2.indexOf("$");
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(string2.substring(n));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public LinkedList getAttributeNames(String string) {
        if (attributeLookup == null) {
            this.initializeAttributeLookup();
        }
        return (LinkedList)attributeLookup.get(string);
    }

    public static IAttributeCmdClassification[] getCVNCVAttrCmdClassifications() throws ClassNotFoundException {
        LinkedList<AttributeCmdClassification> linkedList = new LinkedList<AttributeCmdClassification>();
        try {
            MetaDataRepository.getInstance(false).removeExcludedProductProperties();
            MetaDataRepository.getInstance(false);
            Enumeration<?> enumeration = MetaDataRepository.getMetaDataProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.endsWith(GET_ARG_NAMES)) continue;
                try {
                    LinkedList linkedList2;
                    String string2 = string.substring(0, string.lastIndexOf(46));
                    MetaData metaData = (MetaData)MetaDataRepository.getInstance().getMetData(string2);
                    AttributeCmdClassification attributeCmdClassification = null;
                    AttributeCmdClassification attributeCmdClassification2 = null;
                    if (!metaData.getGETArgNames()[0].equals(NO_PERMISSION)) {
                        attributeCmdClassification = new AttributeCmdClassification();
                    }
                    if (!metaData.getSETArgNames()[0].equals(NO_PERMISSION)) {
                        attributeCmdClassification2 = new AttributeCmdClassification();
                    }
                    if (attributeCmdClassification == null && attributeCmdClassification2 == null) continue;
                    String string3 = string2.substring(0, string2.indexOf(36));
                    String string4 = string2.substring(string2.lastIndexOf(46) + 1, string2.indexOf(36));
                    String string5 = string2.substring(string2.lastIndexOf(36) + 1);
                    if (attributeCmdClassification != null) {
                        attributeCmdClassification.setModelName(string4);
                        attributeCmdClassification.setAttributeName(string5);
                        attributeCmdClassification.setCmdName("get" + string5);
                        attributeCmdClassification.setParameterNames(metaData.getGETArgNames());
                        attributeCmdClassification.setParameterTypes(ReflectionUtil.forName(metaData.getGETRealArgTypes()));
                        attributeCmdClassification.setExcludedProducts(metaData.getProductExclusions());
                        attributeCmdClassification.setAction(metaData.getIsAction());
                        if (metaData.getGETArgNames()[0].equals("NO_ARGUMENTS")) {
                            attributeCmdClassification.setCmdClassification(0);
                        } else {
                            attributeCmdClassification.setCmdClassification(2);
                        }
                        linkedList.add(attributeCmdClassification);
                    }
                    if (attributeCmdClassification2 != null) {
                        attributeCmdClassification2.setModelName(string4);
                        attributeCmdClassification2.setAttributeName(string5);
                        attributeCmdClassification2.setCmdName("set" + string5);
                        attributeCmdClassification2.setParameterNames(metaData.getSETArgNames());
                        attributeCmdClassification2.setParameterTypes(ReflectionUtil.forName(metaData.getSETRealArgTypes()));
                        attributeCmdClassification2.setExcludedProducts(metaData.getProductExclusions());
                        if (metaData.getSETArgNames().length == 1 && !metaData.getSETArgNames()[0].equals("NO_ARGUMENTS")) {
                            attributeCmdClassification2.setCmdClassification(1);
                        } else {
                            attributeCmdClassification2.setCmdClassification(2);
                        }
                        linkedList.add(attributeCmdClassification2);
                    }
                    if (attributeCmdClassification != null && attributeCmdClassification2 != null && MetaDataRepository.isBeanPattern(metaData)) {
                        attributeCmdClassification.setCounterpart(attributeCmdClassification2);
                    }
                    if ((linkedList2 = (LinkedList)ReflectionUtil.subclasses(string3)) == null || linkedList2.size() <= 0) continue;
                    ListIterator listIterator = linkedList2.listIterator();
                    while (listIterator.hasNext()) {
                        AttributeCmdClassification attributeCmdClassification3;
                        String string6 = (String)listIterator.next();
                        string6 = string6.substring(string6.lastIndexOf(46) + 1);
                        if (attributeCmdClassification != null) {
                            attributeCmdClassification3 = (AttributeCmdClassification)attributeCmdClassification.clone();
                            attributeCmdClassification3.setModelName(string6);
                            linkedList.add(attributeCmdClassification3);
                        }
                        if (attributeCmdClassification2 == null) continue;
                        attributeCmdClassification3 = (AttributeCmdClassification)attributeCmdClassification2.clone();
                        attributeCmdClassification3.setModelName(string6);
                        linkedList.add(attributeCmdClassification3);
                    }
                }
                catch (CTCUserException cTCUserException) {
                    cTCUserException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList.toArray(IAttributeCmdClassification.ArrayTemplate);
    }

    private static boolean isBeanPattern(MetaData metaData) {
        boolean bl = false;
        if (metaData.getGETArgNames().length == 1 && metaData.getGETArgNames()[0].equals("NO_ARGUMENTS") && metaData.getSETArgNames().length == 1 && metaData.getReturnHelper().equals(metaData.getSETArgHelpers()[0])) {
            if (metaData.getReturnType().length() > 0) {
                if (metaData.getReturnType().equals(metaData.getSETArgTypes()[0])) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void removeExcludedProductProperties() {
        Enumeration<?> enumeration = metaDataProperties.propertyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, n = string.lastIndexOf(46)) + "." + "ExcludedProducts";
            String string3 = metaDataProperties.getProperty(string2);
            String[] stringArray = AbstractSimpleMetaData.getMetaDataDef(string3);
            if (!AbstractSimpleMetaData.isProductExcluded(stringArray)) continue;
            arrayList.add(string);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            metaDataProperties.remove(arrayList.get(i));
        }
    }

    private void initializeLookup() {
        this.removeExcludedProductProperties();
        metaDataLookup = new HashMap();
        Enumeration<?> enumeration = metaDataProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            HashMap hashMap;
            String string = (String)enumeration.nextElement();
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = string.lastIndexOf(46);
            if (n <= 0) continue;
            String string2 = stringBuilder.substring(0, n);
            String string3 = string;
            String string4 = metaDataProperties.getProperty(string);
            if (!metaDataLookup.containsKey(string2)) {
                hashMap = new HashMap();
                hashMap.put(string3, string4);
                metaDataLookup.put(string2, hashMap);
                continue;
            }
            hashMap = (HashMap)metaDataLookup.get(string2);
            hashMap.put(string3, string4);
        }
    }

    private void initializeAttributeLookup() {
        this.removeExcludedProductProperties();
        attributeLookup = new HashMap();
        Enumeration<?> enumeration = metaDataProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            LinkedList linkedList;
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(GET_ARG_NAMES)) continue;
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = string.indexOf(36);
            int n2 = string.lastIndexOf(46);
            if (n <= 0 || n2 <= 0) continue;
            String string2 = stringBuilder.substring(0, n);
            String string3 = stringBuilder.substring(0, n2);
            if (!attributeLookup.containsKey(string2)) {
                linkedList = new LinkedList();
                linkedList.add(string3);
                attributeLookup.put(string2, linkedList);
                continue;
            }
            linkedList = (LinkedList)attributeLookup.get(string2);
            linkedList.add(string3);
        }
    }

    public static IAttributeCmdClassification[] getAttrCmdClassifications(String string) throws CTCUserException, ClassNotFoundException {
        boolean bl = true;
        LinkedList linkedList = new LinkedList();
        IAttributeCmdClassification[] iAttributeCmdClassificationArray = MetaDataRepository.getCVNCVAttrCmdClassifications();
        MetaDataRepository.addAttrCmdClassifications(linkedList, iAttributeCmdClassificationArray, string);
        IAttributeCmdClassification[] iAttributeCmdClassificationArray2 = MetaDataRepository.getPublicMethodAttrCmdClassifications(bl);
        MetaDataRepository.addAttrCmdClassifications(linkedList, iAttributeCmdClassificationArray2, string);
        MetaDataRepository.addModelGetCmdClassifications(linkedList);
        IAttributeCmdClassification[] iAttributeCmdClassificationArray3 = linkedList.toArray(IAttributeCmdClassificationArrayTmpl);
        return iAttributeCmdClassificationArray3;
    }

    static void addAttrCmdClassifications(List list, IAttributeCmdClassification[] iAttributeCmdClassificationArray, String string) {
        if (string != null) {
            string = MethodTypeInfo.getLastSegment(string);
        }
        if (iAttributeCmdClassificationArray != null) {
            for (IAttributeCmdClassification iAttributeCmdClassification : iAttributeCmdClassificationArray) {
                if (string != null && !string.equals(iAttributeCmdClassification.getModelName())) continue;
                list.add(iAttributeCmdClassification);
            }
        }
    }

    static void addModelGetCmdClassifications(List list) {
        Iterator iterator = list.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            IAttributeCmdClassification iAttributeCmdClassification = (IAttributeCmdClassification)iterator.next();
            String string = iAttributeCmdClassification.getModelName();
            hashSet.add(string);
        }
        for (String string : hashSet) {
            list.add(MetaDataRepository.createModelAttributeClassification(string));
        }
    }

    static IAttributeCmdClassification createModelAttributeClassification(String string) {
        AttributeCmdClassification attributeCmdClassification = new AttributeCmdClassification(string, string, "get" + string, StringArrayTemplate, ClassArrayTemplate, 3, false, null, null, true);
        return attributeCmdClassification;
    }

    public static IAttributeCmdClassification[] getPublicMethodAttrCmdClassifications(boolean bl) throws CTCUserException {
        MetaDataRepository metaDataRepository = MetaDataRepository.getInstance(false);
        TypeInfoRepository typeInfoRepository = metaDataRepository.typeInfoRepository;
        IAttributeCmdClassification[] iAttributeCmdClassificationArray = typeInfoRepository.getAttrCmdClassifications(bl);
        return iAttributeCmdClassificationArray;
    }

    static Set getModelClassnames(boolean bl) throws CTCUserException {
        MetaDataRepository metaDataRepository = MetaDataRepository.getInstance(false);
        TypeInfoRepository typeInfoRepository = metaDataRepository.typeInfoRepository;
        if (typeInfoRepository == null) {
            return new HashSet();
        }
        Set set = typeInfoRepository.getClassNames(bl);
        Set set2 = metaDataLookup.keySet();
        for (String string : set2) {
            int n = string.indexOf("$");
            string = string.substring(0, n);
            string = bl ? string : MethodTypeInfo.getLastSegment(string);
            set.add(string);
        }
        return set;
    }

    public static Set getModelClassnamesSet() throws CTCUserException {
        return MetaDataRepository.getModelClassnames(false);
    }

    public static String[] getModelClassnames() throws CTCUserException {
        Set set = MetaDataRepository.getModelClassnames(false);
        return set.toArray(ISimpleMetaData.StringArrayTemplate);
    }

    public static String[] getFullyQualifiedModelClassnames() throws CTCUserException {
        Set set = MetaDataRepository.getModelClassnames(true);
        return set.toArray(ISimpleMetaData.StringArrayTemplate);
    }

    static {
        attributeLookup = null;
        metaDataLookup = null;
        IAttributeCmdClassificationArrayTmpl = new IAttributeCmdClassification[0];
    }

    public final class MetaDataRepositoryDebug
    extends SDebug {
        MetaDataRepositoryDebug(String string) {
            super(string);
        }

        public final void reload() {
            try {
                MetaDataRepository.getInstance().loadMetaDataProperties(this);
            }
            catch (CTCUserException cTCUserException) {
                MetaDataRepository.this.db.println(cTCUserException.toString());
            }
        }

        public final void dumpSysOut() {
            this.println("Printing to System.out:");
            metaDataProperties.list(System.out);
        }

        public final void dump() {
            this.dumpGeneral();
            TreeSet treeSet = new TreeSet();
            Enumeration<?> enumeration = metaDataProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                treeSet.add(enumeration.nextElement());
            }
            for (String string : treeSet) {
                String string2 = metaDataProperties.getProperty(string);
                MetaDataRepository.this.db.println(string + "=" + string2);
            }
        }

        public final void dumpTypeInfo() {
            this.dumpGeneral();
            try {
                this.println("*****************");
                TypeInfoRepository typeInfoRepository = MetaDataRepository.getInstance().typeInfoRepository;
                if (typeInfoRepository == null) {
                    this.println("typeInfoRepository is null");
                } else {
                    typeInfoRepository.dump(this);
                    typeInfoRepository.print((KDebug)this, true, false);
                }
            }
            catch (Exception exception) {
                this.println("dump encountered exception: " + exception.getMessage());
            }
        }

        void dumpGeneral() {
            this.println("Loader NE type: " + AbstractSimpleMetaData.LoaderNeType);
        }

        public final void lookupMethodTypeInfo(String string, String string2) {
            try {
                MethodTypeInfo methodTypeInfo;
                String[] stringArray;
                TypeInfoRepository typeInfoRepository = MetaDataRepository.getInstance().typeInfoRepository;
                if (typeInfoRepository == null) {
                    this.println("typeInfoRepository is null");
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!string2.equals("-")) {
                    stringArray = new StringTokenizer(string2, MetaDataRepository.DELIMITER);
                    while (stringArray.hasMoreTokens()) {
                        arrayList.add(stringArray.nextToken());
                    }
                }
                if ((methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string, stringArray = arrayList.toArray(StringArrayTemplate), null)) == null) {
                    this.println("lookup result: null");
                } else {
                    this.println("lookup result: " + methodTypeInfo.signatureString(true, false));
                    this.println("action: " + methodTypeInfo.getIsAction());
                }
            }
            catch (Exception exception) {
                this.println("lookupMethodTypeInfo encountered exception: " + exception.getMessage());
            }
        }

        public final void getAttrCmdClassifications() {
            AttributeCmdClassification.Comparator comparator = AttributeCmdClassification.comparator;
            try {
                MetaDataRepository.getInstance();
                IAttributeCmdClassification[] iAttributeCmdClassificationArray = MetaDataRepository.getAttrCmdClassifications(null);
                Object[] objectArray = iAttributeCmdClassificationArray;
                Arrays.sort(objectArray, comparator);
                for (int i = 0; i < iAttributeCmdClassificationArray.length; ++i) {
                    if (iAttributeCmdClassificationArray[i] == null) {
                        System.out.println("null at " + i);
                    }
                    System.out.println(iAttributeCmdClassificationArray[i].toString());
                }
            }
            catch (Exception exception) {
                System.out.println("getAttrCmdClassifications failed");
                exception.printStackTrace();
            }
        }

        public final void printValues(String string) {
            this.println(string + MetaDataRepository.GET_ARG_NAMES + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_NAMES));
            this.println(string + MetaDataRepository.GET_ARG_TYPES + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_TYPES));
            this.println(string + MetaDataRepository.GET_ARG_HELPERS + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_HELPERS));
            this.println(string + MetaDataRepository.SET_ARG_NAMES + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_NAMES));
            this.println(string + MetaDataRepository.SET_ARG_TYPES + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_TYPES));
            this.println(string + MetaDataRepository.SET_ARG_HELPERS + "=" + metaDataProperties.getProperty(string + MetaDataRepository.GET_ARG_HELPERS));
            this.println(string + MetaDataRepository.RETURN_HELPER + "=" + metaDataProperties.getProperty(string + MetaDataRepository.RETURN_HELPER));
            this.println(string + MetaDataRepository.IS_ACTION + "=" + metaDataProperties.getProperty(string + MetaDataRepository.IS_ACTION));
        }
    }
}

