/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.util.SDebug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaseObjectHelper {
    public static final SDebug db = new SDebug("BaseObjectHelper", false);

    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        if (db.on()) {
            db.println("[BaseObjectHelper]Coverting objectToXml in " + string + ": Object=" + object);
        }
        Element element = null;
        boolean bl = true;
        if (object != null) {
            element = XmlNodeFactory.makeElement(node, string, BaseObjectHelper.objectToString(object, string));
        }
        return element;
    }

    static boolean doOutputValueInHex(String string) {
        return false;
    }

    static String objectToString(Object object, String string) throws CTCUserException {
        if (object instanceof Number) {
            if (object instanceof Long) {
                return BaseObjectHelper.integerToString((Long)object, string);
            }
            if (object instanceof Integer) {
                return BaseObjectHelper.integerToString((Integer)object, string);
            }
            if (object instanceof Short) {
                return BaseObjectHelper.integerToString(((Short)object).shortValue(), string);
            }
            if (object instanceof Byte) {
                return BaseObjectHelper.integerToString(((Byte)object).byteValue(), string);
            }
            if (object instanceof Float) {
                return Float.toString(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return Double.toString((Double)object);
            }
            throw new CTCUserException("(" + object.getClass().getName() + ") unknown numeric type for tag: " + string);
        }
        return object.toString();
    }

    public static String integerToString(Integer n, String string) {
        return BaseObjectHelper.integerToString((int)n, string);
    }

    public static String integerToString(int n, String string) {
        if (BaseObjectHelper.doOutputValueInHex(string)) {
            return "0x" + Integer.toHexString(n);
        }
        return Integer.toString(n);
    }

    public static String integerToString(Long l, String string) {
        return BaseObjectHelper.integerToString((long)l, string);
    }

    public static String integerToString(long l, String string) {
        if (BaseObjectHelper.doOutputValueInHex(string)) {
            return Long.toHexString(l);
        }
        return Long.toString(l);
    }

    public static boolean requiresMetadata() {
        return false;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(string));
        stringBuilder.append(SchemaTagFactory.createEmptyTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }
}

