/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.IDisposable;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowActionListener;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import cerent.util.gui.row.SortDirectionIconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableRowTableModel
extends RowTableModel
implements MouseListener,
Comparator,
ActionListener,
RowActionListener {
    protected JTable table = null;
    protected JTableHeader th;
    protected int[] sortCols;
    protected boolean[] sortDir;
    protected int nbSortCols = 0;
    protected ArrayList sortedObjects;
    protected TreeSet sorter;
    private MouseListener tableRowMouseListener;
    protected static final String TH_TOOLTIP = "Click to sort(asc/desc), Shift click for incremental sort, right click for more options";
    private static final String CANCEL_SORT = "Reset Sorting";
    private static final String COL_SORT = "Sort Column";
    private static final String COL_INC_SORT = "Sort Column (incremental)";
    private static final String COL_HIDE = "Hide Column";
    private static final String COL_SHOW = "Show Column";
    private static final String COL_RESET = "Reset Columns Order/Visibility";
    private static final String COL_DEFAULT = "Use Default Columns Order/Visibility";
    protected JPopupMenu popup;
    private JMenuItem miCancel = new JMenuItem("Reset Sorting");
    private JMenuItem miSortCol = new JMenuItem("Sort Column");
    private JMenuItem miIncSortCol = new JMenuItem("Sort Column (incremental)");
    private JMenuItem miHideCol = new JMenuItem("Hide Column");
    private JMenuItem miResetCol = new JMenuItem("Reset Columns Order/Visibility");
    private JMenuItem miDefault = new JMenuItem("Use Default Columns Order/Visibility");
    private JMenuItem miInfo = new JMenuItem();
    private ArrayList hiddenColumns = new ArrayList();
    private JMenu showColMenu = new JMenu("Show Column");
    private TableHdrRenderer hr;
    private int[] defaultSortCols;
    private boolean[] defaultSortDir;
    private int defaultNbSortCols = 0;
    private String[] defaultHideCols;
    private static final SDebug db = new SDebug("SortableRowTableModel");
    private long popupTimestamp = 0L;
    private int popupColumn = -1;
    private TableColumn popupTableColumn;

    public SortableRowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
        super(rowDataSource, columnRendererArray, clazz);
        this.init(columnRendererArray.length);
    }

    public SortableRowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz, int[] nArray, boolean[] blArray) {
        super(rowDataSource, columnRendererArray, clazz);
        this.init(columnRendererArray.length);
        this.nbSortCols = nArray.length > columnRendererArray.length ? columnRendererArray.length : nArray.length;
        for (int i = 0; i < this.nbSortCols; ++i) {
            this.sortCols[i] = nArray[i];
            this.sortDir[i] = blArray[i];
        }
    }

    private void init(int n) {
        this.sortCols = new int[n];
        this.sortDir = new boolean[n];
        this.sortedObjects = new ArrayList();
        this.sorter = new TreeSet(this);
        this.popup = new JPopupMenu();
        this.addPopup(this.popup, this.miCancel);
        this.addPopup(this.popup, this.miSortCol);
        this.addPopup(this.popup, this.miIncSortCol);
        this.popup.addSeparator();
        this.addPopup(this.popup, this.miHideCol);
        this.popup.add(this.showColMenu);
        this.addPopup(this.popup, this.miDefault);
        this.miDefault.setEnabled(false);
        this.addPopup(this.popup, this.miResetCol);
        this.popup.addSeparator();
        this.popup.add(this.miInfo);
    }

    public SortableRowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray) {
        this(rowDataSource, columnRendererArray, rowDataSource.getRowObjectClass());
    }

    private static boolean[] defaultSortDirArray(int n, boolean bl) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = bl;
        }
        return blArray;
    }

    public SortableRowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, int[] nArray) {
        this(rowDataSource, columnRendererArray, rowDataSource.getRowObjectClass(), nArray, SortableRowTableModel.defaultSortDirArray(nArray == null ? 0 : nArray.length, true));
    }

    private void addPopup(JPopupMenu jPopupMenu, JMenuItem jMenuItem) {
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
    }

    public void initTable(final JTable jTable) {
        Serializable serializable;
        int n;
        super.initTable(jTable);
        this.syncSortedCols();
        if (this.table == null) {
            this.table = jTable;
            this.th = jTable.getTableHeader();
            this.th.addMouseListener(this);
            if (this.doesHandleRowPopups()) {
                this.tableRowMouseListener = new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            this.handlePopup(mouseEvent);
                        }
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            this.handlePopup(mouseEvent);
                        }
                    }

                    private void handlePopup(MouseEvent mouseEvent) {
                        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                        int n = jTable.rowAtPoint(point);
                        SortableRowTableModel.this.handleRowPopup(mouseEvent, n);
                    }
                };
                jTable.addMouseListener(this.tableRowMouseListener);
            }
            this.th.setToolTipText(TH_TOOLTIP);
        }
        for (n = 0; n < this.colModel.getColumnCount(); ++n) {
            serializable = this.colModel.getColumn(n);
            this.hr = new TableHdrRenderer();
            this.hr.setHorizontalTextPosition(2);
            this.hr.setBorder((Border)UIManager.get("TableHeader.cellBorder"));
            this.hr.setHorizontalAlignment(0);
            this.hr.setOpaque(true);
            this.hr.setBackground((Color)UIManager.get("TableHeader.background"));
            ((TableColumn)serializable).setHeaderRenderer(this.hr);
        }
        this.hiddenColumns.clear();
        for (n = 0; n < this.showColMenu.getItemCount(); ++n) {
            serializable = this.showColMenu.getItem(n);
            ((AbstractButton)serializable).removeActionListener(this);
        }
        this.showColMenu.removeAll();
        jTable.sizeColumnsToFit(-1);
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (this.nbSortCols == 0) {
                return this.source.getObjectAtRow(n);
            }
            return this.sortedObjects.get(n);
        }
        catch (Exception exception) {
            db.severe("getValueAt( " + n + "," + n2 + ") " + exception.toString());
            return null;
        }
    }

    public synchronized <E> List<E> getValuesAt(int[] nArray, Class<E> clazz) {
        int n = nArray == null ? 0 : nArray.length;
        ArrayList<E> arrayList = new ArrayList<E>(n);
        for (int n2 : nArray) {
            Object object = this.getValueAt(n2, 0);
            try {
                E e = clazz.cast(object);
                arrayList.add(e);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.nbSortCols == 0) {
            super.setValueAt(object, n, n2);
        } else if (this.source != null) {
            Object e = this.sortedObjects.get(n);
            int n3 = this.source.findSame(e);
            if (n3 < 0) {
                return;
            }
            boolean bl = e == this.getCurrentSelectionRowObject();
            Object object2 = this.clone(e);
            if (object2 != null) {
                this.setColumnValue(object2, n2, object);
                if (e instanceof IDisposable && object2 != e) {
                    ((IDisposable)e).dispose();
                }
                int n4 = this.source.setObjectAtRow(n3, object2);
                if (bl) {
                    int n5;
                    this.makeSelectedRow(object2, n5, (n5 = this.findSame(object2)) < 0 ? n5 : n5 + 1);
                }
            }
        }
    }

    public void remove(int[] nArray) {
        if (this.nbSortCols == 0) {
            super.remove(nArray);
        } else if (this.source != null && nArray != null && nArray.length > 0) {
            int[] nArray2 = this.getSourceRows(nArray);
            super.remove(nArray2);
        }
    }

    private int[] getSourceRows(int[] nArray) {
        Object object;
        int n = nArray.length;
        int[] nArray2 = new int[n];
        IdentityHashMap identityHashMap = new IdentityHashMap(n);
        for (int n2 : nArray) {
            object = this.sortedObjects.get(n2);
            identityHashMap.put(object, object);
        }
        int n3 = 0;
        int n4 = this.source.getRowCount();
        for (int i = 0; i < n4 && n3 < n; ++i) {
            Object object2 = this.source.getObjectAtRow(i);
            object = identityHashMap.get(object2);
            if (object == null) continue;
            nArray2[n3++] = i;
        }
        return nArray2;
    }

    public void release() {
        super.release();
        if (this.th != null) {
            this.th.removeMouseListener(this);
        }
        if (null != this.miCancel) {
            this.miCancel.removeActionListener(this);
        }
        if (null != this.miSortCol) {
            this.miSortCol.removeActionListener(this);
        }
        if (null != this.miIncSortCol) {
            this.miIncSortCol.removeActionListener(this);
        }
        if (null != this.miHideCol) {
            this.miHideCol.removeActionListener(this);
        }
        if (null != this.miResetCol) {
            this.miResetCol.removeActionListener(this);
        }
        if (null != this.miDefault) {
            this.miDefault.removeActionListener(this);
        }
        if (null != this.popup) {
            this.popup.removeAll();
            this.popup = null;
        }
        this.hr = null;
        for (int i = 0; i < this.showColMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.showColMenu.getItem(i);
            if (null == jMenuItem) continue;
            jMenuItem.removeActionListener(this);
        }
        if (null != this.showColMenu) {
            this.showColMenu.removeAll();
        }
    }

    public void setDataSource(RowDataSource rowDataSource) {
        this.removeIcons();
        this.nbSortCols = 0;
        if (this.table != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SortableRowTableModel.this.table.getTableHeader().repaint();
                }
            });
        }
        super.setDataSource(rowDataSource);
    }

    public synchronized void rowsAdded(int n, int n2) {
        if (this.nbSortCols == 0) {
            super.rowsAdded(n, n2);
        } else {
            for (int i = n; i <= n2; ++i) {
                Object object = this.source.getObjectAtRow(i);
                int n3 = this.getInsertionIndex(object);
                this.sortedObjects.add(n3, object);
                this.fireTableRowsInserted(n3, n3);
            }
        }
    }

    public synchronized void rowsDeleted(int n, int n2) {
        if (this.nbSortCols == 0) {
            super.rowsDeleted(n, n2);
        } else {
            Collection collection = this.source.getAllObjects();
            if (collection != null) {
                this.sorter.clear();
                this.sorter.addAll(collection);
            }
            this.sortedObjects.clear();
            this.sortedObjects.addAll(this.sorter);
            this.sorter.clear();
            this.fireTableDataChanged();
        }
    }

    public synchronized void rowsUpdated(int n, int n2) {
        if (this.nbSortCols == 0) {
            super.rowsUpdated(n, n2);
        } else {
            Object object = this.getCurrentSelectionRowObject();
            boolean bl = false;
            int n3 = -1;
            int n4 = 0;
            for (int i = n; i <= n2; ++i) {
                int n5;
                Object object2 = this.source.getObjectAtRow(i);
                bl |= object != null && object == object2;
                for (n5 = 0; n5 < this.sortedObjects.size(); ++n5) {
                    if (this.sortedObjects.get(n5) != object2) continue;
                    this.sortedObjects.remove(n5);
                    break;
                }
                int n6 = this.getInsertionIndex(object2);
                this.sortedObjects.add(n6, object2);
                if (n6 > n5) {
                    if (n3 == -1) {
                        n3 = n5;
                        n4 = n6;
                        continue;
                    }
                    if (n5 < n3) {
                        n3 = n5;
                    }
                    if (n6 <= n4) continue;
                    n4 = n6;
                    continue;
                }
                if (n3 == -1) {
                    n3 = n6;
                    n4 = n5;
                    continue;
                }
                if (n6 < n3) {
                    n3 = n6;
                }
                if (n5 <= n4) continue;
                n4 = n5;
            }
            if (bl) {
                this.makeSelectedRow(object, n3, n4);
            }
            this.fireTableRowsUpdated(n3, n4);
        }
    }

    public void dataSourceChanged() {
        try {
            if (this.nbSortCols == 0) {
                super.dataSourceChanged();
            } else {
                Object object = this.getCurrentSelectionRowObject();
                this.sortColumns(object);
            }
        }
        catch (Exception exception) {
            db.severe(exception.toString());
        }
    }

    public synchronized void dataStructureChanged() {
        this.dataSourceChanged();
        this.fireTableStructureChanged();
    }

    public synchronized void bulkRowAdd(Object object) {
        int n = this.getInsertionIndex(object);
        this.sortedObjects.add(n, object);
        this.updateLogic.rowAdded(n);
    }

    public synchronized void bulkRowAdded(int n, Object object) {
        if (this.nbSortCols == 0) {
            super.bulkRowAdded(n, object);
        } else {
            this.bulkRowAdd(object);
        }
    }

    private synchronized void bulkRowDelete(Object object) {
        for (int i = 0; i < this.sortedObjects.size(); ++i) {
            if (this.sortedObjects.get(i) != object) continue;
            this.sortedObjects.remove(i);
            this.updateLogic.rowRemoved(i);
            break;
        }
    }

    public synchronized void bulkRowDeleted(int n, Object object) {
        if (this.nbSortCols == 0) {
            super.bulkRowDeleted(n, object);
        } else {
            this.bulkRowDelete(object);
        }
    }

    public synchronized void bulkRowUpdated(int n, Object object, Object object2) {
        if (this.nbSortCols == 0) {
            super.bulkRowUpdated(n, object, object2);
        } else {
            this.bulkRowDelete(object);
            this.bulkRowAdd(object2);
        }
    }

    public synchronized void bulkUpdateView() {
        if (this.updateLogic.hasTableDataChanged()) {
            this.dataSourceChanged();
        } else {
            this.updateLogic.updateView((AbstractTableModel)((Object)this));
        }
    }

    protected boolean doesHandleRowPopups() {
        return false;
    }

    protected void handleRowPopup(MouseEvent mouseEvent, int n) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getWhen() == this.popupTimestamp) {
            return;
        }
        int n = this.colModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.table.convertColumnIndexToModel(n);
        if (mouseEvent.getClickCount() == 1 && n2 != -1) {
            int n3 = mouseEvent.getModifiers() & 1;
            this.sortColumns(n2, n3 != 0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    private boolean incSortEnabled(int n) {
        if (this.nbSortCols == 0) {
            return false;
        }
        for (int i = 0; i < this.nbSortCols - 1; ++i) {
            if (this.sortCols[i] != n) continue;
            return false;
        }
        return true;
    }

    private synchronized void syncSortedCols() {
        int[] nArray = new int[this.sortCols.length];
        boolean[] blArray = new boolean[this.sortCols.length];
        int n = this.colModel.getColumnCount();
        int n2 = 0;
        this.removeIcons();
        for (int i = 0; i < this.nbSortCols; ++i) {
            if (this.sortCols[i] >= n) continue;
            nArray[n2] = this.sortCols[i];
            blArray[n2] = this.sortDir[i];
            this.setIcon(this.sortCols[i], this.sortDir[i]);
            ++n2;
        }
        this.sortCols = nArray;
        this.sortDir = blArray;
        this.nbSortCols = n2;
    }

    protected void showPopup(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int n = this.colModel.getColumnIndexAtX(mouseEvent.getX());
        if (n == -1) {
            this.popupColumn = -1;
        } else {
            this.popupColumn = this.table.convertColumnIndexToModel(n);
            this.popupTableColumn = this.colModel.getColumn(n);
        }
        this.miCancel.setEnabled(this.nbSortCols > 0);
        this.miSortCol.setEnabled(this.popupColumn != -1);
        this.miIncSortCol.setEnabled(this.popupColumn != -1 && this.incSortEnabled(this.popupColumn));
        this.miHideCol.setEnabled(this.popupColumn != -1 && this.colModel.getColumnCount() > 1);
        this.showColMenu.setEnabled(this.hiddenColumns.size() > 0);
        this.miInfo.setText("Row count=" + this.source.getRowCount());
        if (this.popupColumn != -1) {
            boolean bl = this.nbSortCols == 1 && this.sortCols[0] == this.popupColumn ? !this.sortDir[0] : true;
            this.miSortCol.setIcon(this.getDirectionIcon(bl));
            bl = this.nbSortCols > 0 && this.sortCols[this.nbSortCols - 1] == this.popupColumn ? !this.sortDir[this.nbSortCols - 1] : true;
            this.miIncSortCol.setIcon(this.getDirectionIcon(bl));
        }
        this.popup.show(this.table.getTableHeader(), mouseEvent.getX(), mouseEvent.getY());
        this.popupTimestamp = mouseEvent.getWhen();
    }

    private Object getCurrentSelectionRowObject() {
        int n = this.table.getSelectedRow();
        if (n >= 0 && n < this.getRowCount()) {
            return this.getValueAt(n, 0);
        }
        return null;
    }

    private synchronized void sortColumns(int n, boolean bl) {
        try {
            Object object = this.getCurrentSelectionRowObject();
            if (bl && this.incSortEnabled(n)) {
                this.addSortCol(n);
            } else {
                this.setSortCol(n);
            }
            this.sortColumns(object);
        }
        catch (Exception exception) {
            db.severe(exception.toString());
        }
    }

    private synchronized void sortColumns(Object object) {
        Collection collection = this.source.getAllObjects();
        if (collection != null) {
            this.sorter.addAll(collection);
        }
        this.sortedObjects.clear();
        this.sortedObjects.addAll(this.sorter);
        this.sorter.clear();
        this.fireTableDataChanged();
        this.removeIcons();
        for (int i = 0; i < this.nbSortCols; ++i) {
            this.setIcon(this.sortCols[i], this.sortDir[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SortableRowTableModel.this.table.getTableHeader().repaint();
            }
        });
        this.makeSelectedRow(object);
    }

    public synchronized void setSelectedRow(Object object) {
        this.makeSelectedRow(object);
    }

    protected void makeSelectedRow(Object object) {
        this.makeSelectedRow(object, 0, Integer.MAX_VALUE);
    }

    protected void makeSelectedRow(Object object, int n, int n2) {
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (object != null) {
            int n3 = Math.max(0, n);
            int n4 = Math.min(this.getRowCount(), n2);
            for (int i = n3; i < n4; ++i) {
                if (object != this.getValueAt(i, 0)) continue;
                this.table.setRowSelectionInterval(i, i);
                final Rectangle rectangle = this.table.getCellRect(i, 0, true);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SortableRowTableModel.this.table.scrollRectToVisible(rectangle);
                    }
                });
                break;
            }
        }
    }

    protected int findSame(Object object) {
        int n;
        Object e;
        int n2;
        int n3;
        if (object == null) {
            return -1;
        }
        for (n3 = n2 = this.getInsertionIndex(object); n3 >= 0; --n3) {
            e = this.sortedObjects.get(n3);
            if (object == e) {
                return n3;
            }
            n = this.shuttleSortCompare(object, e);
            if (n < 0) break;
        }
        int n4 = this.sortedObjects.size();
        for (n3 = n2 + 1; n3 < n4; ++n3) {
            e = this.sortedObjects.get(n3);
            if (object == e) {
                return n3;
            }
            n = this.shuttleSortCompare(object, e);
            if (n > 0) break;
        }
        return -1;
    }

    protected int getInsertionIndex(Object object) {
        int n;
        block5: {
            int n2;
            n = 0;
            int n3 = 0;
            int n4 = this.sortedObjects.size();
            if (n4 == 0) {
                return 0;
            }
            while (true) {
                Object e;
                int n5;
                if ((n5 = this.shuttleSortCompare(object, e = this.sortedObjects.get(n2 = n3 + (n4 - n3) / 2))) < 0) {
                    if (n3 == n2) {
                        n = n3;
                        break block5;
                    }
                    n4 = n2;
                    continue;
                }
                if (n5 <= 0) break;
                if (n2 + 1 == n4) {
                    n = n4;
                    break block5;
                }
                n3 = n2;
            }
            n = n2;
        }
        return n;
    }

    private void setSortCol(int n) {
        if (this.nbSortCols == 1 && this.sortCols[0] == n) {
            this.sortDir[0] = !this.sortDir[0];
        } else {
            this.removeIcons();
            this.sortCols[0] = n;
            this.nbSortCols = 1;
            this.sortDir[0] = true;
        }
        this.setIcon(n, this.sortDir[this.nbSortCols - 1]);
    }

    private void addSortCol(int n) {
        if (this.sortCols[this.nbSortCols - 1] == n) {
            this.sortDir[this.nbSortCols - 1] = !this.sortDir[this.nbSortCols - 1];
        } else {
            this.sortCols[this.nbSortCols] = n;
            this.sortDir[this.nbSortCols] = true;
            ++this.nbSortCols;
        }
    }

    private void removeIcons() {
        try {
            for (int i = 0; i < this.nbSortCols; ++i) {
                int n = this.table.convertColumnIndexToView(this.sortCols[i]);
                TableColumn tableColumn = this.colModel.getColumn(n);
                JLabel jLabel = (JLabel)((Object)tableColumn.getHeaderRenderer());
                WindowHelper.setLabelIcon((JLabel)jLabel, null);
            }
        }
        catch (Exception exception) {
            db.finer("exception in removeIcons: table not ready yet? " + exception);
        }
    }

    private void setIcon(int n, boolean bl) {
        try {
            TableColumn tableColumn = this.colModel.getColumn(this.table.convertColumnIndexToView(n));
            JLabel jLabel = (JLabel)((Object)tableColumn.getHeaderRenderer());
            WindowHelper.setLabelIcon((JLabel)jLabel, (Icon)this.getDirectionIcon(bl));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Icon getDirectionIcon(boolean bl) {
        return SortDirectionIconFactory.getIcon((!bl ? 1 : 0) != 0);
    }

    public int compare(Object object, Object object2) {
        int n = 0;
        for (int i = 0; i < this.nbSortCols; ++i) {
            n = this.getColumnRenderer(this.sortCols[i]).compareColumn(object, object2, this.sortCols[i]);
            if (n == 0) continue;
            if (this.sortDir[i]) break;
            n = -n;
            break;
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public int shuttleSortCompare(Object object, Object object2) {
        int n = 0;
        for (int i = 0; i < this.nbSortCols; ++i) {
            n = this.getColumnRenderer(this.sortCols[i]).compareColumn(object, object2, this.sortCols[i]);
            if (n == 0) continue;
            if (this.sortDir[i]) break;
            n = -n;
            break;
        }
        return n;
    }

    private void hideColumn(TableColumn tableColumn) {
        this.colModel.removeColumn(tableColumn);
        this.table.sizeColumnsToFit(-1);
        this.hiddenColumns.add(tableColumn);
        JMenuItem jMenuItem = new JMenuItem((String)tableColumn.getHeaderValue());
        jMenuItem.addActionListener(this);
        this.showColMenu.add(jMenuItem);
    }

    public void hideOneColumn(int n) {
        this.popupColumn = this.table.convertColumnIndexToModel(n);
        this.popupTableColumn = this.colModel.getColumn(n);
        this.hideColumn(this.popupTableColumn);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent, int n) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CANCEL_SORT)) {
            this.cancelSorting();
        } else if (string.equals(COL_SORT)) {
            this.sortColumns(this.popupColumn, false);
        } else if (string.equals(COL_INC_SORT)) {
            this.sortColumns(this.popupColumn, true);
        } else if (string.equals(COL_HIDE)) {
            for (int i = 0; i < this.nbSortCols; ++i) {
                if (this.sortCols[i] != this.popupColumn) continue;
                this.removeIcons();
                this.nbSortCols = 0;
                this.fireTableDataChanged();
            }
            this.hideColumn(this.popupTableColumn);
        } else if (string.equals(COL_RESET)) {
            this.resetCols();
        } else if (string.equals(COL_DEFAULT)) {
            this.resetColDefaults();
        } else {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            for (int i = 0; i < this.hiddenColumns.size(); ++i) {
                TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
                if (!string.equals((String)tableColumn.getHeaderValue())) continue;
                this.hiddenColumns.remove(i);
                this.colModel.addColumn(tableColumn);
                this.table.sizeColumnsToFit(-1);
                break;
            }
            this.showColMenu.remove(jMenuItem);
            jMenuItem.removeActionListener(this);
        }
    }

    public boolean[] getSortDir() {
        return this.sortDir;
    }

    public int[] getSortCols() {
        return this.sortCols;
    }

    public int getNbSortCols() {
        return this.nbSortCols;
    }

    public ArrayList getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void restoreHidingPrefs(String[] stringArray) {
        this.resetCols();
        this.cancelSorting();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    String string2 = this.table.getColumnName(j);
                    if (!string.equals(string2)) continue;
                    this.hideColumn(this.table.getColumn(string2));
                }
            }
        }
        catch (Exception exception) {
            db.finer("exception in restoreHidingPrefs(): " + exception);
        }
    }

    public void restoreSortingPrefs(int[] nArray, boolean[] blArray, int n) {
        if (nArray == null || blArray == null) {
            return;
        }
        try {
            if (!Arrays.equals(this.sortCols, nArray) || !Arrays.equals(this.sortDir, blArray) || this.nbSortCols != n) {
                this.cancelSorting();
                if (n == 0) {
                    this.nbSortCols = n;
                } else {
                    int n2 = this.getColumnCount();
                    this.nbSortCols = 0;
                    for (int i = 0; i < n; ++i) {
                        int n3 = nArray[i];
                        if (n3 < n2) {
                            this.sortCols[this.nbSortCols] = nArray[i];
                            this.sortDir[this.nbSortCols] = blArray[i];
                            ++this.nbSortCols;
                            continue;
                        }
                        if (!db.on()) continue;
                        db.println(i + " -> " + nArray[i] + " REJECT SORT COLUMN");
                    }
                    this.dataSourceChanged();
                }
            }
        }
        catch (Exception exception) {
            db.finer("Exception in restoreSortingPrefs: " + exception);
        }
    }

    private void resetCols() {
        Object object;
        int n;
        TableColumn tableColumn;
        while (this.colModel.getColumnCount() > 0) {
            tableColumn = this.colModel.getColumn(0);
            this.hiddenColumns.add(tableColumn);
            this.colModel.removeColumn(tableColumn);
        }
        int n2 = this.getColumnCount();
        block1: for (n = 0; n < n2; ++n) {
            object = this.getColumnName(n);
            for (int i = 0; i < this.hiddenColumns.size(); ++i) {
                tableColumn = (TableColumn)this.hiddenColumns.get(i);
                if (!((String)object).equals(tableColumn.getHeaderValue())) continue;
                this.colModel.addColumn(tableColumn);
                this.hiddenColumns.remove(i);
                continue block1;
            }
        }
        for (n = 0; n < this.showColMenu.getItemCount(); ++n) {
            object = this.showColMenu.getItem(n);
            ((AbstractButton)object).removeActionListener(this);
        }
        this.showColMenu.removeAll();
        this.table.sizeColumnsToFit(-1);
    }

    private void cancelSorting() {
        Object object = this.getCurrentSelectionRowObject();
        this.removeIcons();
        this.nbSortCols = 0;
        for (int i = 0; i < this.sortCols.length; ++i) {
            this.sortCols[i] = 0;
            this.sortDir[i] = false;
        }
        this.fireTableDataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SortableRowTableModel.this.table.getTableHeader().repaint();
            }
        });
        this.makeSelectedRow(object);
    }

    public void setDefaultColSetting(int[] nArray, boolean[] blArray, String[] stringArray) {
        this.defaultHideCols = stringArray;
        this.defaultSortCols = new int[this.sortCols.length];
        System.arraycopy(nArray, 0, this.defaultSortCols, 0, nArray.length);
        this.defaultSortDir = new boolean[this.sortCols.length];
        System.arraycopy(blArray, 0, this.defaultSortDir, 0, blArray.length);
        this.defaultNbSortCols = nArray.length;
        this.miDefault.setEnabled(true);
    }

    public void useDefaultHiding() {
        if (this.defaultHideCols != null) {
            this.restoreHidingPrefs(this.defaultHideCols);
        }
    }

    public void useDefaultSorting() {
        if (this.defaultSortCols != null && this.defaultSortDir != null) {
            this.restoreSortingPrefs(this.defaultSortCols, this.defaultSortDir, this.defaultNbSortCols);
        }
    }

    private void resetColDefaults() {
        this.useDefaultHiding();
        this.useDefaultSorting();
    }

    public class TableHdrRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            return this;
        }
    }
}

