/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.AltIiopAddress;
import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.CodeSets;
import cerent.util.ior.IopComponent;
import cerent.util.ior.JavaCodebase;
import cerent.util.ior.OrbType;
import cerent.util.ior.SslTransport;
import java.io.IOException;
import java.io.PrintStream;

public class TaggedComponent {
    private int _tag;
    private IopComponent _component;

    public TaggedComponent(CdrReader cdrReader) throws IOException {
        this._tag = cdrReader.getInt();
        switch (this._tag) {
            case 0: {
                this._component = new OrbType(new CdrReader(cdrReader.getBytes()));
                break;
            }
            case 1: {
                this._component = new CodeSets(new CdrReader(cdrReader.getBytes()));
                break;
            }
            case 3: {
                this._component = new AltIiopAddress(new CdrReader(cdrReader.getBytes()));
                break;
            }
            case 25: {
                this._component = new JavaCodebase(new CdrReader(cdrReader.getBytes()));
                break;
            }
            case 20: {
                this._component = new SslTransport(new CdrReader(cdrReader.getBytes()));
                break;
            }
            default: {
                throw new IOException("Unknown Component tag " + this._tag);
            }
        }
    }

    public CdrWriter write(CdrWriter cdrWriter) throws IOException {
        cdrWriter.putInt(this._tag);
        CdrWriter cdrWriter2 = new CdrWriter(cdrWriter.endian());
        this._component.write(cdrWriter2);
        cdrWriter.putBytes(cdrWriter2.getBytes());
        return cdrWriter;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + "tag: " + this._tag);
        this._component.print(printStream, string);
    }

    public int getTag() {
        return this._tag;
    }

    public void setTag(int n) {
        this._tag = n;
    }

    public IopComponent getComponent() {
        return this._component;
    }

    public void setComponent(IopComponent iopComponent) {
        this._component = iopComponent;
    }

    public boolean isOrbTypeComponent() {
        return this._tag == 0;
    }

    public boolean isCodeSetsComponent() {
        return this._tag == 1;
    }

    public boolean isAltIiopAddressComponent() {
        return this._tag == 3;
    }

    public boolean isJavaCodebaseComponent() {
        return this._tag == 25;
    }

    public boolean isSslTransportComponent() {
        return this._tag == 20;
    }
}

