/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CouldNotGenerateUniqueId;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IdAlreadyPresent;
import cerent.cms.model.InvalidCircuitInfoParameters;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import cerent.util.tty.CLISetConnectionIdAction;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.CircuitModel;
import com.cisco.crs.model.ConnectionModels;
import com.cisco.crs.model.CrsCircuitInfo;
import com.cisco.crs.model.EntityTableModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimInterfaceModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.core.TTIObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CircuitFactoryModel
extends AbstractModel
implements ICircuitFactoryModel {
    private Map circuitMap = Collections.synchronizedMap(new HashMap());
    private boolean inited = false;
    private int lastCircuitUniqueId = 1;

    public CircuitFactoryModel(PlatformNodeModel platformNodeModel) {
        super(platformNodeModel, platformNodeModel.getChildDebug(CircuitFactoryModel.class));
    }

    public boolean isInited() {
        return this.inited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::init");
        }
        super.init0();
        Map map = this.circuitMap;
        synchronized (map) {
            this.circuitMap.putAll(this.discoverCircuits());
            this.initializeCircuits();
        }
        this.inited = true;
        ((ConnectionModels)this.node.getConnectionModels()).probeOchTrailAditModels();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCircuits() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::updateCircuits");
        }
        boolean bl = false;
        bl = ((ConnectionModels)this.node.getConnectionModels()).probeOchTrailAditModels();
        if (bl) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HashMap hashMap = this.discoverCircuits();
        Map map = this.circuitMap;
        synchronized (map) {
            Serializable serializable;
            Object object2;
            for (Object object2 : hashMap.keySet()) {
                if (!this.circuitMap.containsKey(object2)) {
                    bl2 = true;
                    serializable = (CircuitModel)hashMap.get(object2);
                    ((CircuitModel)serializable).init();
                    this.circuitMap.put(object2, serializable);
                    continue;
                }
                serializable = (CircuitModel)this.circuitMap.get(object2);
                if (((CircuitModel)serializable).getSize() != 31) continue;
                bl4 = true;
            }
            object2 = this.circuitMap.keySet().iterator();
            while (object2.hasNext()) {
                serializable = (Integer)object2.next();
                if (hashMap.containsKey(serializable)) continue;
                bl3 = true;
                CircuitModel circuitModel = (CircuitModel)this.circuitMap.get(serializable);
                object2.remove();
                if (circuitModel == null) continue;
                circuitModel.setChanged();
                circuitModel.notifyObservers(ModelUpdateType.DELETED);
            }
        }
        if (bl2 || bl4) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        if (bl3) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    private HashMap discoverCircuits() {
        try {
            HashMap<Integer, CircuitModel> hashMap = new HashMap<Integer, CircuitModel>();
            EntityTableModel entityTableModel = (EntityTableModel)this.node.getEntityTable();
            List<PlimPortId> list = entityTableModel.getPlimPortIndices();
            for (PlimPortId plimPortId : list) {
                PlimPortModel plimPortModel = (PlimPortModel)entityTableModel.getEntityModelByIndex(plimPortId.getPortId());
                String string = ((PlimInterfaceModel)plimPortModel.getInterfaceModel()).getConnectionId();
                TTIObject tTIObject = null;
                if (string == null || !(tTIObject = new TTIObject()).initialize(string) || !tTIObject.containsValidCircuit()) continue;
                if (tTIObject.getUniqueId() > this.lastCircuitUniqueId) {
                    this.lastCircuitUniqueId = tTIObject.getUniqueId();
                }
                ICircuitInfo iCircuitInfo = tTIObject.getICircuitInfo(this.node.getNodeId(), plimPortModel.getEntityIndex());
                iCircuitInfo.setCktOptChannel(((PlimInterfaceModel)plimPortModel.getInterfaceModel()).getActualWaveLength());
                CrsCircuitInfo crsCircuitInfo = new CrsCircuitInfo(iCircuitInfo, tTIObject.getICircuitId(), tTIObject.getPortInternalId());
                CircuitModel circuitModel = new CircuitModel(this.node, crsCircuitInfo);
                hashMap.put(new Integer(circuitModel.getId().getUniquePart().getUniqueId()), circuitModel);
            }
            return hashMap;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("AbstractCmsNoSuchEntityException caught in crs's CircuitFactoryModel::discoverCircuits");
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.println("NoSuchInterface caught in crs's CircuitFactoryModel::discoverCircuits");
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.println("WrongInterfaceType caught in crs's CircuitFactoryModel::discoverCircuits");
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("AbstractCmsIOException caught in crs's CircuitFactoryModel::discoverCircuits");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            for (CircuitModel circuitModel : this.circuitMap.values()) {
                circuitModel.init();
            }
        }
    }

    public ICircuitModel createCircuit(ICircuitInfo iCircuitInfo) {
        return null;
    }

    public ICircuitModel createCircuit(INodeModel iNodeModel, ICircuitInfo iCircuitInfo) throws InvalidCircuitInfoParameters, InvalidCircuitName, CouldNotGenerateUniqueId, AbstractCmsIOException, IdAlreadyPresent {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::createCircuit");
        }
        if (iNodeModel.getNeType().indexOf("crs") == -1) {
            this.db.println("CircuitFactoryModel::createCircuit - Destination must be a CRS node");
            throw new InvalidCircuitInfoParameters("CircuitFactoryModel::createCircuit - Destination must be a CRS node");
        }
        PlimPortModel plimPortModel = null;
        PlimPortModel plimPortModel2 = null;
        try {
            plimPortModel = (PlimPortModel)this.node.getEntityTable().getEntityModelByIndex(iCircuitInfo.getSrcInfo()[0].getPortNum());
            plimPortModel2 = (PlimPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(iCircuitInfo.getDropInfo()[0].getDropPoint().getPortNum());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("CircuitFactoryModel::createCircuit - Invalid port specified");
            throw new InvalidCircuitInfoParameters("CircuitFactoryModel::createCircuit - Invalid port specified");
        }
        TTIObject tTIObject = new TTIObject();
        tTIObject.setIpAddr(iNodeModel.getHostName());
        tTIObject.setNodeId(iCircuitInfo.getSrcInfo()[0].getNodeId());
        tTIObject.setUniqueId(++this.lastCircuitUniqueId);
        tTIObject.setPortInternalId(plimPortModel2.getInternalId());
        if ("".equals(iCircuitInfo.getCircuitName())) {
            iCircuitInfo.setCircuitName(this.deriveDefaultName(this.node.getHostName(), this.lastCircuitUniqueId));
        }
        tTIObject.setCircuitName(iCircuitInfo.getCircuitName());
        String string = tTIObject.toString();
        tTIObject.invalidateCircuit();
        String string2 = tTIObject.toString();
        CLISetConnectionIdAction cLISetConnectionIdAction = this.getCLISetConnectionIdAction(this.node);
        CLISetConnectionIdAction cLISetConnectionIdAction2 = this.getCLISetConnectionIdAction((PlatformNodeModel)iNodeModel.getDelegate());
        try {
            this.updateConnectionId(cLISetConnectionIdAction, plimPortModel, string);
        }
        catch (ConnectionIdRollbackNeededException connectionIdRollbackNeededException) {
            throw (InvalidCircuitInfoParameters)connectionIdRollbackNeededException.getCause();
        }
        try {
            this.updateConnectionId(cLISetConnectionIdAction2, plimPortModel2, string2);
        }
        catch (ConnectionIdRollbackNeededException connectionIdRollbackNeededException) {
            try {
                this.rollbackConnectionId(cLISetConnectionIdAction, plimPortModel);
            }
            catch (ConnectionIdRollbackFailedException connectionIdRollbackFailedException) {
                throw (InvalidCircuitInfoParameters)connectionIdRollbackFailedException.getCause();
            }
            throw (InvalidCircuitInfoParameters)connectionIdRollbackNeededException.getCause();
        }
        CrsCircuitInfo crsCircuitInfo = new CrsCircuitInfo(iCircuitInfo, tTIObject.getICircuitId(), plimPortModel2.getInternalId());
        CircuitModel circuitModel = new CircuitModel(this.node, crsCircuitInfo);
        ICircuitModel iCircuitModel = this.add(circuitModel);
        return iCircuitModel;
    }

    private CLISetConnectionIdAction getCLISetConnectionIdAction(PlatformNodeModel platformNodeModel) throws AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::getCLISetConnectionIdAction");
        }
        CLISetConnectionIdAction cLISetConnectionIdAction = new CLISetConnectionIdAction(platformNodeModel.getHostName());
        return cLISetConnectionIdAction;
    }

    private void updateConnectionId(CLISetConnectionIdAction cLISetConnectionIdAction, PlimPortModel plimPortModel, String string) throws InvalidCircuitInfoParameters, ConnectionIdRollbackNeededException {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::updateConnectionId");
        }
        boolean bl = false;
        bl = cLISetConnectionIdAction.setConnectionId(plimPortModel.getInternalId(), string);
        if (bl) {
            this.db.println("CircuitFactoryModel::updateConnectionId - Node ConnectionId unsuccessful.");
            throw new ConnectionIdRollbackNeededException((Throwable)new InvalidCircuitInfoParameters("CircuitFactoryModel::updateConnectionId - Node Transmitted ConnectionId unsuccessful."));
        }
        try {
            ((IPlimTrkLineModel)plimPortModel.getInterfaceModel()).setConnectionId(string);
            if (this.db.on()) {
                this.db.println("CircuitFactoryModel::updateConnectionId - Node ConnectionId set.");
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.println("CircuitFactoryModel::updateConnectionId - Node ConnectionId not set, Cannot retrieve previous ConnectionId.");
            SDebug.printStackTrace((Throwable)noSuchInterface);
            throw new InvalidCircuitInfoParameters("CircuitFactoryModel::updateConnectionId - Node ConnectionId not set, Cannot retrieve previous ConnectionId.");
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.println("CircuitFactoryModel::updateConnectionId - Node ConnectionId not set, Cannot retrieve previous ConnectionId.");
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            throw new InvalidCircuitInfoParameters("CircuitFactoryModel::updateConnectionId - Node ConnectionId not set, Cannot retrieve previous ConnectionId.");
        }
    }

    private void rollbackConnectionId(CLISetConnectionIdAction cLISetConnectionIdAction, PlimPortModel plimPortModel) throws ConnectionIdRollbackFailedException {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::rollbackConnectionId");
        }
        boolean bl = false;
        try {
            bl = cLISetConnectionIdAction.resetConnectionId(plimPortModel.getInternalId());
            if (!bl) {
                plimPortModel.requireLock();
                ((IPlimTrkLineModel)plimPortModel.getInterfaceModel()).setConnectionId(null);
            }
            if (bl) {
                this.db.println("CircuitFactoryModel::rollbackConnectionId - Node ConnectionId rollback unsuccessful. Inconsistent condition on this node.");
                throw new ConnectionIdRollbackFailedException((Throwable)new InvalidCircuitInfoParameters("CircuitFactoryModel::rollbackConnectionId - Node ConnectionId rollback unsuccessful. Inconsistent condition on this node."));
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.println("CircuitFactoryModel::rollbackConnectionId - Node ConnectionId not set, Cannot restore previous ConnectionId.");
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.println("CircuitFactoryModel::rollbackConnectionId - Node ConnectionId not set, Cannot restore previous ConnectionId.");
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICircuitModel add(ICircuitModel iCircuitModel) {
        CircuitModel circuitModel = null;
        Map map = this.circuitMap;
        synchronized (map) {
            circuitModel = this.getCircuitById(iCircuitModel.getId());
            if (circuitModel != null) {
                return circuitModel;
            }
            circuitModel = (CircuitModel)iCircuitModel;
            circuitModel.init();
            this.circuitMap.put(new Integer(circuitModel.getId().getUniquePart().getUniqueId()), circuitModel);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
        return circuitModel;
    }

    public CircuitModel getCircuitById(ICircuitId iCircuitId) {
        return (CircuitModel)this.circuitMap.get(new Integer(iCircuitId.getUniquePart().getUniqueId()));
    }

    public String toString() {
        return "CircuitFactory";
    }

    public ICircuitModel getCircuitModelById(ICircuitId iCircuitId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICircuitModel[] getCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            return this.circuitMap.values().toArray(new ICircuitModel[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModel::dispose");
        }
        Map map = this.circuitMap;
        synchronized (map) {
            for (CircuitModel circuitModel : this.circuitMap.values()) {
                try {
                    circuitModel.destroy();
                }
                catch (Exception exception) {
                    this.db.println("Exception while destroying circuits" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.circuitMap.clear();
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            Iterator iterator = this.circuitMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                CircuitModel circuitModel = (CircuitModel)this.circuitMap.get(n);
                iterator.remove();
                if (circuitModel == null) continue;
                circuitModel.setChanged();
                circuitModel.notifyObservers(ModelUpdateType.DELETED);
            }
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private String deriveDefaultName(String string, int n) {
        if (string.length() > 16) {
            string = string.substring(0, 15);
        }
        String string2 = CircuitType.OCH_TRAIL_TUNNEL_TYPE.getProtocolIndepCktTypeShortStr() + "_" + string + "_" + n;
        return string2;
    }

    private class ConnectionIdRollbackFailedException
    extends Exception {
        public ConnectionIdRollbackFailedException(Throwable throwable) {
            super(throwable);
        }
    }

    private class ConnectionIdRollbackNeededException
    extends Exception {
        public ConnectionIdRollbackNeededException(Throwable throwable) {
            super(throwable);
        }
    }
}

