/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.shelf;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class Ds3xm12CardView
extends CardView {
    protected static final SDebug db = new SDebug("Ds3xm12CardView");
    private static final int STS12 = 24;
    private static final int STS48 = 36;

    public Ds3xm12CardView(ModuleModel moduleModel) {
        super(moduleModel);
        this.registerForLocalUpdates();
    }

    protected Dimension getCardSize() {
        return new Dimension(70, 260);
    }

    protected void addPorts(boolean bl) {
        this.setPreferredSize(this.getCardSize());
        if (((Ds3xmModuleModel)this.model).isOneForNProtectModule() || ((Ds3xmModuleModel)this.model).isOneForOneProtectModule()) {
            this.repaint();
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 2, 2, 6);
        Insets insets2 = new Insets(2, 6, 2, 2);
        Insets insets3 = new Insets(2, 2, 2, 2);
        boolean bl2 = this.numPorts == 24;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        for (int i = 0; i < this.numPorts; ++i) {
            if (!(this.portModels.get(i) instanceof EntityModel)) continue;
            EntityModel entityModel = (EntityModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
            if (i < 12) {
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.insets = insets;
            } else {
                gridBagConstraints.gridheight = bl2 ? 2 : 1;
                gridBagConstraints.insets = i % 2 == 0 ? insets2 : insets3;
            }
            gridBagConstraints.gridy = this.getGridX(i);
            gridBagConstraints.gridx = this.getGridY(i);
            this.add((Component)this.ports[i], gridBagConstraints);
        }
        this.repaint();
    }

    private int getGridY(int n) {
        int n2 = 0;
        if (n > 11) {
            n2 = n % 2 + 1;
        }
        return n2;
    }

    private int getGridX(int n) {
        boolean bl = false;
        if (n < 12) {
            return n;
        }
        if (n > 23) {
            return n % 24 - n % 2 + 1;
        }
        return n % 12 - n % 2;
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (db.on()) {
                db.println("update(): Ds3xm12CardView, From=" + observable + ", arg=" + n);
            }
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port DELETED");
                }
            } else if (n.equals(ModelUpdateType.CHANGED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Module CHANGED");
                }
            }
        }
    }

    protected void registerForLocalUpdates() {
        if (this.model != null) {
            this.model.addObserver(this);
            if (db.on()) {
                db.println("Registered model: " + this.model);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.model != null) {
            this.model.deleteObserver(this);
            if (db.on()) {
                db.println("Deregistered parent: " + this.model);
            }
        }
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].dispose();
                this.ports[i] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    static /* synthetic */ AbstractPortGraphic[] access$602(Ds3xm12CardView ds3xm12CardView, AbstractPortGraphic[] abstractPortGraphicArray) {
        ds3xm12CardView.ports = abstractPortGraphicArray;
        return abstractPortGraphicArray;
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block5: {
                try {
                    if (Ds3xm12CardView.this.model != null) {
                        Ds3xm12CardView.this.portModels = Ds3xm12CardView.this.getPorts();
                        int n = Ds3xm12CardView.this.portModels.size();
                        if (n != Ds3xm12CardView.this.numPorts && (n == 24 || n == 36)) {
                            Ds3xm12CardView.this.numPorts = n;
                            Ds3xm12CardView.this.localDispose();
                            Ds3xm12CardView.access$602(Ds3xm12CardView.this, new AbstractPortGraphic[Ds3xm12CardView.this.numPorts]);
                            Ds3xm12CardView.this.addPorts(false);
                            Ds3xm12CardView.this.registerForLocalUpdates();
                        }
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            Ds3xm12CardView.this.validate();
            Ds3xm12CardView.this.repaint();
        }
    }
}

