/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui;

import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.aic.AicCardTabbedView;
import cerent.cms.ui.ds1i.Ds1iCardTabbedView;
import cerent.cms.ui.ds3.Ds3CardTabbedView;
import cerent.cms.ui.ds3i.Ds3iCardTabbedView;
import cerent.cms.ui.e1.E1CardTabbedView;
import cerent.cms.ui.e3.E3CardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.l2sc.L2scCardTabbedView;
import cerent.cms.ui.ml2.ML2CardTabbedView;
import cerent.cms.ui.ransvc.RanSvcCardTabbedView;
import com.cisco.ctc455.ui.stm1e.STM1ECardTabbedView;

public class PlatformCardTabbedViewFactory
extends CardTabbedViewFactory {
    private static PlatformCardTabbedViewFactory instance = new PlatformCardTabbedViewFactory();

    private PlatformCardTabbedViewFactory() {
    }

    public static PlatformCardTabbedViewFactory instance() {
        return instance;
    }

    private static MainTabbedView createDs1iCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        Ds1iCardTabbedView ds1iCardTabbedView = null;
        if (moduleModel instanceof Ds123ModuleModel) {
            ds1iCardTabbedView = new Ds1iCardTabbedView((Ds123ModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not Cast DS1I Line Card to Ds123ModuleModel");
        }
        return ds1iCardTabbedView;
    }

    private static MainTabbedView createE1Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        E1CardTabbedView e1CardTabbedView = null;
        if (moduleModel instanceof Ds123ModuleModel) {
            e1CardTabbedView = new E1CardTabbedView((Ds123ModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not Cast E1 Line Card to Ds123ModuleModel");
        }
        return e1CardTabbedView;
    }

    private static MainTabbedView createE3Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        E3CardTabbedView e3CardTabbedView = null;
        if (moduleModel instanceof Ds123ModuleModel) {
            e3CardTabbedView = new E3CardTabbedView((Ds123ModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not Cast E3 Line Card to Ds123ModuleModel");
        }
        return e3CardTabbedView;
    }

    private static MainTabbedView createDs3Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        Ds3CardTabbedView ds3CardTabbedView = null;
        if (moduleModel instanceof Ds123ModuleModel) {
            ds3CardTabbedView = new Ds3CardTabbedView((Ds123ModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not Cast DS3 Line Card to Ds123ModuleModel");
        }
        return ds3CardTabbedView;
    }

    private static MainTabbedView createDs3iCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        Ds3iCardTabbedView ds3iCardTabbedView = null;
        if (moduleModel instanceof Ds123ModuleModel) {
            ds3iCardTabbedView = new Ds3iCardTabbedView((Ds123ModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not Cast Ds3i Line Card to Ds123ModuleModel");
        }
        return ds3iCardTabbedView;
    }

    private static MainTabbedView createAicCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        AicCardTabbedView aicCardTabbedView = null;
        aicCardTabbedView = new AicCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
        return aicCardTabbedView;
    }

    private static MainTabbedView createL2scCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new L2scCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createML2Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new ML2CardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createSTM1ECtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        STM1ECardTabbedView sTM1ECardTabbedView = null;
        sTM1ECardTabbedView = new STM1ECardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
        return sTM1ECardTabbedView;
    }

    private static MainTabbedView createRanSvcCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new RanSvcCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    public MainTabbedView getCardView(IModuleModel iModuleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        ModuleModel moduleModel = (ModuleModel)iModuleModel;
        MainTabbedView mainTabbedView = null;
        switch (moduleModel.getEqType()) {
            case 64: 
            case 83: 
            case 108: 
            case 109: {
                mainTabbedView = PlatformCardTabbedViewFactory.createE1Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 65: {
                mainTabbedView = PlatformCardTabbedViewFactory.createE3Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 197: {
                mainTabbedView = PlatformCardTabbedViewFactory.createDs1iCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 6: 
            case 7: {
                mainTabbedView = PlatformCardTabbedViewFactory.createDs3Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 66: 
            case 67: {
                mainTabbedView = PlatformCardTabbedViewFactory.createDs3iCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 248: {
                mainTabbedView = PlatformCardTabbedViewFactory.createRanSvcCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 102: 
            case 103: 
            case 221: {
                mainTabbedView = PlatformCardTabbedViewFactory.createL2scCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 187: 
            case 229: 
            case 283: 
            case 285: {
                mainTabbedView = PlatformCardTabbedViewFactory.createML2Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 37: {
                mainTabbedView = PlatformCardTabbedViewFactory.createAicCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 113: {
                mainTabbedView = PlatformCardTabbedViewFactory.createSTM1ECtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            default: {
                mainTabbedView = super.getCardView(moduleModel, iEventPanelController, iUiToolkit);
            }
        }
        return mainTabbedView;
    }
}

