/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.ms;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.AbstractMsShelfLayout;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.gui.IconImpl;
import com.cisco.ctc455.ui.ms.MsCardFactory;
import com.cisco.ctc455.ui.ms.MsCardPainter;
import com.cisco.ctc455.ui.ms.MsFmecBlankCard;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class MsShelfLayout
extends AbstractMsShelfLayout {
    public static final int SHELF_SLOT_COUNT = 17;
    public static final int FMEC_SHELF_SLOT_COUNT = 12;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round(4.0f));
    private static final Font labelFont = new Font("Arial", 0, 10);
    private JPanel fmecSlotsPanel;
    private JLabel idLbl;

    public MsShelfLayout(IShelfViewModel iShelfViewModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iShelfViewModel, abstractViewController, bayViewPanel);
    }

    protected void refreshShelfColor() {
        this.setShelfColor(this.getState());
        this.labelsPanel.setBackground(this.currShelfColor);
        this.idLbl.setBackground(this.currShelfColor);
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = this.getInnerLabelPanel(new GridLayout(1, 17, 0, 0), this.chassis.getTDMTerminology());
            Dimension dimension = new Dimension(204, 10);
            this.labels = new JLabel[29];
            for (int i = 0; i < 29; ++i) {
                this.labels[i] = new JLabel("");
            }
            this.idLbl = new JLabel("Shelf " + this.chassis.getShelfId());
            this.idLbl.setFont(labelFont);
            this.idLbl.setPreferredSize(dimension);
            this.idLbl.setMinimumSize(dimension);
            this.idLbl.setHorizontalAlignment(0);
            this.labelsPanel.add(this.idLbl);
            this.refreshShelfColor();
        }
    }

    private void createFmecSlotsPanel(TransferHandler transferHandler) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.fmecSlotsPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 17; i < 29; ++i) {
            IconImpl iconImpl = new IconImpl(MsFmecBlankCard.SINGLE_SLOT_DIM);
            this.cards[i] = new MsCardPanel(iconImpl, this);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(transferHandler);
            gridBagLayout.setConstraints(this.cards[i], gridBagConstraints);
            this.fmecSlotsPanel.add(this.cards[i]);
            ++gridBagConstraints.gridx;
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension dimension = new Dimension(12, MsCardPainter.CARD_HEIGHT);
        ShelfTransferHandler shelfTransferHandler = new ShelfTransferHandler(this.chassis.getNodeModelDelegate().getChassisModelsInstance(), this.bvp.getRVP().getMVP());
        for (int i = 0; i < 17; ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new MsCardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(shelfTransferHandler);
            this.slotsPanel.add(this.cards[i]);
        }
        this.createFmecSlotsPanel(shelfTransferHandler);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setTransferHandler(shelfTransferHandler);
    }

    protected CardGraphic createCard(EntityModel entityModel) {
        return MsCardFactory.createMsCard(entityModel, this);
    }

    public int getShelfSlotCount() {
        return 29;
    }

    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
        this.addFmecPanels();
    }

    private void addFmecPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fmecSlotsPanel, gridBagConstraints);
        this.add(this.fmecSlotsPanel);
    }
}

