/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EntityModel;
import cerent.cms.model.PimModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.MultiLineLabelUI;
import com.cisco.ctc600.model.PimSlotModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ChangePimDialog
extends JDialog {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox pimComboBox;
    private PimSlotModel pimSlotModel;
    private PimModel pimModel;
    private int slotNo;
    private static SDebug db = new SDebug("ChangePimDialog");

    public ChangePimDialog(Frame frame, PimModel pimModel) {
        super(frame, "Change PIM", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChangePimDialog.this.dispose();
            }
        });
        this.pimModel = pimModel;
        this.pimSlotModel = (PimSlotModel)pimModel.getAncestorOfEqType(147);
        this.slotNo = this.pimSlotModel.getPositionInParent();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getDescPanel(), "North");
        container.add((Component)this.getComboPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel getDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "You are about to change the provisioning of PIM on slot " + this.slotNo + ".\nThe slot is currently provisioned for " + this.pimModel.getEqTypeName() + ".\n\nTo continue, select " + "a new PIM below:";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getComboPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Change to: "));
        this.pimComboBox = new JComboBox(this.getAvailCards());
        jPanel.add(this.pimComboBox);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute attribute = (Attribute)ChangePimDialog.this.pimComboBox.getSelectedItem();
                eEqType eEqType2 = eEqType.from_int(attribute.getIntValue());
                if (db.on) {
                    db.println("The PIM selected is " + attribute.getKey() + " with eqType equals " + attribute.getIntValue());
                }
                try {
                    ChangePimDialog.this.pimModel.changePIMEqType(eEqType2);
                }
                catch (ResourceInUse resourceInUse) {
                    ErrorMsg.displayError((Component)ChangePimDialog.this, (EID)EMC.EID_CHANGE_RESOURCE_IN_USE);
                }
                catch (ProvisionError provisionError) {
                    ErrorMsg.displayError((Component)ChangePimDialog.this, (EID)EMC.EID_CHANGE_CARD_PROV_ERROR);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayDetailed((Component)ChangePimDialog.this, EMC.EID_CARD_CHANGE, exception.getMessage());
                }
                ChangePimDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangePimDialog.this.dispose();
            }
        });
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private Vector getAvailCards() {
        Vector<Attribute> vector = new Vector<Attribute>();
        List list = this.pimSlotModel.getListOfValidChangeType(eEqType.from_int(this.pimModel.getEqType()));
        Iterator iterator = list.iterator();
        TDMTerminology tDMTerminology = this.pimSlotModel.getNodeModel().getTDMTerminology();
        while (iterator.hasNext()) {
            eEqType eEqType2 = (eEqType)iterator.next();
            vector.add(new Attribute(EntityModel.eqType2Name(tDMTerminology, eEqType2), eEqType2.value()));
        }
        return vector;
    }

    public void dispose() {
        this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
        super.dispose();
    }
}

