/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.ppm.PpmCard;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public class PimCard
extends CardGraphic {
    private PpmSlot[] ppmSlots = null;

    public PimCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.setBounds(rectangle);
        this.createChildren();
        super.refreshCard();
        if (sDebug.on()) {
            sDebug.println("Card: " + entityModel.getEqLabel() + "\tNum of children: " + this.entityM.getChildren().size());
        }
    }

    private void createChildren() {
        block5: {
            try {
                List list = this.entityM.getChildren();
                this.ppmSlots = new PpmSlot[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (entityModel == null) {
                        if (!this.db.on()) continue;
                        this.db.println("Entity for PPM slot [" + i + "] is NULL");
                        continue;
                    }
                    PluggableSlotModel pluggableSlotModel = null;
                    if (entityModel instanceof PluggableSlotModel) {
                        pluggableSlotModel = (PluggableSlotModel)entityModel;
                        this.ppmSlots[i] = new PpmSlot(pluggableSlotModel, this.parent, this.db, this.getChildBounds(i));
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("Entity is NOT PluggableSlotModel");
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block5;
                this.db.println("Exception while creating PPM slots");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public PpmSlot[] getChildren() {
        return this.ppmSlots;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (!this.ppmSlots[i].contains(mouseEvent.getPoint())) continue;
                return this.ppmSlots[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, object);
        if (this.db.on()) {
            this.db.println("PimCard:update: END");
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.computeVisibleRect(this.cardPainter.getMainRectangle().getBounds());
        graphics2D.setColor(this.currentColor);
        graphics2D.fill(this.cardPainter.getMainRectangle());
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.cardPainter.getMainRectangle());
        if (this.ppmSlots == null) {
            return;
        }
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            if (this.ppmSlots[i] == null) continue;
            this.ppmSlots[i].draw(graphics2D);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.cardPainter.getMainRectangle().setBounds(rectangle);
        super.setBounds(this.cardPainter.getMainRectangle());
    }

    public boolean contains(Point point) {
        return point.x >= this.getX() && point.x <= this.getX() + this.getWidth() && point.y >= this.getY() && point.y <= this.getY() + this.getHeight();
    }

    public boolean hasProvisionedCard() {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.entityM.getParent() != null) {
                    bl = true;
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return bl;
    }

    public IAlarmStatus getAlarmStatus() {
        IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(this.entityM);
        if (this.ppmSlots == null) {
            return iAlarmStatus;
        }
        int n = -1;
        if (iAlarmStatus != null) {
            n = iAlarmStatus.getHighestSeverity();
        }
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            int n2;
            PpmCard ppmCard;
            if (this.ppmSlots[i] == null) {
                return iAlarmStatus;
            }
            List list = this.ppmSlots[i].getChildren();
            if (list.size() <= 0 || (ppmCard = (PpmCard)list.get(0)).getAlarmStatus() == null || (n2 = ppmCard.getAlarmStatus().getHighestSeverity()) <= n) continue;
            iAlarmStatus = ppmCard.getAlarmStatus();
            n = n2;
        }
        return iAlarmStatus;
    }

    protected Rectangle getChildBounds(int n) {
        return new Rectangle(this.cardPainter.getMainRectangle().x + 3, this.cardPainter.getMainRectangle().y + 10 * n + 3, this.cardPainter.getMainRectangle().width - 6, this.cardPainter.getMainRectangle().height / 4 - 1);
    }

    public void dispose() {
        if (this.ppmSlots != null) {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (this.ppmSlots[i] == null) continue;
                this.ppmSlots[i].dispose();
                this.ppmSlots[i] = null;
            }
        }
        this.ppmSlots = null;
        super.dispose();
    }
}

