/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.imrutility.imr.Server;
import org.jacorb.imrutility.imr.ServerImpl;
import org.jacorb.imrutility.imr.util.IMRLocator;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.RTORB;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MultipleComponentProfile;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.policies.ClientProtocolPolicy;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.Servant;
import org.omg.SecurityLevel2.Current;

public class ORB
extends ORBSingleton
implements POAListener {
    private static final String versionString = "2.1.3.7";
    private static final String dateString = "29-August-2007";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private Map initial_references = new HashMap();
    private POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private BufferManager bufferManager = BufferManager.getInstance();
    private Map valueFactories = new HashMap();
    private Map objectKeyMap = new HashMap();
    private Logger logger;
    private String[] _args;
    private Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private byte[] shutdown_synch = new byte[0];
    private Repository imr;
    private byte[] imrUpdateLock = new byte[0];
    private IMRLocator locator;
    private Server activeServerHandler;
    private ServerImpl imrServerImpl;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:2.1.3.7";
    private Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private RTORB rtORB = null;
    private PolicyManager policyManager = null;
    private Map policy_factories = null;
    private static final String[] services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory", "RTORB"};
    private boolean bidir_giop = false;

    @Override
    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public Object _getObject(IOR _ior) {
        Delegate d = new Delegate(this, _ior, true);
        return d.getReference(null);
    }

    public synchronized Object _getDelegate(ParsedIOR pior) {
        ObjectImpl o = null;
        String key = null;
        if (Environment.cacheReferences() && (o = (ObjectImpl)this.knownReferences.get(key = pior.getIORString())) != null) {
            Delegate del = (Delegate)o._get_delegate();
            if (del != null) {
                ParsedIOR delpior = del.getParsedIOR();
                if (delpior == null) {
                    this.knownReferences.remove(key);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removing an invalid reference from cache.");
                    }
                } else if (pior.getEffectiveProfile().is_match(delpior.getEffectiveProfile())) {
                    return o._duplicate();
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove stale reference from cache ");
                }
                this.knownReferences.remove(key);
            }
        }
        Delegate d = new Delegate(this, pior);
        o = d.getReference(null);
        if (Environment.cacheReferences()) {
            this.knownReferences.put(pior.getIORString(), o);
        }
        return o;
    }

    POA findPOA(Delegate d, Object ref) {
        String refImplName = null;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        String orbImplName = Environment.implNameStr();
        String orbServerId = Environment.serverIdStr();
        try {
            refImplName = POAUtil.extractImplName(d.getObjectKey());
        }
        catch (POAInternalError pie) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA");
            }
            return null;
        }
        if (refImplName == null) {
            if (orbImplName.length() > 0 || orbServerId.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch");
                }
                return null;
            }
        } else if (!orbImplName.equals(refImplName) && !orbServerId.equals(refImplName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch");
            }
            return null;
        }
        if (Environment.isImR()) {
            String imrKey = (String)this.objectKeyMap.get("ImplementationRepository");
            if (!POAUtil.convert(d.getObjectKey()).equals(imrKey)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: ImR request to ImR");
                }
                return null;
            }
        }
        try {
            String res;
            POA tmp_poa = this.rootpoa;
            String poa_name = POAUtil.extractPOAName(d.getObjectKey());
            List scopes = POAUtil.extractScopedPOANames(poa_name);
            for (int i = 0; i < scopes.size() && !(res = (String)scopes.get(i)).equals(""); ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] objectId = POAUtil.extractOID(ref);
            if (tmp_poa.isSystemId() && !tmp_poa.previouslyGeneratedObjectId(objectId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return tmp_poa;
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public GIOPConnectionManager getGIOPConnectionManager() {
        return this.giop_connection_manager;
    }

    synchronized void _release(String iorString) {
        if (Environment.cacheReferences()) {
            this.knownReferences.remove(iorString);
        }
    }

    @Override
    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 34: {
                return new MaxHopsPolicy(value);
            }
            case 35: {
                return new QueueOrderPolicy(value);
            }
            case 23: {
                return new RebindPolicy(value);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(value);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(value);
            }
            case 30: {
                return new ReplyEndTimePolicy(value);
            }
            case 26: {
                return new ReplyPriorityPolicy(value);
            }
            case 29: {
                return new ReplyStartTimePolicy(value);
            }
            case 28: {
                return new RequestEndTimePolicy(value);
            }
            case 25: {
                return new RequestPriorityPolicy(value);
            }
            case 27: {
                return new RequestStartTimePolicy(value);
            }
            case 33: {
                return new RoutingPolicy(value);
            }
            case 24: {
                return new SyncScopePolicy(value);
            }
            case 43: {
                return new ClientProtocolPolicy(value);
            }
        }
        Integer key = new Integer(type);
        if (this.policy_factories == null || !this.policy_factories.containsKey(key)) {
            throw new PolicyError();
        }
        PolicyFactory factory = (PolicyFactory)this.policy_factories.get(key);
        return factory.create_policy(type, value);
    }

    public boolean hasPolicyFactoryForType(int type) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(type));
    }

    @Override
    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public org.omg.CORBA.Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    IOR createIOR(String repId, byte[] objectKey, boolean _transient, POA poa, Map policy_overrides) {
        if (!_transient && Environment.useImR() && Environment.useImREndpoint()) {
            IOR ior = this.createIOR(repId, objectKey, poa.getImREndpoints());
            if (Environment.imrProxyHost() != null || Environment.imrProxyPort() == -1) {
                for (int i = 0; i < ior.profiles.length; ++i) {
                    if (ior.profiles[i].tag != 0) continue;
                    IIOPProfile profile = new IIOPProfile(ior.profiles[i].profile_data);
                    profile.patchPrimaryAddress(Environment.imrProxyHost(), Environment.imrProxyPort());
                    ior.profiles[i] = profile.asTaggedProfile();
                }
            }
            return ior;
        }
        ArrayList profiles = new ArrayList();
        HashMap componentMap = new HashMap();
        this.getProfiles(poa, policy_overrides, componentMap, profiles);
        TaggedProfile[] tps = new TaggedProfile[profiles.size()];
        TaggedProfileHolder tp = new TaggedProfileHolder();
        TaggedComponentSeqHolder tc = new TaggedComponentSeqHolder();
        for (int i = 0; i < profiles.size(); ++i) {
            Profile p = (Profile)profiles.get(i);
            p.set_object_key(objectKey);
            TaggedComponentList c = (TaggedComponentList)componentMap.get(new Integer(p.tag()));
            tc.value = c.asArray();
            p.marshal(tp, tc);
            tps[i] = tp.value;
        }
        profiles.clear();
        componentMap.clear();
        componentMap = null;
        profiles = null;
        return new IOR(repId, tps);
    }

    public void getProfiles(POA poa, Map policy_overrides, Map componentMap, List profiles) {
        IIOPProfile iiopProfile;
        for (Profile profile : this.basicAdapter.getEndpointProfiles()) {
            profiles.add(profile);
            TaggedComponentList profileComponents = new TaggedComponentList();
            profileComponents.addComponent(this.create_ORB_TYPE_ID());
            componentMap.put(new Integer(profile.tag()), profileComponents);
            if (!(profile instanceof IIOPProfile)) continue;
            this.patchAddress((IIOPProfile)profile);
        }
        TaggedComponentList multipleComponents = new TaggedComponentList();
        componentMap.put(new Integer(1), multipleComponents);
        if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
            IORInfoImpl info = new IORInfoImpl(this, poa, componentMap, policy_overrides, profiles);
            try {
                this.interceptor_manager.getIORIterator().iterate(info);
            }
            catch (Exception e) {
                Debug.output(2, e);
            }
        }
        if ((Environment.giopMinorVersion() == 0 || Environment.giopAdd_1_0_Profiles()) && (iiopProfile = this.findIIOPProfile(profiles)) != null) {
            IIOPProfile profile_1_0 = iiopProfile.to_GIOP_1_0();
            profiles.add(profile_1_0);
            TaggedComponentList iiopComponents = (TaggedComponentList)componentMap.get(new Integer(0));
            multipleComponents.addAll(iiopProfile.getComponents());
            multipleComponents.addAll(iiopComponents);
            if (Environment.giopMinorVersion() == 0) {
                profiles.remove(iiopProfile);
            }
        }
        if (!multipleComponents.isEmpty()) {
            profiles.add(new MultipleComponentProfile(multipleComponents));
        }
    }

    public IOR createIOR(String repId, byte[] objectKey, EndpointProfile[] endpoints) {
        TaggedProfile[] tps = new TaggedProfile[endpoints.length];
        for (int i = 0; i < endpoints.length; ++i) {
            CDROutputStream profileDataStream = new CDROutputStream();
            switch (endpoints[i].encapsulation) {
                case 2: {
                    profileDataStream.write_octet_array(endpoints[i].addressProfile, 0, endpoints[i].addressProfile.length);
                    break;
                }
                case 0: {
                    profileDataStream.write_octet_array(endpoints[i].addressProfile, 0, endpoints[i].addressProfile.length);
                    profileDataStream.write_long(objectKey.length);
                    profileDataStream.write_octet_array(objectKey, 0, objectKey.length);
                    profileDataStream.write_long(endpoints[i].taggedComponents.length);
                    for (int j = 0; j < endpoints[i].taggedComponents.length; ++j) {
                        TaggedComponentHelper.write(profileDataStream, endpoints[i].taggedComponents[j]);
                    }
                    break;
                }
            }
            tps[i] = new TaggedProfile(endpoints[i].tag, profileDataStream.getBufferCopy());
        }
        return new IOR(repId, tps);
    }

    private IIOPProfile findIIOPProfile(List profiles) {
        for (Profile p : profiles) {
            if (!(p instanceof IIOPProfile)) continue;
            return (IIOPProfile)p;
        }
        return null;
    }

    @Override
    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(POA poa, byte[] object_key, String rep_id, boolean _transient) {
        if (rep_id == null) {
            rep_id = "IDL:omg.org/CORBA/Object:1.0";
        }
        IOR ior = this.createIOR(rep_id, object_key, _transient, poa, null);
        Delegate d = new Delegate(this, ior);
        return d.getReference(poa);
    }

    public POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = POA._POA_init(this);
            this.rootpoa._addPOAEventListener(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.transport_manager, this.giop_connection_manager);
        }
        return this.rootpoa;
    }

    private boolean findImR() {
        Repository newImR;
        block16: {
            newImR = null;
            try {
                newImR = RepositoryHelper.narrow(this.resolve_initial_references("ImplementationRepository"));
            }
            catch (InvalidName e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Failed to resolve initial references for the Implementation Repository");
                }
            }
            catch (Exception e) {
                if (!this.logger.isInfoEnabled()) break block16;
                this.logger.info("Failed to resolve initial references for the Implementation Repository");
            }
        }
        if (newImR != null && newImR._non_existent()) {
            newImR = null;
        }
        if (newImR == null && this.rootpoa != null) {
            try {
                if (this.locator == null) {
                    this.locator = new IMRLocator(this);
                }
                this.locator.findIMRs();
                ArrayList retrievedIMRs = this.locator.getIMRs();
                if (retrievedIMRs.size() != 0) {
                    newImR = RepositoryHelper.narrow((Object)retrievedIMRs.get(0));
                }
            }
            catch (Exception ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("IMRLocator got an exception finding ImRs", ex);
                }
                newImR = null;
            }
        }
        if (newImR != null) {
            this.imr = newImR;
            if (this.rootpoa != null && !POAUtil.isHolding(this.rootpoa.the_POAManager().get_state())) {
                try {
                    this.rootpoa.reRegisterWithImR();
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Failed to re-register persistent POAs with a new ImR");
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    @Override
    public String[] list_initial_services() {
        ArrayList l = new ArrayList();
        Iterator e = this.initial_references.keySet().iterator();
        while (e.hasNext()) {
            l.add(e.next());
        }
        String[] initial_services = new String[services.length + l.size()];
        l.toArray(initial_services);
        System.arraycopy(services, 0, initial_services, l.size(), services.length);
        return initial_services;
    }

    @Override
    public void poaCreated(POA poa) {
        poa._addPOAEventListener(this);
        if (poa.isPersistent()) {
            ++this.persistentPOACount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getImR() {
        byte[] byArray = this.imrUpdateLock;
        synchronized (this.imrUpdateLock) {
            if (this.imr == null) {
                try {
                    this.findImR();
                }
                catch (INTERNAL iNTERNAL) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.imr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imrDead(Repository corpse) {
        byte[] byArray = this.imrUpdateLock;
        synchronized (this.imrUpdateLock) {
            if (!this.imrsEqual(this.imr, corpse)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.findImR();
        }
    }

    protected boolean imrsEqual(Repository imr1, Repository imr2) {
        return imr1 == imr2;
    }

    public Server getActiveServerHandler() {
        if (this.activeServerHandler == null) {
            this.imrServerImpl = new ServerImpl(this);
            this.imrServerImpl.heartbeat(Environment.getIntPropertyWithDefault("jacorb.imr.heartbeat", 0));
            this.activeServerHandler = this.imrServerImpl.installOnRootPOA();
        }
        return this.activeServerHandler;
    }

    public ServerImpl getImRServerImpl() {
        return this.imrServerImpl;
    }

    private void patchAddress(IIOPProfile profile) {
        profile.patchPrimaryAddress(Environment.iorProxyHost(), Environment.iorProxyPort());
    }

    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream orbIDComponentDataStream = new CDROutputStream(this);
        orbIDComponentDataStream.beginEncapsulatedArray();
        orbIDComponentDataStream.write_long(1245790976);
        byte[] result = orbIDComponentDataStream.getBufferCopy();
        orbIDComponentDataStream.close();
        return new TaggedComponent(0, result);
    }

    private String getServerAddress() {
        String address = Environment.getProperty("jacorb.ior_proxy_host");
        if (address == null) {
            address = this.getBasicAdapter().getAddress();
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy host " + address + " in IOR");
        }
        return address;
    }

    private int getServerPort() {
        String port_str = Environment.getProperty("jacorb.ior_proxy_port");
        int port = -1;
        if (port_str != null) {
            try {
                port = Integer.parseInt(port_str);
            }
            catch (NumberFormatException nfe) {
                throw new BAD_QOS("Unable to create integer from string >>" + port_str + "<<. " + "(check property \"jacorb.ior_proxy_port\")");
            }
            if (port < 0) {
                throw new BAD_QOS("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using proxy port " + port + " in IOR");
            }
        } else {
            port = this.getBasicAdapter().getPort();
        }
        return port;
    }

    private String getIMRAddressForIOR(String imrAddress) {
        String imrProxyHost = Environment.getProperty("jacorb.imr.ior_proxy_host");
        return imrProxyHost == null ? imrAddress : imrProxyHost;
    }

    private int getIMRPortForIOR(int imrPort) {
        block3: {
            String imrProxyPort = Environment.getProperty("jacorb.imr.ior_proxy_port");
            if (imrProxyPort != null) {
                try {
                    imrPort = Integer.parseInt(imrProxyPort);
                }
                catch (NumberFormatException nfe) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("IMR Proxy Port is configured to a none integer value. Check the value of property \"jacorb.imr.ior_proxy_port");
                }
            }
        }
        return imrPort;
    }

    @Override
    public void poaStateChanged(POA poa, int new_state) {
        if ((new_state == 4 || new_state == 3) && poa.isPersistent()) {
            --this.persistentPOACount;
        }
    }

    @Override
    public void referenceCreated(Object o) {
    }

    @Override
    public boolean get_service_information(short service_type, ServiceInformationHolder service_information) {
        throw new NO_IMPLEMENT();
    }

    @Override
    public Object resolve_initial_references(String identifier) throws InvalidName {
        if (this.initial_references.containsKey(identifier)) {
            return (Object)this.initial_references.get(identifier);
        }
        Object obj = null;
        String url = Environment.getProperty("ORBInitRef." + identifier);
        if (url != null) {
            try {
                obj = this.string_to_object(url);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create initial reference for \"" + identifier + "\"\n" + "Please check property \"ORBInitRef." + identifier + '\"');
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage());
                }
                throw new InvalidName();
            }
        } else if (identifier.equals("NameService") && this.isApplet()) {
            String ior_str = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
            obj = this.string_to_object(ior_str);
            if (obj != null && !obj._is_a(NamingContextHelper.id())) {
                obj = null;
            }
        } else {
            if (identifier.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (identifier.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (identifier.equals("SecurityCurrent")) {
                if (this.securityCurrent == null) {
                    this.securityCurrent = new CurrentImpl(this);
                    ((CurrentImpl)this.securityCurrent).init();
                }
                obj = this.securityCurrent;
            } else if (identifier.equals("DynAnyFactory")) {
                obj = new DynAnyFactoryImpl((org.omg.CORBA.ORB)this, this.logger);
            } else {
                if (identifier.equals("PICurrent")) {
                    return this.piCurrent;
                }
                if (identifier.equals("ORBPolicyManager")) {
                    return this.getPolicyManager();
                }
                if (identifier.equals("CodecFactory")) {
                    obj = new CodecFactoryImpl(this);
                } else {
                    if (identifier.equals("RTORB")) {
                        return this.getRTORB();
                    }
                    throw new InvalidName();
                }
            }
        }
        if (obj != null) {
            this.initial_references.put(identifier, obj);
        }
        return obj;
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    synchronized RTORB getRTORB() {
        if (this.rtORB == null) {
            this.rtORB = new RTORB(this);
        }
        return this.rtORB;
    }

    @Override
    public void register_initial_reference(String id, Object obj) throws InvalidName {
        if (id == null || id.length() == 0 || this.initial_references.containsKey(id)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + id);
        }
        this.initial_references.put(id, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    @Override
    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] req) {
        for (int i = 0; i < req.length; ++i) {
            req[i].send_oneway();
        }
    }

    @Override
    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] req) {
        for (int i = 0; i < req.length; ++i) {
            req[i].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            for (Request req : this.requests) {
                if (!req.poll_response()) continue;
                this.request = req;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request req = null;
            if (this.request != null) {
                this.request.get_response();
                req = this.request;
                this.request = null;
                return req;
            }
            block3: while (true) {
                Iterator iter = this.requests.iterator();
                do {
                    if (!iter.hasNext()) continue block3;
                } while (!(req = (Request)iter.next()).poll_response());
                break;
            }
            req.get_response();
            return req;
        }
    }

    public void addRequest(org.omg.CORBA.Request req) {
        this.requests.add(req);
    }

    public void removeRequest(org.omg.CORBA.Request req) {
        this.requests.remove(req);
    }

    @Override
    protected void set_parameters(String[] args, Properties props) {
        if (props != null) {
            Environment.addProperties(props);
        }
        this.logger = Debug.getNamedLogger("jacorb.orb");
        if (args != null) {
            this._args = args;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (!arg.startsWith("-ORB")) continue;
                int equals_pos = (arg = arg.substring(1)).indexOf(61);
                if (equals_pos == -1) {
                    String prop;
                    if (args.length - 1 < i + 1) {
                        throw new BAD_PARAM("Invalid ORBInitRef format: -ORB<option> argument without value");
                    }
                    if (arg.indexOf(46) != -1) {
                        throw new BAD_PARAM("-ORBInitRef.xxx yyy is not a valid format. Use -ORBInitRef name=value");
                    }
                    if ((equals_pos = (prop = args[++i].trim()).indexOf(61)) == -1) {
                        Environment.setProperty(arg, prop);
                        continue;
                    }
                    Environment.setProperty(arg + "." + prop.substring(0, equals_pos), prop.substring(equals_pos + 1));
                    continue;
                }
                Environment.setProperty(arg.substring(0, equals_pos), arg.substring(equals_pos + 1));
            }
        }
        ORBInitInfoImpl info = this.interceptorPreInit();
        this.policyManager = new PolicyManager(this);
        this.transport_manager = new TransportManager(this);
        this.giop_connection_manager = new GIOPConnectionManager();
        this.clientConnectionManager = new ClientConnectionManager(this, this.transport_manager, this.giop_connection_manager);
        if (Environment.cacheReferences()) {
            String s = Environment.getProperty("jacorb.hashtable_class");
            if (s == null || s.length() == 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
                }
                this.knownReferences = new HashMap();
            } else {
                try {
                    this.knownReferences = (Map)Environment.classForName(s).newInstance();
                }
                catch (Exception e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(e.getMessage());
                    }
                    this.knownReferences = new HashMap();
                }
            }
        }
        this.objectKeyMap = Environment.getProperties("jacorb.orb.objectKeyMap", true);
        String versionProperty = Environment.getProperty("jacorb.orb.print_version");
        if (versionProperty != null && versionProperty.equals("on")) {
            System.out.println("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\tJacORB V 2.1.3.7, www.jacorb.org\n\t(C) The JacORB project 29-August-2007\n\t(PrismTech Build V100413-16 (with Security and DNS))\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        this.interceptorPostInit(info);
    }

    @Override
    protected void set_parameters(Applet app, Properties props) {
        this.applet = app;
        Environment.addProperties(props);
        this.logger = Debug.getNamedLogger("jacorb.orb");
        ORBInitInfoImpl info = this.interceptorPreInit();
        this.transport_manager = new TransportManager(this);
        this.giop_connection_manager = new GIOPConnectionManager();
        this.policyManager = new PolicyManager(this);
        this.clientConnectionManager = new ClientConnectionManager(this, this.transport_manager, this.giop_connection_manager);
        if (Environment.cacheReferences()) {
            String s = Environment.getProperty("jacorb.hashtable_class");
            if (s == null || s.length() == 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
                }
                this.knownReferences = new HashMap();
            } else {
                try {
                    this.knownReferences = (Map)Environment.classForName(s).newInstance();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(e.getMessage());
                    }
                    this.knownReferences = new HashMap();
                }
            }
        }
        this.interceptorPostInit(info);
    }

    private ORBInitInfoImpl interceptorPreInit() {
        Vector orb_initializers = Environment.getORBInitializers();
        ORBInitInfoImpl info = null;
        if (orb_initializers.size() > 0) {
            info = new ORBInitInfoImpl(this);
            for (int i = 0; i < orb_initializers.size(); ++i) {
                try {
                    ORBInitializer init = (ORBInitializer)orb_initializers.elementAt(i);
                    init.pre_init(info);
                    continue;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(orb_initializers.elementAt(i).getClass() + " init failed", e);
                    }
                    if (!Environment.isPropertyOn("jacorb.orb_initializer.fail_on_error")) continue;
                    throw new INITIALIZE(orb_initializers.elementAt(i).getClass() + " pre_init() failed: " + e);
                }
            }
        }
        return info;
    }

    private void interceptorPostInit(ORBInitInfoImpl info) {
        Vector orb_initializers = Environment.getORBInitializers();
        if (orb_initializers.size() > 0) {
            for (int i = 0; i < orb_initializers.size(); ++i) {
                try {
                    ORBInitializer init = (ORBInitializer)orb_initializers.elementAt(i);
                    init.post_init(info);
                    continue;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(orb_initializers.elementAt(i).getClass() + " init failed", e);
                    }
                    if (!Environment.isPropertyOn("jacorb.orb_initializer.fail_on_error")) continue;
                    throw new INITIALIZE(orb_initializers.elementAt(i).getClass() + " post_init() failed: " + e);
                }
            }
            info.setInvalid();
            Vector client_interceptors = info.getClientInterceptors();
            Vector server_interceptors = info.getServerInterceptors();
            Vector ior_intercept = info.getIORInterceptors();
            this.hasClientInterceptors = client_interceptors.size() > 0;
            boolean bl = this.hasServerInterceptors = server_interceptors.size() > 0;
            if (this.hasClientInterceptors || this.hasServerInterceptors || ior_intercept.size() > 0) {
                this.interceptor_manager = new InterceptorManager(client_interceptors, server_interceptors, ior_intercept, info.getSlotCount(), this);
            }
            this.policy_factories = info.getPolicyFactories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean wait_for_completion) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (this.shutdown_synch) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ORB going down...");
            }
            if (Environment.useImR() && this.imr != null) {
                try {
                    if (this.getImRServerImpl() != null) {
                        this.getImRServerImpl().heartbeat(0);
                        this.imr.deregisterAll(this.getImRServerImpl().id());
                    }
                }
                catch (NotFound e) {
                    Debug.output("Internal Error - while shutting down caught " + e);
                }
            }
            if (this.shutdown_in_progress && wait_for_completion) {
                byte[] byArray = this.shutdown_synch;
                synchronized (this.shutdown_synch) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ORB going shutdown complete (1)");
                    }
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    return;
                }
            }
            if (this.shutdown_in_progress && !wait_for_completion) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB going shutdown complete (2)");
                }
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return;
            }
            this.shutdown_in_progress = true;
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            if (this.rootpoa != null) {
                this.rootpoa.destroy(true, wait_for_completion);
            }
            if (this.basicAdapter != null) {
                this.basicAdapter.stopListeners();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ORB going shutdown (cleaning up ORB...)");
            }
            this.clientConnectionManager.shutdown();
            if (Environment.cacheReferences()) {
                this.knownReferences.clear();
            }
            this.bufferManager.release();
            object = this.shutdown_synch;
            synchronized (this.shutdown_synch) {
                this.shutdown_synch.notifyAll();
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                java.lang.Object object2 = this.orb_synch;
                object = object2;
                synchronized (object2) {
                    this.run = false;
                    this.orb_synch.notifyAll();
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ORB shutdown complete");
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    @Override
    public Object string_to_object(String str) {
        this.perform_work();
        if (str == null) {
            return null;
        }
        try {
            ParsedIOR pior = new ParsedIOR(str, this);
            if (pior.isNull()) {
                return null;
            }
            return this._getDelegate(pior);
        }
        catch (Exception e) {
            this.logger.error("error during string_to_object", e);
            throw new BAD_PARAM(e.toString(), 10, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public Object get_value_def(String repid) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    @Override
    public void set_delegate(java.lang.Object wrapper) {
        if (!(wrapper instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)wrapper)._get_delegate();
        }
        catch (BAD_INV_ORDER bio) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate(delegate);
        }
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    @Override
    public String object_to_string(Object obj) {
        this.perform_work();
        if (obj == null) {
            return nullIORString;
        }
        if (obj instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)obj)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    @Override
    public void perform_work() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public boolean work_pending() {
        if (!this.run) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ORB has been shutdown");
            }
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    @Override
    public synchronized ValueFactory register_value_factory(String id, ValueFactory factory) {
        return this.valueFactories.put(id, factory);
    }

    @Override
    public synchronized void unregister_value_factory(String id) {
        this.valueFactories.remove(id);
    }

    @Override
    public synchronized ValueFactory lookup_value_factory(String id) {
        ValueFactory result = (ValueFactory)this.valueFactories.get(id);
        if (result == null && id.startsWith("IDL")) {
            String valueName = RepositoryID.className(id);
            result = this.findValueFactory(valueName);
            this.valueFactories.put(id, result);
        }
        return result;
    }

    private ValueFactory findValueFactory(String valueName) {
        Class result = null;
        result = this.findClass(valueName + "DefaultFactory", true);
        if (result != null) {
            return (ValueFactory)this.instantiate(result);
        }
        Class c = this.findClass(valueName, false);
        result = this.findClass(valueName + "Impl", false);
        if (result != null && c.isAssignableFrom(result)) {
            if (ValueFactory.class.isAssignableFrom(result)) {
                return (ValueFactory)this.instantiate(result);
            }
            return new JacORBValueFactory(result);
        }
        return null;
    }

    private Class findClass(String name, boolean orgomg) {
        Class result;
        block4: {
            result = null;
            try {
                result = Environment.classForName(name);
            }
            catch (ClassNotFoundException e) {
                if (!orgomg || !name.startsWith("org.omg")) break block4;
                try {
                    result = Environment.classForName("omg.org" + name.substring(7));
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private java.lang.Object instantiate(Class c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException("cannot instantiate class " + c.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException e2) {
            throw new RuntimeException("cannot instantiate class " + c.getName() + " (InstantiationException)");
        }
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
        }
        return this.transport_manager;
    }

    @Override
    public org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    @Override
    public org.omg.CORBA.NVList create_list(int count) {
        return new NVList(this, count);
    }

    @Override
    public org.omg.CORBA.NamedValue create_named_value(String name, Any value, int flags) {
        return new NamedValue(name, value, flags);
    }

    @Override
    public org.omg.CORBA.NVList create_operation_list(Object obj) {
        if (!(obj instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef oper = (OperationDef)obj;
        return this.create_operation_list(oper);
    }

    @Override
    public org.omg.CORBA.NVList create_operation_list(OperationDef oper) {
        int no = 0;
        ParameterDescription[] params = null;
        params = oper.params();
        if (params != null) {
            no = params.length;
        }
        NVList list = new NVList(this, no);
        block5: for (int i = 0; i < no; ++i) {
            ParameterDescription param = params[i];
            Any any = this.create_any();
            any.type(param.type);
            switch (param.mode.value()) {
                case 0: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 1);
                    continue block5;
                }
                case 1: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 2);
                    continue block5;
                }
                case 2: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 3);
                }
            }
        }
        return list;
    }

    public void addObjectKey(String key_name, String full_path) {
        this.objectKeyMap.put(key_name, full_path);
    }

    public byte[] mapObjectKey(byte[] originalKey) {
        java.lang.Object br = null;
        java.lang.Object iorFile = null;
        ParsedIOR pIOR = null;
        String found = null;
        String original = null;
        if (this.objectKeyMap.size() != 0 && (found = (String)this.objectKeyMap.get(original = new String(originalKey))) != null) {
            if (ParsedIOR.isParsableProtocol(found)) {
                try {
                    pIOR = new ParsedIOR(found, this);
                    return pIOR.get_object_key();
                }
                catch (IllegalArgumentException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error - could not read protocol " + found);
                    }
                    return originalKey;
                }
            }
            return CorbaLoc.parseKey(found);
        }
        return originalKey;
    }

    public String[] getArgs() {
        return this._args;
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private Class implementationClass;

        public JacORBValueFactory(Class c) {
            this.implementationClass = c;
        }

        @Override
        public Serializable read_value(InputStream is) {
            java.lang.Object implObj = ORB.this.instantiate(this.implementationClass);
            if (implObj instanceof Streamable) {
                StreamableValue value = (StreamableValue)ORB.this.instantiate(this.implementationClass);
                return is.read_value(value);
            }
            if (implObj instanceof CustomValue) {
                ((CustomValue)implObj).unmarshal(new DataInputStream(is));
                return (CustomValue)implObj;
            }
            throw new MARSHAL("Unknown Value type " + implObj);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        @Override
        public Any get_slot(int id) throws InvalidSlot {
            return this.getTarget().get_slot(id);
        }

        @Override
        public void set_slot(int id, Any data) throws InvalidSlot {
            this.getTarget().set_slot(id, data);
        }
    }
}

