/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import org.jacorb.util.Environment;

public class PortRangeFactory {
    public final int portMin;
    public final int portMax;

    public PortRangeFactory(String minProp, String maxProp) {
        this(PortRangeFactory.getPortProperty(minProp), PortRangeFactory.getPortProperty(maxProp));
    }

    public PortRangeFactory(int min, int max) {
        this.portMin = min;
        this.portMax = max;
        if (this.portMin > this.portMax) {
            throw new IllegalArgumentException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    private static int getPortProperty(String name) {
        int port;
        String val = Environment.getProperty(name);
        if (val == null || val.length() == 0) {
            throw new RuntimeException("PortRangeFactory: " + name + " property not set");
        }
        try {
            port = Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("PortRangeFactory: " + name + " invalid port number");
        }
        if (port < 0) {
            port += 65536;
        }
        if (port <= 0 || port > 65535) {
            throw new RuntimeException("PortRangeFactory: " + name + " invalid port number " + port);
        }
        return port;
    }
}

